/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.define.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.manage.KServiceProviderLoader;
import kd.bos.mservice.spi.define.JavaType;
import kd.bos.mservice.spi.define.MServiceDefineMeta;
import kd.bos.mservice.spi.define.MServiceDefineSPI;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MServiceResourceDefine
implements MServiceDefineSPI {
    private static final Log LOGGER = LogFactory.getLog(MServiceResourceDefine.class);
    private static final String SERVICES_DIRECTORY = "META-INF/services/";
    private static final String SERVICES_FILENAME = "MServiceDefine.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, MServiceDefineMeta> loadMetaDefine() {
        HashMap<String, MServiceDefineMeta> returnMap = new HashMap<String, MServiceDefineMeta>(2);
        Set<String> mserviceNames = KServiceProviderLoader.loadKservice(this.type(), this.getClass().getClassLoader());
        if (CollectionUtils.isEmpty(mserviceNames)) {
            return returnMap;
        }
        String xmlPath = "META-INF/services/MServiceDefine.xml";
        try {
            InputStream inputStream = null;
            Enumeration<URL> urls = this.getClass().getClassLoader().getResources(xmlPath);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                inputStream = url.openStream();
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document doc = builder.parse(inputStream);
                    Element root = (Element)doc.getElementsByTagName("services").item(0);
                    NodeList nodeList = root.getElementsByTagName("service");
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Element ele = (Element)nodeList.item(i);
                        String serviceName = MServiceResourceDefine.getSingleElementValue(ele, "name");
                        try {
                            MServiceDefineMeta mserviceDefineMeta = MServiceResourceDefine.parseService(ele);
                            if (!MServiceResourceDefine.checkResourceMService(mserviceNames, mserviceDefineMeta.getServiceImplClass())) continue;
                            returnMap.put(mserviceDefineMeta.getServiceName(), mserviceDefineMeta);
                            continue;
                        }
                        catch (Exception ex) {
                            LOGGER.error("load service error,serviceName:{},errorMsg:{}", (Object)serviceName, (Object)ex.getMessage());
                        }
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("load {} error,errMsg:{}", (Object)SERVICES_FILENAME, (Object)exception.getMessage());
                }
                finally {
                    try {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                    catch (Error | Exception throwable) {}
                }
            }
        }
        catch (IOException ioException) {
            LOGGER.error("find resourceFile error,path:{},errMsg:{}", (Object)xmlPath, (Object)ioException.getMessage());
        }
        return returnMap;
    }

    private static boolean checkResourceMService(Set<String> mserviceNames, String className) {
        for (String tempMserviceName : mserviceNames) {
            if (!className.startsWith(tempMserviceName)) continue;
            return true;
        }
        return false;
    }

    private static MServiceDefineMeta parseService(Element ele) {
        String dataCodecs;
        MServiceDefineMeta mserviceDefineMeta = new MServiceDefineMeta();
        String group = MServiceResourceDefine.getSingleElementValue(ele, "group");
        String name = MServiceResourceDefine.getSingleElementValue(ele, "name");
        mserviceDefineMeta.setServiceGroupAndName(group, name);
        String appIds = MServiceResourceDefine.getSingleElementValue(ele, "appIds");
        if (appIds != null && appIds.length() > 0) {
            mserviceDefineMeta.setAppIds(appIds.split(","));
        }
        String interfaceImplName = MServiceResourceDefine.getSingleElementValue(ele, "interfaceImplClass");
        mserviceDefineMeta.setServiceImplClass(interfaceImplName);
        String interfaceName = MServiceResourceDefine.getSingleElementValue(ele, "interfaceClass");
        mserviceDefineMeta.setServiceInterface(interfaceName != null ? interfaceName : interfaceImplName);
        MServiceResourceDefine.loadClass(mserviceDefineMeta.getServiceInterface());
        MServiceResourceDefine.loadClass(mserviceDefineMeta.getServiceImplClass());
        String transProtocolTypes = MServiceResourceDefine.getSingleElementValue(ele, "transProtocolTypes");
        if (transProtocolTypes != null && transProtocolTypes.length() > 0) {
            String[] transProtocolTypeArray;
            for (String tempTransProtocolType : transProtocolTypeArray = transProtocolTypes.split(",")) {
                mserviceDefineMeta.addTransProtocolTypes(tempTransProtocolType);
            }
        }
        if ((dataCodecs = MServiceResourceDefine.getSingleElementValue(ele, "dataCodecs")) != null && dataCodecs.length() > 0) {
            String[] dataCodecArray;
            for (String tempDataCodec : dataCodecArray = dataCodecs.split(",")) {
                mserviceDefineMeta.addDataCodecs(tempDataCodec);
            }
        }
        mserviceDefineMeta.setServiceDesc(MServiceResourceDefine.getSingleElementValue(ele, "desc"));
        MServiceResourceDefine.parseMethods(ele.getElementsByTagName("methods"), mserviceDefineMeta);
        return mserviceDefineMeta;
    }

    private static void parseMethods(NodeList methodsNodeList, MServiceDefineMeta mserviceDefineMeta) {
        for (int i = 0; i < methodsNodeList.getLength(); ++i) {
            Element methodItemElement = (Element)methodsNodeList.item(i);
            NodeList methodNodeList = methodItemElement.getElementsByTagName("method");
            for (int j = 0; j < methodNodeList.getLength(); ++j) {
                methodItemElement = (Element)methodNodeList.item(j);
                String methodName = MServiceResourceDefine.getSingleElementValue(methodItemElement, "method-name");
                String methodPath = MServiceResourceDefine.getSingleElementValue(methodItemElement, "method-path");
                String methodReturnType = MServiceResourceDefine.getSingleElementValue(methodItemElement, "method-returnType");
                String methodDesc = MServiceResourceDefine.getSingleElementValue(methodItemElement, "method-desc");
                MServiceDefineMeta.MethodDefine methodDefine = new MServiceDefineMeta.MethodDefine();
                methodDefine.setServiceMethodName(methodName);
                methodDefine.setServiceMethodPath(methodPath);
                methodDefine.setServiceMethodReturnObjectType(methodReturnType);
                methodDefine.setServiceMethodDesc(methodDesc);
                MServiceResourceDefine.parseParams(methodItemElement.getElementsByTagName("params"), methodDefine);
                mserviceDefineMeta.addMethod(methodDefine);
            }
        }
    }

    private static void parseParams(NodeList paramsNodeList, MServiceDefineMeta.MethodDefine methodDefine) {
        for (int i = 0; i < paramsNodeList.getLength(); ++i) {
            ArrayList<MServiceDefineMeta.ParamDefine> paramDefineList = new ArrayList<MServiceDefineMeta.ParamDefine>(paramsNodeList.getLength());
            Element paramItemElement = (Element)paramsNodeList.item(i);
            NodeList paramNodeList = paramItemElement.getElementsByTagName("param");
            for (int j = 0; j < paramNodeList.getLength(); ++j) {
                paramItemElement = (Element)paramNodeList.item(j);
                String paramName = MServiceResourceDefine.getSingleElementValue(paramItemElement, "param-name");
                String paramType = MServiceResourceDefine.getSingleElementValue(paramItemElement, "param-type");
                MServiceDefineMeta.ParamDefine paramDefine = new MServiceDefineMeta.ParamDefine();
                paramDefine.setName(paramName);
                paramDefine.withType(JavaType.getType((String)paramType));
                paramDefineList.add(paramDefine);
            }
            methodDefine.setServiceMethodParams(paramDefineList);
        }
    }

    private static void loadClass(String classNameStr) {
        try {
            if (StringUtils.isNotEmpty((String)classNameStr)) {
                Class.forName(classNameStr, false, MServiceResourceDefine.class.getClassLoader());
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.cannotLoadBeanClass, new Object[]{"Can't create class by " + classNameStr});
        }
    }

    private static String getSingleElementValue(Element element, String nameStr) {
        NodeList nodes = element.getElementsByTagName(nameStr);
        if (nodes.getLength() == 0 || nodes.item(0).getFirstChild() == null) {
            return null;
        }
        return nodes.item(0).getFirstChild().getNodeValue();
    }

    public String type() {
        return "resource";
    }
}

