/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.define.springmvc;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import kd.bos.mservice.define.springmvc.BosRequestMappingHandlerMapping;
import kd.bos.mservice.spi.define.MServiceDefineMeta;
import kd.bos.mservice.spi.define.MServiceParameterParser;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;

public class SpringMVCServiceMetaFactory {
    private static final BosRequestMappingHandlerMapping bosHandlerMapping = new BosRequestMappingHandlerMapping();

    protected static MServiceDefineMeta createMServiceDefineMeta(String serviceName) {
        Class<?> mserviceDefineClass = null;
        try {
            mserviceDefineClass = Class.forName(serviceName, false, SpringMVCServiceMetaFactory.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (mserviceDefineClass == null || !bosHandlerMapping.isHandler(mserviceDefineClass)) {
            return null;
        }
        Class<?>[] interfaces = mserviceDefineClass.getInterfaces();
        bosHandlerMapping.detectHandlerMethods(mserviceDefineClass);
        List<BosRequestMappingHandlerMapping.MserviceUriMethod> mserviceUriMethods = bosHandlerMapping.getBosUriMethods(serviceName);
        MServiceDefineMeta mdm = null;
        boolean hasAddInterfaceMservice = false;
        for (BosRequestMappingHandlerMapping.MserviceUriMethod mserviceUriMethod : mserviceUriMethods) {
            if (!hasAddInterfaceMservice) {
                hasAddInterfaceMservice = true;
                mdm = new MServiceDefineMeta();
                mdm.setGroup("springmvc");
                mdm.setServiceName(interfaces.length > 0 ? interfaces[0].getName() : mserviceDefineClass.getName());
                mdm.setServiceImplClass(serviceName);
                mdm.setAppIds(new String[]{"*"});
                mdm.setServiceDesc(mserviceDefineClass.getName());
                mdm.setServiceInterface(interfaces.length > 0 ? interfaces[0].getName() : mserviceDefineClass.getName());
                mdm.addTransProtocolTypes("http");
                mdm.addDataCodecs("json");
            }
            HandlerMethod handlerMethod = mserviceUriMethod.getHandlerMethod();
            Method method = handlerMethod.getMethod();
            String path = mserviceUriMethod.getOriginalUri();
            MServiceDefineMeta.MethodDefine methodDefine = new MServiceDefineMeta.MethodDefine();
            mdm.addMethod(methodDefine);
            methodDefine.setServiceMethodName(method.getName());
            methodDefine.setServiceMethodPath(path);
            methodDefine.setServiceMethodDesc(handlerMethod.getShortLogMessage() + ",path: " + path);
            methodDefine.setServiceMethodReturnObjectType(method.getGenericReturnType().getTypeName());
            methodDefine.setServiceMethodReturnParamDefine(MServiceParameterParser.parseParam((Type)handlerMethod.getMethod().getGenericReturnType()));
            MethodParameter[] methodParameters = handlerMethod.getMethodParameters();
            String[] parameterNames = MServiceParameterParser.getParameterNames((Method)method);
            for (int i = 0; i < methodParameters.length; ++i) {
                String paramName;
                MethodParameter methodParameter = methodParameters[i];
                boolean required = true;
                RequestParam requestParamAnnotation = (RequestParam)methodParameter.getParameterAnnotation(RequestParam.class);
                PathVariable pathVariableAnnotation = (PathVariable)methodParameter.getParameterAnnotation(PathVariable.class);
                if (requestParamAnnotation != null && !requestParamAnnotation.value().isEmpty()) {
                    paramName = requestParamAnnotation.value();
                    required = requestParamAnnotation.required();
                } else if (pathVariableAnnotation != null && !pathVariableAnnotation.value().isEmpty()) {
                    paramName = pathVariableAnnotation.value();
                    required = pathVariableAnnotation.required();
                } else {
                    paramName = methodParameter.getParameterName();
                    if (paramName == null) {
                        paramName = parameterNames[methodParameter.getParameterIndex()];
                    }
                }
                MServiceDefineMeta.ParamDefine pd = MServiceParameterParser.parseParam((String)paramName, (Parameter)method.getParameters()[i]);
                pd.setRequired(required);
                methodDefine.addServiceMethodParam(pd);
            }
        }
        return mdm;
    }
}

