/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.manage;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.catalog.ServiceCatalogFactory;
import kd.bos.mservice.spi.define.MServiceDefineMeta;
import kd.bos.util.StringUtils;

public class MServiceMetaManage {
    private static Log log = LogFactory.getLog(MServiceMetaManage.class);
    private static Map<String, MServiceDefineMeta> mserviceDefines = Collections.emptyMap();
    private static Map<String, String> urlServiceNameMap = new ConcurrentHashMap<String, String>();
    private static Set<String> transProtocolTypes = new HashSet<String>(2);

    private static void init() {
        mserviceDefines = ServiceCatalogFactory.getCatalog().getAllServiceDefine();
        mserviceDefines.forEach((k, v) -> {
            if (v.getTransProtocolTypes() != null) {
                transProtocolTypes.addAll(v.getTransProtocolTypes());
            }
            if (v.getMethods() != null && v.getMethods().size() > 0) {
                for (MServiceDefineMeta.MethodDefine methodDefine : v.getMethods()) {
                    if (!StringUtils.isNotEmpty((String)methodDefine.getServiceMethodPath())) continue;
                    urlServiceNameMap.put(methodDefine.getServiceMethodPath(), (String)k);
                }
            }
        });
    }

    public static MServiceDefineMeta getServiceDefine(String serviceName) {
        return mserviceDefines.get(serviceName);
    }

    public static MServiceDefineMeta getServiceDefineByPath(String path) {
        String thePath = urlServiceNameMap.get(path);
        if (null == thePath) {
            return null;
        }
        return MServiceMetaManage.getServiceDefine(thePath);
    }

    public static Set<String> getServiceRegistryTypeConsumer() {
        return transProtocolTypes;
    }

    public static Set<String> getServiceRegistryTypeProvider() {
        return transProtocolTypes;
    }

    static {
        try {
            MServiceMetaManage.init();
        }
        catch (Exception e) {
            log.error("MserviceDefiner init error", (Throwable)e);
        }
    }
}

