/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.exception;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bundle.Resources;
import kd.bos.instance.Instance;
import kd.bos.util.StringUtils;

public enum DubboErrorCode {
    consumerClusterDestory(1000),
    consumerClusterNoProvider(4),
    consumerInvokerNotFound(1001),
    consumerProviderNetworkClose(1002),
    consumerSendChannelClose(1004),
    webRequestTimeOut(1006),
    consumerNetwork(1007),
    consumerTimeOut(1008),
    providerExecute(2000),
    providerTimeOut(2004),
    providerSendChanelClose(2006),
    providerNotResponse(2008);

    public static final String PROJECT_NAME = "bos-exception";
    public static final String PREFIX_ERROR_CODE = "DubboErrorCode_";
    private static final Pattern INSTANCE_PATTERN;
    private static final Pattern TIMEOUT_PATTERN;
    private static final Pattern IP_PATTERN;
    public final int code;

    public static String getMsgByCode(int code, String apiName, String appIdName, String logId, Throwable e) {
        return DubboErrorCode.getMsgByCode(code, apiName, appIdName, logId, null, e);
    }

    public static String getMsgByCode(int code, String apiName, String appIdName, String logId, String timeoutParam, Throwable e) {
        String msg;
        if (!"true".equals(System.getProperty("dubbo.show.errorcode", "true"))) {
            return null;
        }
        String timeout = timeoutParam;
        switch (code) {
            case 1000: {
                msg = Resources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + consumerClusterDestory.getCode()), (String)"", (Object[])new Object[]{apiName, appIdName, logId});
                break;
            }
            case 4: {
                msg = Resources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + consumerClusterNoProvider.getCode()), (String)"", (Object[])new Object[]{apiName, appIdName, logId});
                break;
            }
            case 1001: {
                msg = Resources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + consumerInvokerNotFound.getCode()), (String)"", (Object[])new Object[]{apiName, appIdName, logId});
                break;
            }
            case 1002: {
                msg = Resources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + consumerProviderNetworkClose.getCode()), (String)"", (Object[])new Object[]{apiName, appIdName, logId});
                break;
            }
            case 1004: {
                String remoteIp = DubboErrorCode.getRemoteIp(e);
                msg = Resources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + consumerSendChannelClose.getCode()), (String)"", (Object[])new Object[]{apiName, remoteIp, logId});
                break;
            }
            case 1006: {
                List<String> timeList = DubboErrorCode.getWebRequestTimeout(e);
                msg = Resources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + webRequestTimeOut.getCode()), (String)"", (Object[])new Object[]{apiName, timeList.get(0), timeList.get(1), logId});
                break;
            }
            case 1007: {
                msg = Resources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + consumerNetwork.getCode()), (String)"", (Object[])new Object[]{apiName, logId});
                break;
            }
            case 1008: {
                timeout = DubboErrorCode.getTimeout(e);
                msg = Resources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + consumerTimeOut.getCode()), (String)"", (Object[])new Object[]{apiName, timeout, logId});
                break;
            }
            case 2000: {
                String instanceId = DubboErrorCode.getInstanceId(e);
                msg = Resources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + providerExecute.getCode()), (String)"", (Object[])new Object[]{apiName, appIdName, instanceId, logId});
                break;
            }
            case 2004: {
                if (StringUtils.isEmpty((String)timeout)) {
                    timeout = DubboErrorCode.getTimeout(e);
                }
                String instanceId = DubboErrorCode.getInstanceId(e);
                msg = Resources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + providerTimeOut.getCode()), (String)"", (Object[])new Object[]{apiName, appIdName, instanceId, timeout, logId});
                break;
            }
            case 2006: {
                String remoteIp = DubboErrorCode.getRemoteIp(e);
                msg = Resources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + providerSendChanelClose.getCode()), (String)"", (Object[])new Object[]{apiName, remoteIp, logId});
                break;
            }
            case 2008: {
                String instanceId = DubboErrorCode.getInstanceId(e);
                timeout = DubboErrorCode.getTimeout(e);
                msg = Resources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + providerNotResponse.getCode()), (String)"", (Object[])new Object[]{apiName, timeout, appIdName, instanceId, logId});
                break;
            }
            default: {
                msg = null;
            }
        }
        return msg;
    }

    public static String getInstanceId(Throwable e) {
        String instanceId = "";
        if (e.getMessage() != null) {
            String errorMsg = e.getMessage();
            Matcher matcher = INSTANCE_PATTERN.matcher(errorMsg);
            while (matcher.find()) {
                instanceId = matcher.group(1);
                if (!"null".equalsIgnoreCase(instanceId)) continue;
                instanceId = "";
            }
        }
        if (StringUtils.isNotEmpty((String)instanceId)) {
            String prefix = Instance.getClusterName().replace("_", "-") + "-";
            instanceId = instanceId.replace(prefix, "");
            instanceId = "(" + instanceId + ")";
        }
        return instanceId;
    }

    public static List<String> getWebRequestTimeout(Throwable e) {
        ArrayList<String> timeList = new ArrayList<String>(2);
        String costTime = "";
        String timeout = "";
        if (e.getMessage() != null) {
            String errorMsg = e.getMessage();
            int firstIndex = errorMsg.indexOf("taken:");
            int secondIndex = errorMsg.indexOf("the timeout is:");
            if (firstIndex > -1 && secondIndex > -1) {
                costTime = errorMsg.substring(firstIndex + "taken: ".length(), secondIndex - 3);
            }
            timeout = errorMsg.substring(secondIndex + "the timeout is: ".length(), errorMsg.length() - 2);
        }
        timeList.add(costTime);
        timeList.add(timeout);
        return timeList;
    }

    public static String getTimeout(Throwable e) {
        String timeout = "";
        if (e.getMessage() != null) {
            String errorMsg = e.getMessage();
            Matcher matcher = TIMEOUT_PATTERN.matcher(errorMsg);
            while (matcher.find()) {
                timeout = matcher.group(1);
            }
        }
        if (StringUtils.isEmpty((String)timeout)) {
            timeout = "180";
        }
        return timeout;
    }

    public static String getRemoteIp(Throwable e) {
        String remoteIp = "";
        if (e.getMessage() != null) {
            String errorMsg = e.getMessage();
            Matcher matcher = IP_PATTERN.matcher(errorMsg);
            while (matcher.find()) {
                remoteIp = matcher.group(1);
            }
        }
        return remoteIp;
    }

    private DubboErrorCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    static {
        INSTANCE_PATTERN = Pattern.compile("instanceId=(.*) @end");
        TIMEOUT_PATTERN = Pattern.compile("timeout=(\\d+) #end");
        IP_PATTERN = Pattern.compile("remoteIp=((\\d{1,3}\\.){3}\\d{1,3});");
    }
}

