/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.ErrorMessageProviderFactory;
import kd.bos.lang.Lang;
import kd.bos.thread.OutOfMemoryObserver;

public class KDExceptionKit {
    public static RuntimeException wrapRuntimeException(Throwable e) {
        OutOfMemoryObserver.onThrowable((Throwable)e);
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        try {
            if (e == null) {
                return new RuntimeException("WrapRuntimeException fail,src is null,current stack is " + KDExceptionKit.getWrapStack());
            }
            return new RuntimeException(e.getMessage(), e);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder("WrapRuntimeException fail,src exception class: ").append(e == null ? "null" : e.getClass().getName()).append(" ,wrap error msg: ").append(ex.getMessage()).append(" ,stack:").append(KDExceptionKit.getWrapStack());
            return new RuntimeException(msg.toString());
        }
    }

    private static String getWrapStack() {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        new Throwable().printStackTrace(writer);
        writer.flush();
        return sw.toString();
    }

    public static String formatErrorMessage(ErrorCode errorCode, Object ... args) {
        Lang lang = Lang.get();
        String format = ErrorMessageProviderFactory.getProvider().getMessage(errorCode, lang);
        if (format == null) {
            format = errorCode.getMessage();
        }
        if (args == null || args.length == 0) {
            return format;
        }
        return String.format(lang == null ? Lang.defaultLang().getLocale() : lang.getLocale(), format, args);
    }

    public static Map<String, String> getErrorCodes(Class<?> ... errorClasses) {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        if (errorClasses != null) {
            try {
                for (Class<?> cls : errorClasses) {
                    for (Field f : cls.getFields()) {
                        if (!Modifier.isStatic(f.getModifiers()) || !ErrorCode.class.isAssignableFrom(f.getType())) continue;
                        ErrorCode ec = (ErrorCode)f.get(null);
                        ret.put(ec.getCode(), ec.getMessage());
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }
}

