/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.exception;

import java.sql.SQLException;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.XDBErrorCode;

public class SecureExceptionUtil {
    public static void rethrowSQLException(SQLException e) throws SQLException {
        if (SecureExceptionUtil.isShowSqlError()) {
            throw e;
        }
        throw new KDException(BosErrorCode.sQL, "sql exception");
    }

    public static KDException wrapSQLException(SQLException e) {
        if (SecureExceptionUtil.isShowSqlError()) {
            return new KDException(e, BosErrorCode.sQL, e.getMessage());
        }
        return new KDException(BosErrorCode.sQL, "sql exception");
    }

    public static KDException wrapSQLException(ErrorCode errorCode, SQLException e) {
        if (SecureExceptionUtil.isShowSqlError()) {
            return new KDException(e, errorCode, e.getMessage());
        }
        return new KDException(errorCode, "sql exception");
    }

    public static KDException wrapSQLTimeoutException(SQLException e) {
        if (SecureExceptionUtil.isShowSqlError()) {
            return new KDException(e, BosErrorCode.sQLRWTimeOut, e.getMessage());
        }
        return new KDException(BosErrorCode.sQLRWTimeOut, "sql exception");
    }

    public static KDException wrapExceedShardingTbQueryLimitException(SQLException e) {
        if (SecureExceptionUtil.isShowSqlError()) {
            return new KDException(e, XDBErrorCode.exceedShardingTableQueryLimit, e.getMessage());
        }
        return new KDException(XDBErrorCode.exceedShardingTableQueryLimit, "sql exception");
    }

    public static KDException wrapDuplicateKeyException(SQLException e) {
        if (SecureExceptionUtil.isShowSqlError()) {
            return new KDException(e, BosErrorCode.sQLDuplicateKey, e.getMessage());
        }
        return new KDException(BosErrorCode.sQLDuplicateKey, "sql exception");
    }

    public static KDException wrapXdbRouteInconsistency(SQLException e) {
        if (SecureExceptionUtil.isShowSqlError()) {
            return new KDException(e, XDBErrorCode.xdbRouteInconsistency, e.getMessage());
        }
        return new KDException(XDBErrorCode.xdbRouteInconsistency, "sql exception");
    }

    public static KDException wrapXdbMultiDBWrited(SQLException e) {
        if (SecureExceptionUtil.isShowSqlError()) {
            return new KDException(e, XDBErrorCode.xdbMultiDBWrited, e.getMessage());
        }
        return new KDException(XDBErrorCode.xdbMultiDBWrited, "sql exception");
    }

    public static boolean isShowSqlError() {
        return Boolean.parseBoolean(System.getProperty("sql.exception.showflag", "true"));
    }
}

