/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter;

import java.time.Instant;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.limiter.AbstractLimiter;
import kd.bos.limiter.JClient;
import kd.bos.limiter.conf.RateLimiterConfig;
import kd.bos.limiter.scene.ConcurrentScene;
import kd.bos.limiter.scene.ConcurrentSceneManager;
import kd.bos.redis.JedisClient;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateLimiter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DuplicateLimiter.class);
    public static final String regex = "^[a-zA-Z0-9_]+$";
    public static final String LUA_SCRIPT = "redis.call('zremrangebyscore', KEYS[1], 0, ARGV[1]) return redis.call('zadd', KEYS[1], 'NX', ARGV[2], ARGV[3]) ";
    private static final ExecutorService service = new ThreadPoolExecutor(RateLimiterConfig.getDuplicateCoreSize(), RateLimiterConfig.getDuplicateMaxSize(), 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(RateLimiterConfig.getQueueCapacity()), new ThreadPoolExecutor.DiscardPolicy());

    public static boolean acquire(String sceneCode, String bizCode, String uniqueID, long timeout) {
        ConcurrentScene scene;
        if (StringUtils.isEmpty((String)sceneCode) || StringUtils.isEmpty((String)bizCode) || StringUtils.isEmpty((String)uniqueID) || timeout <= 0L) {
            LOGGER.error("params input were error.");
            return true;
        }
        if (!bizCode.matches(regex)) {
            LOGGER.warn("bizCode is invalid.");
            return true;
        }
        if (uniqueID.length() > 1000) {
            LOGGER.warn("uniqueID is too long.");
            return true;
        }
        int max = 300;
        if (timeout > (long)max) {
            timeout = max;
        }
        if ((scene = ConcurrentSceneManager.getScene(sceneCode)) == null) {
            LOGGER.error("the scene doesn't exist. sceneCode=" + sceneCode);
            return true;
        }
        if (scene.getLimitType() != 1) {
            return true;
        }
        if (!scene.isLimitEnable()) {
            return true;
        }
        String key = AbstractLimiter.getStoreKey(sceneCode, bizCode);
        Future<Boolean> future = service.submit(() -> {
            long now = Instant.now().toEpochMilli();
            String argv1 = Long.toString(now - TimeUnit.MILLISECONDS.convert(scene.getDuplicateWindowTime(), TimeUnit.SECONDS));
            String argv2 = Long.toString(now);
            long ret = 1L;
            try (JedisClient jedis = JClient.get();){
                ret = (Long)jedis.eval(LUA_SCRIPT, 1, new String[]{key, argv1, argv2, uniqueID});
            }
            catch (Exception e) {
                LOGGER.error("get redis client error", (Throwable)e);
            }
            return ret == 1L;
        });
        boolean ret = true;
        try {
            ret = future.get(timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.error("acquire error", (Throwable)e);
        }
        return ret;
    }

    public static boolean acquire(String sceneCode, String bizCode, String uniqueID) {
        return DuplicateLimiter.acquire(sceneCode, bizCode, uniqueID, 10L);
    }
}

