/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.algorithm;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.limiter.algorithm.ThreadCount;
import kd.bos.limiter.scene.Scene;

public class Counter
extends ThreadCount {
    public Counter(Scene scene) {
        super(scene);
    }

    @Override
    public void check() {
        long maxCount = this.scene.getMaxCount();
        long accessCount = (Long)this.getCountInThread();
        if (accessCount >= this.scene.getMaxCount()) {
            throw new KDException(BosErrorCode.limitOverMaxCount, new Object[]{"Operate was terminated by Limiter. code: " + this.scene.getCode() + " maxCount: " + maxCount});
        }
        this.setCountIntoThread(++accessCount);
    }
}

