/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.algorithm;

import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.govern.eventdata.types.LimitEvent;
import kd.bos.limiter.scene.Scene;
import kd.bos.limiter.scheduler.SlidingWindowScheduler;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;

public class SlidingWindowCluster {
    private final Scene scene;
    private final long windowTime;
    public static final String REDIS_KEY_PREFIX = "LIMITER_SLIDING_WINDOW_";
    public final String redisKey;
    public AtomicLong tempCounter = new AtomicLong(0L);

    public SlidingWindowCluster(Scene scene, String accountId) {
        this.scene = scene;
        this.redisKey = REDIS_KEY_PREFIX + accountId + "_" + scene.getCode();
        this.windowTime = TimeUnit.MILLISECONDS.convert(scene.getWindowTime(), scene.getWindowTimeUnit());
    }

    public void allowRequest() {
        if (this.scene.isAsync()) {
            long count;
            try (JedisClient jedis = SlidingWindowCluster.getJedisClient();){
                count = jedis.zcard(this.getAsyncKey());
            }
            if (count >= this.scene.getMaxCount()) {
                String msg = "Operate was terminated by Limiter. code: " + this.scene.getName() + " maxCount: " + this.scene.getMaxCount();
                EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
                throw new KDException(BosErrorCode.limitOverMaxCount, new Object[]{msg});
            }
            SlidingWindowScheduler.getInstance();
            this.tempCounter.incrementAndGet();
        } else {
            long ret;
            String luaScript = "redis.call('zremrangebyscore', KEYS[1], 0, ARGV[2]) local num = redis.call('zcard', KEYS[1]) if num < tonumber(ARGV[3]) then redis.call('zadd', KEYS[1], ARGV[1], ARGV[1]) return 1 else return 0 end";
            long now = Instant.now().toEpochMilli();
            String timestamp = Long.toString(now);
            String start = Long.toString(now - this.windowTime);
            String limit = Long.toString(this.scene.getMaxCount());
            try (JedisClient jedis = SlidingWindowCluster.getJedisClient();){
                ret = (Long)jedis.eval(luaScript, 1, new String[]{this.redisKey, timestamp, start, limit});
            }
            if (ret == 0L) {
                String msg = "Operate was terminated by Limiter. code: " + this.scene.getName() + " maxCount: " + this.scene.getMaxCount();
                EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
                throw new KDException(BosErrorCode.limitOverMaxCount, new Object[]{msg});
            }
        }
    }

    public static JedisClient getJedisClient() {
        String configKey = CacheConfigKeys.getSessionlessConfigKey((String)"rate_limiter");
        String url = System.getProperty(configKey);
        if (url == null) {
            configKey = CacheConfigKeys.getSessionlessConfigKey(null);
            url = System.getProperty(configKey);
        }
        return RedisFactory.getJedisClient((String)url);
    }

    public boolean getIsAsync() {
        return this.scene.isAsync();
    }

    public String getAsyncKey() {
        return this.redisKey + "_ASYNC";
    }

    public long getWindowTime() {
        return this.scene.getWindowTime();
    }

    public long getMaxCount() {
        return this.scene.getMaxCount();
    }
}

