/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.algorithm;

import java.time.Instant;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.govern.eventdata.types.LimitEvent;
import kd.bos.limiter.algorithm.ThreadCount;
import kd.bos.limiter.scene.Scene;
import kd.bos.thread.ThreadTruck;

public class SlidingWindowThread
extends ThreadCount {
    private final long windowTime;
    private static final String PREFIX_QUEUE = "LIMITER_QUEUE_";
    private String threadQueueKey;

    public SlidingWindowThread(Scene scene) {
        super(scene);
        this.windowTime = TimeUnit.MILLISECONDS.convert(scene.getWindowTime(), scene.getWindowTimeUnit());
        this.threadQueueKey = PREFIX_QUEUE + scene.getCode();
    }

    @Override
    protected void check() {
        Instant now = Instant.now();
        Queue<Instant> requests = this.getQueue();
        while (!requests.isEmpty() && now.toEpochMilli() - requests.peek().toEpochMilli() > this.windowTime) {
            requests.poll();
        }
        if ((long)requests.size() >= this.scene.getMaxCount()) {
            String msg = "Operate was terminated by Limiter. code: " + this.scene.getName() + " maxCount: " + this.scene.getMaxCount();
            EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
            throw new KDException(BosErrorCode.limitOverMaxCount, new Object[]{msg});
        }
        requests.add(now);
        this.setQueue(requests);
    }

    private Queue<Instant> getQueue() {
        Object queue = ThreadTruck.get((Object)this.threadQueueKey);
        if (queue == null) {
            LinkedList<Instant> requests = new LinkedList<Instant>();
            ThreadTruck.put((Object)this.threadQueueKey, requests);
            return requests;
        }
        return (Queue)queue;
    }

    private void setQueue(Queue<Instant> requests) {
        ThreadTruck.put((Object)this.threadQueueKey, requests);
    }
}

