/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.impl;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.govern.eventdata.types.LimitEvent;
import kd.bos.limiter.AbstractLimiter;
import kd.bos.limiter.constant.Range;
import kd.bos.limiter.exception.AcquireFailedException;
import kd.bos.limiter.impl.ClusterConcurrencyLimiter;
import kd.bos.limiter.impl.ClusterSlowRecorder;
import kd.bos.limiter.impl.NodeConcurrencyLimiter;
import kd.bos.limiter.scene.ConcurrentInstance;
import kd.bos.limiter.scene.ConcurrentScene;
import kd.bos.limiter.scene.ConcurrentSceneManager;
import kd.bos.monitor.sdk.KDCounter;
import kd.bos.redis.JedisClient;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrencyLimiter
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrencyLimiter.class);
    private static final String NO_LIMIT_ID = "-1";
    private int range;
    public AbstractLimiter limiter;
    private boolean noLimit = false;
    public static final String regex = "^[a-zA-Z0-9_:.]+$";
    public static final KDCounter counter = KDCounter.build((String)"concurrency_rate_limiter", (String)"Concurrency Rate Limiter", (String[])new String[]{"limit_range"});

    public static ConcurrencyLimiter acquire(String sceneCode, String bizCode, boolean isHeartbeat) {
        ConcurrentScene scene;
        if (StringUtils.isEmpty((String)sceneCode) || StringUtils.isEmpty((String)bizCode)) {
            LOGGER.warn("sceneCode or bizCode was empty.");
            return ConcurrencyLimiter.getNoLimiter();
        }
        if (bizCode.length() > 1000) {
            LOGGER.warn("bizCode is invalid.");
            return ConcurrencyLimiter.getNoLimiter();
        }
        RequestContext context = RequestContext.get();
        if (context == null || StringUtils.isEmpty((String)context.getTenantId())) {
            return ConcurrencyLimiter.getNoLimiter();
        }
        ConcurrentScene originalScene = ConcurrentSceneManager.scenes.get(sceneCode);
        if (originalScene == null) {
            LOGGER.warn("There wasn't the matching scene for this sceneCode:" + sceneCode);
            return ConcurrencyLimiter.getNoLimiter();
        }
        if (originalScene.getLimitType() != 0) {
            return ConcurrencyLimiter.getNoLimiter();
        }
        if (!originalScene.isLimitEnable()) {
            return ConcurrencyLimiter.getNoLimiter();
        }
        try {
            scene = (ConcurrentScene)originalScene.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error(e.getMessage());
            scene = originalScene;
        }
        int range = scene.getRange();
        ConcurrencyLimiter concurrencyLimiter = new ConcurrencyLimiter();
        concurrencyLimiter.range = range;
        if (range == Range.CLUSTER.getCode()) {
            ClusterConcurrencyLimiter clusterLimiter = new ClusterConcurrencyLimiter(scene, bizCode);
            if (isHeartbeat) {
                clusterLimiter.setHeartbeat(true);
            }
            if (!clusterLimiter.allow()) {
                String msg = String.format("Operation has been rate-limited [%s](%s), the maximum concurrency is %s", scene.getSceneName(), scene.getSceneCode(), scene.getConcurrency());
                LOGGER.error(msg);
                EventDataReporter.report((EventType)LimitEvent.FunctionLimitEvent.getInstance(), (String)msg);
                counter.labels(new String[]{Range.CLUSTER.name()}).inc();
                throw new AcquireFailedException();
            }
            concurrencyLimiter.limiter = clusterLimiter;
        }
        if (range == Range.NODE.getCode()) {
            NodeConcurrencyLimiter nodeLimiter = new NodeConcurrencyLimiter(scene, bizCode);
            if (isHeartbeat) {
                nodeLimiter.setHeartbeat(true);
            }
            if (!nodeLimiter.allow()) {
                String msg = String.format("Operation has been rate-limited [%s](%s), the maximum concurrency is %s", scene.getSceneName(), scene.getSceneCode(), scene.getConcurrency());
                LOGGER.error(msg);
                EventDataReporter.report((EventType)LimitEvent.FunctionLimitEvent.getInstance(), (String)msg);
                counter.labels(new String[]{Range.NODE.name()}).inc();
                throw new AcquireFailedException();
            }
            concurrencyLimiter.limiter = nodeLimiter;
        }
        return concurrencyLimiter;
    }

    public static ConcurrencyLimiter acquire(String sceneCode, String bizCode) {
        return ConcurrencyLimiter.acquire(sceneCode, bizCode, false);
    }

    public static void release(String concurrentID) {
        ConcurrentScene scene;
        ConcurrentInstance instance;
        if (NO_LIMIT_ID.equals(concurrentID)) {
            return;
        }
        try {
            instance = AbstractLimiter.decode(concurrentID);
        }
        catch (Exception e) {
            LOGGER.error("decode failed. concurrentID = " + concurrentID + ", " + e.getMessage());
            return;
        }
        if (instance != null && (scene = ConcurrentSceneManager.scenes.get(instance.getSceneCode())) != null) {
            int sceneRange = scene.getRange();
            if (sceneRange == Range.CLUSTER.getCode()) {
                ClusterConcurrencyLimiter.release(concurrentID);
            }
            if (sceneRange == Range.NODE.getCode()) {
                NodeConcurrencyLimiter.release(concurrentID);
            }
        }
    }

    public void release() {
        if (this.noLimit) {
            return;
        }
        try {
            if (this.range == Range.CLUSTER.getCode()) {
                ClusterConcurrencyLimiter clusterLimiter = (ClusterConcurrencyLimiter)this.limiter;
                clusterLimiter.close();
            }
            if (this.range == Range.NODE.getCode()) {
                NodeConcurrencyLimiter nodeLimiter = (NodeConcurrencyLimiter)this.limiter;
                nodeLimiter.close();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    public String getConcurrentID() {
        if (this.noLimit) {
            return NO_LIMIT_ID;
        }
        return this.limiter.getConcurrentID();
    }

    public static boolean isLockingUser(String sceneCode, String bizCode) {
        block18: {
            ConcurrentScene scene = ConcurrentSceneManager.scenes.get(sceneCode);
            if (scene != null && scene.getRange() == Range.CLUSTER.getCode()) {
                String key = AbstractLimiter.getStoreKey(sceneCode, bizCode);
                if (StringUtils.isEmpty((String)key)) {
                    return false;
                }
                try (JedisClient jedis = ClusterConcurrencyLimiter.getJedisClient();){
                    long len = jedis.hlen(key);
                    if (len <= 0L || len >= 10000L) break block18;
                    Map allData = jedis.hgetAll(key);
                    for (String value : allData.values()) {
                        String[] strings = value.split("_");
                        if (strings.length < 2 || !AbstractLimiter.getCurrUserID().equals(strings[0])) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    public static boolean hasSlowOperate(String sceneCode, String bizCode) {
        return ClusterSlowRecorder.hasSlow(sceneCode, bizCode, null);
    }

    static ConcurrencyLimiter getNoLimiter() {
        ConcurrencyLimiter limiter = new ConcurrencyLimiter();
        limiter.noLimit = true;
        return limiter;
    }

    public boolean getNoLimit() {
        return this.noLimit;
    }

    @Override
    public void close() throws Exception {
        this.release();
    }
}

