/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockInfo.class);
    private long maxConcurrency;
    private long nowConcurrency;

    public long getMaxConcurrency() {
        return this.maxConcurrency;
    }

    void setMaxConcurrency(long maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    public long getNowConcurrency() {
        return this.nowConcurrency;
    }

    void setNowConcurrency(long nowConcurrency) {
        this.nowConcurrency = nowConcurrency;
    }

    public int getUsageRate() {
        int ret = 0;
        try {
            BigDecimal max = BigDecimal.valueOf(this.maxConcurrency);
            BigDecimal now = BigDecimal.valueOf(this.nowConcurrency);
            BigDecimal percentage = now.divide(max, 2, RoundingMode.HALF_UP);
            ret = (int)(percentage.floatValue() * 100.0f);
            if (ret < 0) {
                ret = 0;
            }
            if (ret > 100) {
                ret = 100;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return ret;
    }
}

