/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.context.RequestContext;
import kd.bos.id.ID;
import kd.bos.limiter.AbstractLimiter;
import kd.bos.limiter.conf.RateLimiterConfig;
import kd.bos.limiter.constant.Range;
import kd.bos.limiter.impl.NodeCacheValue;
import kd.bos.limiter.scene.ConcurrentInstance;
import kd.bos.limiter.scene.ConcurrentScene;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeConcurrencyLimiter
extends AbstractLimiter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeConcurrencyLimiter.class);
    public static final Map<String, Cache<String, NodeCacheValue>> CACHES = new ConcurrentHashMap<String, Cache<String, NodeCacheValue>>();
    public static final Map<String, Lock> LOCKS = new ConcurrentHashMap<String, Lock>();

    public NodeConcurrencyLimiter(ConcurrentScene scene, String bizCode) {
        this.scene = scene;
        this.sceneCode = scene.getSceneCode();
        this.bizCode = bizCode;
        this.tenantID = RequestContext.get().getTenantId();
        this.storeKey = NodeConcurrencyLimiter.getStoreKey(this.sceneCode, bizCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean allow() {
        if (this.scene.getLimitType() != 0 || this.scene.getRange() != Range.NODE.getCode()) {
            LOGGER.error("limitType or Range error. LimitType=" + this.scene.getLimitType() + ", Range=" + this.scene.getRange());
            return true;
        }
        try {
            String key = NodeConcurrencyLimiter.getStoreKey(this.sceneCode, this.bizCode);
            Cache<String, NodeCacheValue> cache = this.getCache(key);
            if (cache == null) {
                LOGGER.error("the CACHES has reached its max limit.");
                return true;
            }
            this.uniqueID = Long.toString(ID.genLongId());
            NodeCacheValue nodeCacheValue = new NodeCacheValue();
            nodeCacheValue.setUserID(NodeConcurrencyLimiter.getCurrUserID());
            nodeCacheValue.setTraceID(this.getTraceID());
            cache.cleanUp();
            Lock lock = this.getLock(key);
            lock.lock();
            try {
                if (cache.size() < this.scene.getConcurrency()) {
                    cache.put((Object)this.uniqueID, (Object)nodeCacheValue);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                LOGGER.error("NodeConcurrencyLimiter: An error occurred while writing into Cache. ", (Throwable)e);
                boolean bl2 = true;
                return bl2;
            }
            finally {
                lock.unlock();
            }
        }
        catch (Exception e2) {
            LOGGER.error("NodeConcurrencyLimiter: An error occurred while acquiring. ", (Throwable)e2);
            return true;
        }
    }

    @Override
    public void release() {
        NodeConcurrencyLimiter.release(this.storeKey, this.uniqueID);
    }

    public static void release(String concurrentID) {
        ConcurrentInstance instance;
        try {
            instance = NodeConcurrencyLimiter.decode(concurrentID);
        }
        catch (Exception e) {
            LOGGER.error("decode failed. concurrentID = " + concurrentID + ", " + e.getMessage());
            return;
        }
        if (instance != null) {
            String sceneCode = instance.getSceneCode();
            String bizCode = instance.getBizCode();
            String cacheKey = instance.getUniqueID();
            NodeConcurrencyLimiter.release(NodeConcurrencyLimiter.getStoreKey(sceneCode, bizCode), cacheKey);
        }
    }

    private static void release(String mapKey, String cacheKey) {
        Cache<String, NodeCacheValue> cache = CACHES.get(mapKey);
        if (cache == null) {
            return;
        }
        cache.invalidate((Object)cacheKey);
    }

    @Override
    public void close() throws Exception {
        this.release();
    }

    public static void updateCache(String sceneCode, long lockTimeout) {
        if (StringUtils.isEmpty((String)sceneCode) || lockTimeout <= 0L) {
            return;
        }
        for (String key : CACHES.keySet()) {
            if (key.length() <= sceneCode.length() || key.indexOf(sceneCode, "RATE_LIMITER_".length()) <= -1) continue;
            CACHES.put(key, (Cache<String, NodeCacheValue>)CacheBuilder.newBuilder().maximumSize((long)RateLimiterConfig.getCacheMaxSize()).expireAfterWrite(lockTimeout, TimeUnit.SECONDS).build());
        }
    }

    private Lock getLock(String key) {
        LOCKS.computeIfAbsent(key, k -> new ReentrantLock());
        return LOCKS.get(key);
    }

    private Cache<String, NodeCacheValue> getCache(String key) {
        if (CACHES.size() < RateLimiterConfig.getConcurrentMapMaxSize()) {
            CACHES.computeIfAbsent(key, k -> CacheBuilder.newBuilder().maximumSize((long)RateLimiterConfig.getCacheMaxSize()).expireAfterWrite(this.scene.getLockTimeout(), TimeUnit.SECONDS).build());
        }
        return CACHES.get(key);
    }

    private String getTraceID() {
        RequestContext context = RequestContext.get();
        if (context == null) {
            return null;
        }
        String traceID = context.getTraceId();
        if (StringUtils.isEmpty((String)traceID)) {
            return null;
        }
        return traceID;
    }
}

