/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.scene;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.limiter.constant.Algorithm;
import kd.bos.limiter.constant.LimitType;
import kd.bos.limiter.constant.Range;
import kd.bos.limiter.scene.Scene;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SceneManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SceneManager.class);
    private static Map<String, Map<String, Scene>> ALL_SCENES = new ConcurrentHashMap<String, Map<String, Scene>>();
    private static final int MAX_LOAD_COUNT = 500;
    private static final int MAX_LOAD_LIC = 10000;
    public static final String CODE_PREFIX = "LICENCE_";
    private static RequestContext context = null;

    public static void load() {
        List accounts;
        LOGGER.info("Limit scene load start...");
        try {
            accounts = AccountUtils.getAllAccountsOfCurrentEnv();
        }
        catch (Exception e) {
            return;
        }
        accounts.forEach(account -> {
            ThreadLifeCycleManager.start();
            try {
                context = RequestContext.create();
                context.setAccountId(account.getAccountId());
                context.setTenantId(account.getTenantId());
                context.setTraceId(TraceIdUtil.getCurrentTraceIdString());
                String accountId = RequestContext.get().getAccountId();
                String sql = "SELECT TOP 10000 fid, fnumber  FROM t_lic_group ORDER BY fid";
                HashMap licGroups = new HashMap();
                DB.query((DBRoute)DBRoute.base, (String)sql, null, rs -> {
                    while (rs.next()) {
                        try {
                            String number = rs.getString("fnumber");
                            if (StringUtils.isEmpty((String)number)) continue;
                            licGroups.put(number, rs.getLong("fid"));
                        }
                        catch (Exception e) {
                            LOGGER.error(e.getMessage());
                        }
                    }
                    return null;
                });
                sql = "SELECT TOP 500 fid, fcode, fname, flimit_enable, fwarn_enable, fwarn_threshold, frange, ftype, fis_async, falgorithm, fmax_count, fmax_size, fwindow_time, fwindow_time_unit, flimit_time, flimit_time_unit, fdescription, finclude_package, fexclude_package, fcreated, fupdated FROM t_cbs_limit_scene ORDER BY fid";
                HashSet scenes = new HashSet();
                DB.query((DBRoute)DBRoute.base, (String)sql, null, rs -> {
                    while (rs.next()) {
                        try {
                            String excludePackage;
                            String includePackage;
                            String description;
                            String limitTimeUnit;
                            String range;
                            Scene scene = new Scene();
                            scene.setId(rs.getLong("fid"));
                            scene.setCode(rs.getString("fcode"));
                            scene.setName(rs.getString("fname"));
                            scene.setLimitEnable(!"0".equals(rs.getString("flimit_enable")));
                            scene.setWarnEnable(!"0".equals(rs.getString("fwarn_enable")));
                            int threshold = rs.getInt("fwarn_threshold");
                            if (threshold > 0) {
                                scene.setWarnThreshold(threshold / 100);
                            }
                            if (!StringUtils.isEmpty((String)(range = rs.getString("frange")))) {
                                scene.setRange(Range.getRange(range));
                            }
                            scene.setLimitType(LimitType.getLimitType(rs.getString("ftype")));
                            scene.setAlgorithm(Algorithm.getAlgorithm(rs.getString("falgorithm")));
                            if (scene.getLimitType() == LimitType.LICENSE) {
                                long groupId = (Long)licGroups.get(SceneManager.convertCode(scene.getCode()));
                                Class<?> clz = Class.forName("kd.bos.license.service.LicenseServiceImpl");
                                Method m = clz.getMethod("getTotalNumber", Object.class);
                                scene.setMaxCount(((Integer)m.invoke(clz.newInstance(), groupId)).intValue());
                            } else {
                                scene.setMaxCount(rs.getLong("fmax_count"));
                            }
                            scene.setAsync(!"0".equals(rs.getString("fis_async")));
                            scene.setMaxSize(rs.getLong("fmax_size"));
                            scene.setWindowTime(rs.getLong("fwindow_time"));
                            String windowTimeUnit = rs.getString("fwindow_time_unit");
                            if (!StringUtils.isEmpty((String)windowTimeUnit)) {
                                scene.setWindowTimeUnit(SceneManager.getTimeUnit(windowTimeUnit));
                            }
                            if (!StringUtils.isEmpty((String)(limitTimeUnit = rs.getString("flimit_time_unit")))) {
                                scene.setLimitTimeUnit(SceneManager.getTimeUnit(limitTimeUnit));
                            }
                            if (!StringUtils.isEmpty((String)(description = rs.getString("fdescription")))) {
                                scene.setDescription(description);
                            }
                            if (!StringUtils.isEmpty((String)(includePackage = rs.getString("finclude_package")))) {
                                scene.setIncludePackage(includePackage);
                            }
                            if (!StringUtils.isEmpty((String)(excludePackage = rs.getString("fexclude_package")))) {
                                scene.setExcludePackage(excludePackage);
                            }
                            scene.setCreated(rs.getDate("fcreated"));
                            scene.setUpdated(rs.getDate("fupdated"));
                            scenes.add(scene);
                        }
                        catch (Exception e) {
                            LOGGER.error("An error was encountered when a Scene was added.", (Throwable)e);
                        }
                    }
                    return null;
                });
                if (scenes.size() > 0) {
                    HashMap<String, Scene> sceneMap = new HashMap<String, Scene>(16);
                    for (Scene scene : scenes) {
                        sceneMap.put(scene.getCode(), scene);
                    }
                    ALL_SCENES.put(accountId, sceneMap);
                }
            }
            catch (Exception e) {
                LOGGER.error("An error was encountered when loading scenes.", (Throwable)e);
            }
            finally {
                context = null;
            }
        });
        LOGGER.info("Limit scene load end.");
    }

    public static Scene getScene(String code) {
        Map<String, Scene> map = ALL_SCENES.get(RequestContext.get().getAccountId());
        if (map == null) {
            return null;
        }
        return map.get(code);
    }

    private static TimeUnit getTimeUnit(String code) {
        TimeUnit ret;
        switch (code) {
            case "0": {
                ret = TimeUnit.SECONDS;
                break;
            }
            case "1": {
                ret = TimeUnit.MINUTES;
                break;
            }
            case "2": {
                ret = TimeUnit.HOURS;
                break;
            }
            case "3": {
                ret = TimeUnit.DAYS;
                break;
            }
            default: {
                throw new RuntimeException("TimeUnit not supported, code = " + code);
            }
        }
        return ret;
    }

    private static String convertCode(String code) {
        if (code.startsWith(CODE_PREFIX)) {
            code = code.substring(CODE_PREFIX.length());
        }
        return code;
    }
}

