/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.scheduler;

import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.limiter.JClient;
import kd.bos.redis.JedisClient;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatRedisScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeartbeatRedisScheduler.class);
    public static final String LUA = "if redis.call('HEXISTS', KEYS[1], ARGV[1]) == 1 then redis.call('HSET', KEYS[1], ARGV[1], ARGV[2]) return 1 else return 0 end";
    public static final ConcurrentHashMap<Key, Value> EXECUTING_TASKS = new ConcurrentHashMap();

    private HeartbeatRedisScheduler() {
        if (Holder.INSTANCE != null) {
            throw new IllegalStateException("Already initialized.");
        }
        ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
        service.scheduleWithFixedDelay(() -> {
            Iterator<Map.Entry<Key, Value>> iterator = EXECUTING_TASKS.entrySet().iterator();
            while (iterator.hasNext()) {
                try {
                    long ret;
                    Map.Entry<Key, Value> entry = iterator.next();
                    long now = Instant.now().toEpochMilli();
                    long timestamp = entry.getValue().getInstant().toEpochMilli();
                    if (now - timestamp > (long)HeartbeatRedisScheduler.getTimeout() * 60L * 1000L) {
                        iterator.remove();
                        continue;
                    }
                    if (now - timestamp < (long)HeartbeatRedisScheduler.getSendTimeThreshold() * 1000L) continue;
                    String originalHashValue = entry.getValue().getHashValue();
                    if (StringUtils.isEmpty((String)originalHashValue) || !originalHashValue.contains("_")) {
                        iterator.remove();
                    }
                    String updatedValue = HeartbeatRedisScheduler.updateTimestamp(originalHashValue);
                    try (JedisClient jedis = JClient.get();){
                        ret = (Long)jedis.eval(LUA, 1, new String[]{entry.getKey().getRedisKey(), entry.getKey().getHashKey(), updatedValue});
                    }
                    finally {
                        TimeUnit.MILLISECONDS.sleep(100L);
                    }
                    if (ret != 0L) continue;
                    iterator.remove();
                }
                catch (Exception e) {
                    HeartbeatRedisScheduler.logError("An error occurred while updating Redis", e);
                }
            }
        }, HeartbeatRedisScheduler.getDelay(), TimeUnit.SECONDS.toSeconds(HeartbeatRedisScheduler.getDelay()), TimeUnit.SECONDS);
    }

    public static void add(String redisKey, String hashKey, String hashValue) {
        if (StringUtils.isEmpty((String)redisKey) || StringUtils.isEmpty((String)hashKey) || EXECUTING_TASKS.size() > HeartbeatRedisScheduler.getMaxSize()) {
            return;
        }
        EXECUTING_TASKS.put(new Key(redisKey, hashKey), new Value(hashValue));
        HeartbeatRedisScheduler.getInstance();
    }

    public static void remove(String redisKey, String hashKey) {
        EXECUTING_TASKS.remove(new Key(redisKey, hashKey));
    }

    private static String updateTimestamp(String originalHashValue) {
        String[] strings = originalHashValue.split("_");
        String originalTimestamp = strings[1];
        return originalHashValue.replace(originalTimestamp, Long.toString(Instant.now().toEpochMilli()));
    }

    private static void logError(String msg, Exception e) {
        if (HeartbeatRedisScheduler.isLog()) {
            LOGGER.error(msg, (Throwable)e);
        }
    }

    public static HeartbeatRedisScheduler getInstance() {
        return Holder.INSTANCE;
    }

    private static int getDelay() {
        return Integer.getInteger("limiter.heartbeat.redisScheduler.delay", 5);
    }

    private static int getTimeout() {
        return Integer.getInteger("limiter.heartbeat.redisScheduler.timeout", 300);
    }

    private static int getMaxSize() {
        return Integer.getInteger("limiter.heartbeat.redisScheduler.queue.maxSize", 1000000);
    }

    private static int getSendTimeThreshold() {
        return Integer.getInteger("limiter.heartbeat.redisScheduler.sendTimeThreshold", 60);
    }

    private static boolean isLog() {
        return Boolean.parseBoolean(System.getProperty("limiter.heartbeat.redisScheduler.isLog", "false"));
    }

    public static class Value {
        Instant instant = Instant.now();
        String hashValue;

        public Value(String hashValue) {
            this.hashValue = hashValue;
        }

        public Instant getInstant() {
            return this.instant;
        }

        public void setInstant(Instant instant) {
            this.instant = instant;
        }

        public String getHashValue() {
            return this.hashValue;
        }

        public void setHashValue(String hashValue) {
            this.hashValue = hashValue;
        }
    }

    public static class Key {
        String redisKey;
        String hashKey;

        public Key(String redisKey, String hashKey) {
            this.redisKey = redisKey;
            this.hashKey = hashKey;
        }

        public String getRedisKey() {
            return this.redisKey;
        }

        public void setRedisKey(String redisKey) {
            this.redisKey = redisKey;
        }

        public String getHashKey() {
            return this.hashKey;
        }

        public void setHashKey(String hashKey) {
            this.hashKey = hashKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.redisKey, key.redisKey) && Objects.equals(this.hashKey, key.hashKey);
        }

        public int hashCode() {
            return Objects.hash(this.redisKey, this.hashKey);
        }
    }

    private static class Holder {
        private static final HeartbeatRedisScheduler INSTANCE = new HeartbeatRedisScheduler();

        private Holder() {
        }
    }
}

