/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.scheduler;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.limiter.GatewayLimiter;
import kd.bos.limiter.algorithm.NaturalTimeCluster;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.util.StringUtils;

public class NaturalTimeScheduler {
    public static final long KEY_EXPIRE = 129600L;
    public static final String LOOP_DELAY_KEY = "limiter.apiGateway.schedule.loopDelay";
    public static final int DEFAULT_LOOP_DELAY = 10;
    public static long SCHEDULE_DELAY = 5L;

    private NaturalTimeScheduler() {
        if (Holder.INSTANCE != null) {
            throw new IllegalStateException("Already initialized.");
        }
        String configKey = CacheConfigKeys.getSessionlessConfigKey((String)"rate_limiter");
        String redisUrl = System.getProperty(configKey);
        if (redisUrl == null) {
            configKey = CacheConfigKeys.getSessionlessConfigKey(null);
            redisUrl = System.getProperty(configKey);
        }
        String url = redisUrl;
        ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
        service.scheduleWithFixedDelay(() -> {
            for (NaturalTimeCluster naturalTimeCluster : GatewayLimiter.NATURAL_TIME_CLUSTER_MAP.values()) {
                try {
                    JedisClient jedis = RedisFactory.getJedisClient((String)url);
                    Throwable throwable = null;
                    try {
                        String ret;
                        String key = naturalTimeCluster.getRedisKey();
                        if (naturalTimeCluster.tempCounter.get() > 0L) {
                            long increment = naturalTimeCluster.tempCounter.getAndSet(0L);
                            if (!jedis.exists(key).booleanValue()) {
                                jedis.incrBy(key, increment);
                                jedis.expire(key, 129600L);
                            } else {
                                jedis.incrBy(key, increment);
                            }
                        }
                        if (StringUtils.isEmpty((String)(ret = jedis.get(key)))) {
                            ret = "0";
                        }
                        naturalTimeCluster.currentCounter = Integer.parseInt(ret);
                        TimeUnit.MILLISECONDS.sleep(this.getLoopDelay());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (jedis == null) continue;
                        if (throwable != null) {
                            try {
                                jedis.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        jedis.close();
                    }
                }
                catch (Exception exception) {}
            }
        }, SCHEDULE_DELAY, TimeUnit.SECONDS.toSeconds(SCHEDULE_DELAY), TimeUnit.SECONDS);
    }

    public static NaturalTimeScheduler getInstance() {
        return Holder.INSTANCE;
    }

    private int getLoopDelay() {
        return Integer.getInteger(LOOP_DELAY_KEY, 10);
    }

    private static class Holder {
        private static final NaturalTimeScheduler INSTANCE = new NaturalTimeScheduler();

        private Holder() {
        }
    }
}

