/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.scheduler;

import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.limiter.Limiter;
import kd.bos.limiter.algorithm.SlidingWindowCluster;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;

public class SlidingWindowScheduler {
    private SlidingWindowScheduler() {
        if (Holder.INSTANCE != null) {
            throw new IllegalStateException("Already initialized.");
        }
        ScheduledExecutorService service = Executors.newScheduledThreadPool(2);
        long delay = 2L;
        service.scheduleWithFixedDelay(() -> {
            for (SlidingWindowCluster slidingWindowCluster : Limiter.SLIDING_WINDOW_CLUSTER_MAP.values()) {
                try {
                    if (!slidingWindowCluster.getIsAsync() || slidingWindowCluster.tempCounter.get() <= 0L) continue;
                    String configKey = CacheConfigKeys.getSessionlessConfigKey((String)"rate_limiter");
                    String url = System.getProperty(configKey);
                    if (url == null) {
                        configKey = CacheConfigKeys.getSessionlessConfigKey(null);
                        url = System.getProperty(configKey);
                    }
                    String luaScript = "redis.call('zremrangebyscore', KEYS[1], 0, ARGV[1]) local num = redis.call('zcard', KEYS[1]) if num < tonumber(ARGV[2]) then local left = tonumber(ARGV[2]) - redis.call('zcard', KEYS[1]) local increment = tonumber(ARGV[3]) local min = (left < increment) and left or increment for i=1, min do redis.call('zadd', KEYS[1], ARGV[4], ARGV[4] .. i) end end";
                    long now = Instant.now().toEpochMilli();
                    String timestamp = Long.toString(now);
                    String start = Long.toString(now - slidingWindowCluster.getWindowTime());
                    String limit = Long.toString(slidingWindowCluster.getMaxCount());
                    long counter = slidingWindowCluster.tempCounter.getAndSet(0L);
                    if (counter > 200L) {
                        counter = 200L;
                    }
                    try (JedisClient jedis = RedisFactory.getJedisClient((String)url);){
                        jedis.eval(luaScript, 1, new String[]{slidingWindowCluster.getAsyncKey(), start, limit, Long.toString(counter), timestamp});
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                catch (Exception exception) {}
            }
        }, delay, delay, TimeUnit.SECONDS);
        long removeDelay = 60L;
        service.scheduleWithFixedDelay(() -> {
            for (SlidingWindowCluster slidingWindowCluster : Limiter.SLIDING_WINDOW_CLUSTER_MAP.values()) {
                try {
                    String configKey = CacheConfigKeys.getSessionlessConfigKey((String)"rate_limiter");
                    String url = System.getProperty(configKey);
                    if (url == null) {
                        configKey = CacheConfigKeys.getSessionlessConfigKey(null);
                        url = System.getProperty(configKey);
                    }
                    String luaScript = "redis.call('zremrangebyscore', KEYS[1], 0, ARGV[1]) ";
                    long now = Instant.now().toEpochMilli();
                    String start = Long.toString(now - slidingWindowCluster.getWindowTime());
                    try (JedisClient jedis = RedisFactory.getJedisClient((String)url);){
                        jedis.eval(luaScript, 1, new String[]{slidingWindowCluster.getAsyncKey(), start});
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                catch (Exception exception) {}
            }
        }, removeDelay, removeDelay, TimeUnit.SECONDS);
    }

    public static SlidingWindowScheduler getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final SlidingWindowScheduler INSTANCE = new SlidingWindowScheduler();

        private Holder() {
        }
    }
}

