/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.HealthCheckCallback;
import com.netflix.appinfo.HealthCheckCallbackToHandlerBridge;
import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import com.netflix.discovery.AzToRegionMapper;
import com.netflix.discovery.BackupRegistry;
import com.netflix.discovery.CacheRefreshedEvent;
import com.netflix.discovery.DNSBasedAzToRegionMapper;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.EurekaEvent;
import com.netflix.discovery.EurekaEventListener;
import com.netflix.discovery.InstanceInfoReplicator;
import com.netflix.discovery.InstanceRegionChecker;
import com.netflix.discovery.NotImplementedRegistryImpl;
import com.netflix.discovery.PreRegistrationHandler;
import com.netflix.discovery.PropertyBasedAzToRegionMapper;
import com.netflix.discovery.StatusChangeEvent;
import com.netflix.discovery.TimedSupervisorTask;
import com.netflix.discovery.endpoint.EndpointUtils;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.resolver.ClosableResolver;
import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.EndpointRandomizer;
import com.netflix.discovery.shared.resolver.ResolverUtils;
import com.netflix.discovery.shared.resolver.aws.ApplicationsResolver;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpClientFactory;
import com.netflix.discovery.shared.transport.EurekaHttpClients;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import com.netflix.discovery.shared.transport.jersey.Jersey1DiscoveryClientOptionalArgs;
import com.netflix.discovery.shared.transport.jersey.Jersey1TransportClientFactories;
import com.netflix.discovery.util.ThresholdLevelsMetric;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import kd.bos.instance.Instance;
import kd.bos.mservice.common.rpc.RegisterAppNameUtils;
import kd.bos.mservice.discovery.KRegistryInstanceTransformAdapter;
import kd.bos.mservice.rpc.feign.FieldUtils;
import kd.bos.mservice.rpc.feign.registry.RegistryCallback;
import kd.bos.mservice.rpc.feign.registry.RegistryFailedRetry;
import kd.bos.service.register.ServiceRegister;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DiscoveryClient
implements EurekaClient {
    public static final String HTTP_X_DISCOVERY_ALLOW_REDIRECT = "X-Discovery-AllowRedirect";
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryClient.class);
    private static final String VALUE_DELIMITER = ",";
    private static final String COMMA_STRING = ",";
    private static final String PREFIX = "DiscoveryClient_";
    @Deprecated
    private static EurekaClientConfig staticClientConfig;
    protected final EurekaClientConfig clientConfig;
    protected final EurekaTransportConfig transportConfig;
    private final Counter RECONCILE_HASH_CODES_MISMATCH;
    private final Timer FETCH_REGISTRY_TIMER;
    private final Counter REREGISTER_COUNTER;
    private final ScheduledExecutorService scheduler;
    private final ThreadPoolExecutor heartbeatExecutor;
    private final ThreadPoolExecutor cacheRefreshExecutor;
    private final Provider<HealthCheckHandler> healthCheckHandlerProvider;
    private final Provider<HealthCheckCallback> healthCheckCallbackProvider;
    private final PreRegistrationHandler preRegistrationHandler;
    private final AtomicReference<Applications> localRegionApps;
    private final Lock fetchRegistryUpdateLock;
    private final AtomicLong fetchRegistryGeneration;
    private final ApplicationInfoManager applicationInfoManager;
    private final InstanceInfo instanceInfo;
    private final AtomicReference<String> remoteRegionsToFetch;
    private final AtomicReference<String[]> remoteRegionsRef;
    private final InstanceRegionChecker instanceRegionChecker;
    private final EndpointUtils.ServiceUrlRandomizer urlRandomizer;
    private final EndpointRandomizer endpointRandomizer;
    private final Provider<BackupRegistry> backupRegistryProvider;
    private final EurekaTransport eurekaTransport;
    private final AtomicReference<HealthCheckHandler> healthCheckHandlerRef;
    private final CopyOnWriteArraySet<EurekaEventListener> eventListeners;
    private final ThresholdLevelsMetric heartbeatStalenessMonitor;
    private final ThresholdLevelsMetric registryStalenessMonitor;
    private final AtomicBoolean isShutdown;
    private final long initTimestampMs;
    private final int initRegistrySize;
    private final Stats stats;
    private TimedSupervisorTask cacheRefreshTask;
    private TimedSupervisorTask heartbeatTask;
    private volatile Map<String, Applications> remoteRegionVsApps;
    private volatile InstanceInfo.InstanceStatus lastRemoteInstanceStatus;
    private String appPathIdentifier;
    private ApplicationInfoManager.StatusChangeListener statusChangeListener;
    private InstanceInfoReplicator instanceInfoReplicator;
    private volatile int registrySize = 0;
    private volatile long lastSuccessfulRegistryFetchTimestamp = -1L;
    private volatile long lastSuccessfulHeartbeatTimestamp = -1L;
    private Map<String, InstanceInfo> instanceInfoMap = new ConcurrentHashMap<String, InstanceInfo>(1);
    private RegistryFailedRetry registryFailedRetry = RegistryFailedRetry.getInstance("DiscoveryClient", new RegistryCallback<RegistryIndetity>(){

        @Override
        public void doRegistry(RegistryIndetity service) throws Exception {
            if (!service.isNotChanged()) {
                DiscoveryClient.this.changeToRealInstance(DiscoveryClient.this.instanceInfo, service.getAppName(), service.getInstanceId());
                if (service.getAppid() != null) {
                    DiscoveryClient.this.instanceInfo.getMetadata().put("serverAppId", service.getAppid());
                }
            }
            DiscoveryClient.this._registerService(DiscoveryClient.this.instanceInfo);
        }

        @Override
        public void unRegistry(RegistryIndetity service) throws Exception {
            if (DiscoveryClient.this.eurekaTransport != null && DiscoveryClient.this.eurekaTransport.registrationClient != null) {
                try {
                    logger.info("Unregistering ...");
                    if (!service.isNotChanged()) {
                        DiscoveryClient.this.changeToRealInstance(DiscoveryClient.this.instanceInfo, service.getAppName(), service.getInstanceId());
                    }
                    EurekaHttpResponse httpResponse = DiscoveryClient.this.eurekaTransport.registrationClient.cancel(DiscoveryClient.this.instanceInfo.getAppName(), DiscoveryClient.this.instanceInfo.getId());
                    logger.info("DiscoveryClient_{} - deregister  status: {}", (Object)DiscoveryClient.this.instanceInfo.getAppName(), (Object)httpResponse.getStatusCode());
                }
                catch (Exception var2) {
                    logger.error("DiscoveryClient_{} - de-registration failed{}", new Object[]{DiscoveryClient.this.instanceInfo.getAppName(), var2.getMessage(), var2});
                }
            }
        }

        @Override
        public void initRegistryDelay(String interfaceName, String appid) {
            if (appid == null) {
                String appName = RegisterAppNameUtils.getRegisterInterfaceName((String)interfaceName);
                String instanceId = DiscoveryClient.this.instanceInfo.getIPAddr() + ":" + appName + ":" + DiscoveryClient.this.instanceInfo.getPort();
                DiscoveryClient.this.changeToRealInstance(DiscoveryClient.this.instanceInfo, appName, instanceId);
                RegistryIndetity registryIndentity = new RegistryIndetity().withAppName(appName).withInstanceId(instanceId);
                DiscoveryClient.this.registryFailedRetry.addRegistery(registryIndentity);
                DiscoveryClient.this.registryFailedRetry.hasInitRegistery(interfaceName, null);
                DiscoveryClient.this._registerService(DiscoveryClient.this.instanceInfo);
                DiscoveryClient.this.instanceInfoMap.put(appName, new InstanceInfo(DiscoveryClient.this.instanceInfo));
            } else {
                String appName = RegisterAppNameUtils.getRegisterAppName((String)appid, (String)interfaceName);
                String instanceId = DiscoveryClient.this.instanceInfo.getIPAddr() + ":" + appName + ":" + DiscoveryClient.this.instanceInfo.getPort();
                DiscoveryClient.this.changeToRealInstance(DiscoveryClient.this.instanceInfo, appName, instanceId);
                DiscoveryClient.this.instanceInfo.getMetadata().put("serverAppId", appid);
                RegistryIndetity registryIndentity = new RegistryIndetity().withAppid(appid).withAppName(appName).withInstanceId(instanceId);
                DiscoveryClient.this.registryFailedRetry.addRegistery(registryIndentity);
                DiscoveryClient.this.registryFailedRetry.hasInitRegistery(interfaceName, appid);
                DiscoveryClient.this._registerService(DiscoveryClient.this.instanceInfo);
                DiscoveryClient.this.instanceInfoMap.put(appName, new InstanceInfo(DiscoveryClient.this.instanceInfo));
            }
        }
    });

    @Deprecated
    public DiscoveryClient(InstanceInfo myInfo, EurekaClientConfig config) {
        this(myInfo, config, (DiscoveryClientOptionalArgs)null);
    }

    @Deprecated
    public DiscoveryClient(InstanceInfo myInfo, EurekaClientConfig config, DiscoveryClientOptionalArgs args) {
        this(ApplicationInfoManager.getInstance(), config, args);
    }

    @Deprecated
    public DiscoveryClient(InstanceInfo myInfo, EurekaClientConfig config, AbstractDiscoveryClientOptionalArgs args) {
        this(ApplicationInfoManager.getInstance(), config, args);
    }

    public DiscoveryClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config) {
        this(applicationInfoManager, config, (DiscoveryClientOptionalArgs)null);
    }

    @Deprecated
    public DiscoveryClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config, DiscoveryClientOptionalArgs args) {
        this(applicationInfoManager, config, (AbstractDiscoveryClientOptionalArgs)args);
    }

    public DiscoveryClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config, AbstractDiscoveryClientOptionalArgs args) {
        this(applicationInfoManager, config, args, ResolverUtils::randomize);
    }

    public DiscoveryClient(ApplicationInfoManager applicationInfoManager, final EurekaClientConfig config, AbstractDiscoveryClientOptionalArgs args, EndpointRandomizer randomizer) {
        this(applicationInfoManager, config, args, new Provider<BackupRegistry>(){
            private volatile BackupRegistry backupRegistryInstance;

            public synchronized BackupRegistry get() {
                if (this.backupRegistryInstance == null) {
                    String backupRegistryClassName = config.getBackupRegistryImpl();
                    if (null != backupRegistryClassName) {
                        try {
                            this.backupRegistryInstance = (BackupRegistry)Class.forName(backupRegistryClassName).newInstance();
                            logger.info("Enabled backup registry of type {}", this.backupRegistryInstance.getClass());
                        }
                        catch (InstantiationException var3) {
                            logger.error("Error instantiating BackupRegistry.", (Throwable)var3);
                        }
                        catch (IllegalAccessException var4) {
                            logger.error("Error instantiating BackupRegistry.", (Throwable)var4);
                        }
                        catch (ClassNotFoundException var5) {
                            logger.error("Error instantiating BackupRegistry.", (Throwable)var5);
                        }
                    }
                    if (this.backupRegistryInstance == null) {
                        logger.warn("Using default backup registry implementation which does not do anything.");
                        this.backupRegistryInstance = new NotImplementedRegistryImpl();
                    }
                }
                return this.backupRegistryInstance;
            }
        }, randomizer);
    }

    @Deprecated
    DiscoveryClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config, AbstractDiscoveryClientOptionalArgs args, Provider<BackupRegistry> backupRegistryProvider) {
        this(applicationInfoManager, config, args, backupRegistryProvider, ResolverUtils::randomize);
    }

    @Inject
    DiscoveryClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config, AbstractDiscoveryClientOptionalArgs args, Provider<BackupRegistry> backupRegistryProvider, EndpointRandomizer endpointRandomizer) {
        this.RECONCILE_HASH_CODES_MISMATCH = Monitors.newCounter((String)"DiscoveryClient_ReconcileHashCodeMismatch");
        this.FETCH_REGISTRY_TIMER = Monitors.newTimer((String)"DiscoveryClient_FetchRegistry");
        this.REREGISTER_COUNTER = Monitors.newCounter((String)"DiscoveryClient_Reregister");
        this.localRegionApps = new AtomicReference();
        this.fetchRegistryUpdateLock = new ReentrantLock();
        this.healthCheckHandlerRef = new AtomicReference();
        this.remoteRegionVsApps = new ConcurrentHashMap<String, Applications>();
        this.lastRemoteInstanceStatus = InstanceInfo.InstanceStatus.UNKNOWN;
        this.eventListeners = new CopyOnWriteArraySet();
        this.isShutdown = new AtomicBoolean(false);
        this.stats = new Stats();
        if (args != null) {
            this.healthCheckHandlerProvider = args.healthCheckHandlerProvider;
            this.healthCheckCallbackProvider = args.healthCheckCallbackProvider;
            this.eventListeners.addAll(args.getEventListeners());
            this.preRegistrationHandler = args.preRegistrationHandler;
        } else {
            this.healthCheckCallbackProvider = null;
            this.healthCheckHandlerProvider = null;
            this.preRegistrationHandler = null;
        }
        this.applicationInfoManager = applicationInfoManager;
        InstanceInfo myInfo = applicationInfoManager.getInfo();
        staticClientConfig = this.clientConfig = config;
        this.transportConfig = config.getTransportConfig();
        this.instanceInfo = myInfo;
        if (myInfo != null) {
            this.appPathIdentifier = this.instanceInfo.getAppName() + "/" + this.instanceInfo.getId();
        } else {
            logger.warn("Setting instanceInfo to a passed in null value");
        }
        this.backupRegistryProvider = backupRegistryProvider;
        this.endpointRandomizer = endpointRandomizer;
        this.urlRandomizer = new EndpointUtils.InstanceInfoBasedUrlRandomizer(this.instanceInfo);
        this.localRegionApps.set(new Applications());
        this.fetchRegistryGeneration = new AtomicLong(0L);
        this.remoteRegionsToFetch = new AtomicReference<String>(this.clientConfig.fetchRegistryForRemoteRegions());
        this.remoteRegionsRef = new AtomicReference<Object>((this.remoteRegionsToFetch.get() == null ? null : this.remoteRegionsToFetch.get().split(",")));
        this.registryStalenessMonitor = config.shouldFetchRegistry() ? new ThresholdLevelsMetric((Object)this, "eurekaClient.registry.lastUpdateSec_", new long[]{15L, 30L, 60L, 120L, 240L, 480L}) : ThresholdLevelsMetric.NO_OP_METRIC;
        this.heartbeatStalenessMonitor = config.shouldRegisterWithEureka() ? new ThresholdLevelsMetric((Object)this, "eurekaClient.registration.lastHeartbeatSec_", new long[]{15L, 30L, 60L, 120L, 240L, 480L}) : ThresholdLevelsMetric.NO_OP_METRIC;
        logger.info("Initializing Eureka in region {}", (Object)this.clientConfig.getRegion());
        if (!config.shouldRegisterWithEureka() && !config.shouldFetchRegistry()) {
            logger.info("Client configured to neither register nor query for data.");
            this.scheduler = null;
            this.heartbeatExecutor = null;
            this.cacheRefreshExecutor = null;
            this.eurekaTransport = null;
            this.instanceRegionChecker = new InstanceRegionChecker((AzToRegionMapper)new PropertyBasedAzToRegionMapper(config), this.clientConfig.getRegion());
            DiscoveryManager.getInstance().setDiscoveryClient(this);
            DiscoveryManager.getInstance().setEurekaClientConfig(config);
            this.initTimestampMs = System.currentTimeMillis();
            this.registrySize = this.initRegistrySize = this.getApplications().size();
            logger.info("Discovery Client initialized at timestamp {} with initial instances count: {}", (Object)this.initTimestampMs, (Object)this.initRegistrySize);
        } else {
            try {
                this.scheduler = Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setNameFormat("DiscoveryClient-%d").setDaemon(true).build());
                this.heartbeatExecutor = new ThreadPoolExecutor(1, this.clientConfig.getHeartbeatExecutorThreadPoolSize(), 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("DiscoveryClient-HeartbeatExecutor-%d").setDaemon(true).build());
                this.cacheRefreshExecutor = new ThreadPoolExecutor(1, this.clientConfig.getCacheRefreshExecutorThreadPoolSize(), 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("DiscoveryClient-CacheRefreshExecutor-%d").setDaemon(true).build());
                this.eurekaTransport = new EurekaTransport();
                this.scheduleServerEndpointTask(this.eurekaTransport, args);
                Object azToRegionMapper = this.clientConfig.shouldUseDnsForFetchingServiceUrls() ? new DNSBasedAzToRegionMapper(this.clientConfig) : new PropertyBasedAzToRegionMapper(this.clientConfig);
                if (null != this.remoteRegionsToFetch.get()) {
                    ((AzToRegionMapper)azToRegionMapper).setRegionsToFetch(this.remoteRegionsToFetch.get().split(","));
                }
                this.instanceRegionChecker = new InstanceRegionChecker((AzToRegionMapper)azToRegionMapper, this.clientConfig.getRegion());
            }
            catch (Throwable var12) {
                throw new RuntimeException("Failed to initialize DiscoveryClient!", var12);
            }
            if (this.clientConfig.shouldFetchRegistry()) {
                try {
                    boolean primaryFetchRegistryResult = this.fetchRegistry(false);
                    if (!primaryFetchRegistryResult) {
                        logger.info("Initial registry fetch from primary servers failed");
                    }
                    boolean backupFetchRegistryResult = true;
                    if (!primaryFetchRegistryResult && !this.fetchRegistryFromBackup()) {
                        backupFetchRegistryResult = false;
                        logger.info("Initial registry fetch from backup servers failed");
                    }
                    if (!primaryFetchRegistryResult && !backupFetchRegistryResult && this.clientConfig.shouldEnforceFetchRegistryAtInit()) {
                        throw new IllegalStateException("Fetch registry error at startup. Initial fetch failed.");
                    }
                }
                catch (Throwable var11) {
                    logger.error("Fetch registry error at startup: {}", (Object)var11.getMessage());
                    throw new IllegalStateException(var11);
                }
            }
            if (this.preRegistrationHandler != null) {
                this.preRegistrationHandler.beforeRegistration();
            }
            if (this.clientConfig.shouldRegisterWithEureka() && this.clientConfig.shouldEnforceRegistrationAtInit()) {
                try {
                    if (!this.register()) {
                        throw new IllegalStateException("Registration error at startup. Invalid server response.");
                    }
                }
                catch (Throwable var10) {
                    logger.error("Registration error at startup: {}", (Object)var10.getMessage());
                    throw new IllegalStateException(var10);
                }
            }
            this.initScheduledTasks();
            try {
                Monitors.registerObject((Object)this);
            }
            catch (Throwable var9) {
                logger.warn("Cannot register timers", var9);
            }
            DiscoveryManager.getInstance().setDiscoveryClient(this);
            DiscoveryManager.getInstance().setEurekaClientConfig(config);
            this.initTimestampMs = System.currentTimeMillis();
            this.registrySize = this.initRegistrySize = this.getApplications().size();
            logger.info("Discovery Client initialized at timestamp {} with initial instances count: {}", (Object)this.initTimestampMs, (Object)this.initRegistrySize);
        }
    }

    @Deprecated
    public static Set<String> getEC2DiscoveryUrlsFromZone(String dnsName, EndpointUtils.DiscoveryUrlType type) {
        return EndpointUtils.getEC2DiscoveryUrlsFromZone((String)dnsName, (EndpointUtils.DiscoveryUrlType)type);
    }

    @Deprecated
    public static String getZone(InstanceInfo myInfo) {
        String[] availZones = staticClientConfig.getAvailabilityZones(staticClientConfig.getRegion());
        return InstanceInfo.getZone((String[])availZones, (InstanceInfo)myInfo);
    }

    @Deprecated
    public static String getRegion() {
        String region = staticClientConfig.getRegion();
        if (region == null) {
            region = "default";
        }
        region = region.trim().toLowerCase();
        return region;
    }

    @Deprecated
    public static List<String> getEurekaServiceUrlsFromConfig(String instanceZone, boolean preferSameZone) {
        return EndpointUtils.getServiceUrlsFromConfig((EurekaClientConfig)staticClientConfig, (String)instanceZone, (boolean)preferSameZone);
    }

    private void scheduleServerEndpointTask(EurekaTransport eurekaTransport, AbstractDiscoveryClientOptionalArgs args) {
        EurekaHttpClient newQueryClient;
        EurekaHttpClientFactory newQueryClientFactory;
        Collection<Object> additionalFilters = args == null ? Collections.emptyList() : args.additionalFilters;
        EurekaJerseyClient providedJerseyClient = args == null ? null : args.eurekaJerseyClient;
        Jersey1TransportClientFactories argsTransportClientFactories = null;
        if (args != null && args.getTransportClientFactories() != null) {
            argsTransportClientFactories = args.getTransportClientFactories();
        }
        Jersey1TransportClientFactories transportClientFactories = argsTransportClientFactories == null ? new Jersey1TransportClientFactories() : argsTransportClientFactories;
        Optional sslContext = args == null ? Optional.empty() : args.getSSLContext();
        Optional hostnameVerifier = args == null ? Optional.empty() : args.getHostnameVerifier();
        eurekaTransport.transportClientFactory = providedJerseyClient == null ? transportClientFactories.newTransportClientFactory(this.clientConfig, additionalFilters, this.applicationInfoManager.getInfo(), sslContext, hostnameVerifier) : transportClientFactories.newTransportClientFactory(additionalFilters, providedJerseyClient);
        ApplicationsResolver.ApplicationsSource applicationsSource = new ApplicationsResolver.ApplicationsSource(){

            public Applications getApplications(int stalenessThreshold, TimeUnit timeUnit) {
                long thresholdInMs = TimeUnit.MILLISECONDS.convert(stalenessThreshold, timeUnit);
                long delay = DiscoveryClient.this.getLastSuccessfulRegistryFetchTimePeriod();
                if (delay > thresholdInMs) {
                    logger.info("Local registry is too stale for local lookup. Threshold:{}, actual:{}", (Object)thresholdInMs, (Object)delay);
                    return null;
                }
                return (Applications)DiscoveryClient.this.localRegionApps.get();
            }
        };
        eurekaTransport.bootstrapResolver = EurekaHttpClients.newBootstrapResolver((EurekaClientConfig)this.clientConfig, (EurekaTransportConfig)this.transportConfig, (TransportClientFactory)eurekaTransport.transportClientFactory, (InstanceInfo)this.applicationInfoManager.getInfo(), (ApplicationsResolver.ApplicationsSource)applicationsSource, (EndpointRandomizer)this.endpointRandomizer);
        if (this.clientConfig.shouldRegisterWithEureka()) {
            newQueryClientFactory = null;
            newQueryClient = null;
            try {
                newQueryClientFactory = EurekaHttpClients.registrationClientFactory((ClusterResolver)eurekaTransport.bootstrapResolver, (TransportClientFactory)eurekaTransport.transportClientFactory, (EurekaTransportConfig)this.transportConfig);
                newQueryClient = newQueryClientFactory.newClient();
            }
            catch (Exception var14) {
                logger.warn("Transport initialization failure", (Throwable)var14);
            }
            eurekaTransport.registrationClientFactory = newQueryClientFactory;
            eurekaTransport.registrationClient = newQueryClient;
        }
        if (this.clientConfig.shouldFetchRegistry()) {
            newQueryClientFactory = null;
            newQueryClient = null;
            try {
                newQueryClientFactory = EurekaHttpClients.queryClientFactory((ClusterResolver)eurekaTransport.bootstrapResolver, (TransportClientFactory)eurekaTransport.transportClientFactory, (EurekaClientConfig)this.clientConfig, (EurekaTransportConfig)this.transportConfig, (InstanceInfo)this.applicationInfoManager.getInfo(), (ApplicationsResolver.ApplicationsSource)applicationsSource, (EndpointRandomizer)this.endpointRandomizer);
                newQueryClient = newQueryClientFactory.newClient();
            }
            catch (Exception var13) {
                logger.warn("Transport initialization failure", (Throwable)var13);
            }
            eurekaTransport.queryClientFactory = newQueryClientFactory;
            eurekaTransport.queryClient = newQueryClient;
        }
    }

    public EurekaClientConfig getEurekaClientConfig() {
        return this.clientConfig;
    }

    public ApplicationInfoManager getApplicationInfoManager() {
        return this.applicationInfoManager;
    }

    public Application getApplication(String appName) {
        return this.getApplications().getRegisteredApplications(appName);
    }

    public Applications getApplications() {
        return this.localRegionApps.get();
    }

    public Applications getApplicationsForARegion(@Nullable String region) {
        return this.instanceRegionChecker.isLocalRegion(region) ? this.localRegionApps.get() : this.remoteRegionVsApps.get(region);
    }

    public Set<String> getAllKnownRegions() {
        String localRegion = this.instanceRegionChecker.getLocalRegion();
        if (!this.remoteRegionVsApps.isEmpty()) {
            Set<String> regions = this.remoteRegionVsApps.keySet();
            HashSet<String> toReturn = new HashSet<String>(regions);
            toReturn.add(localRegion);
            return toReturn;
        }
        return Collections.singleton(localRegion);
    }

    public List<InstanceInfo> getInstancesById(String id) {
        ArrayList<InstanceInfo> instancesList = new ArrayList<InstanceInfo>();
        for (Application app : this.getApplications().getRegisteredApplications()) {
            InstanceInfo instanceInfo = app.getByInstanceId(id);
            if (instanceInfo == null) continue;
            instancesList.add(instanceInfo);
        }
        return instancesList;
    }

    @Deprecated
    public void registerHealthCheckCallback(HealthCheckCallback callback) {
        if (this.instanceInfo == null) {
            logger.error("Cannot register a listener for instance info since it is null!");
        }
        if (callback != null) {
            this.healthCheckHandlerRef.set((HealthCheckHandler)new HealthCheckCallbackToHandlerBridge(callback));
        }
    }

    public void registerHealthCheck(HealthCheckHandler healthCheckHandler) {
        if (this.instanceInfo == null) {
            logger.error("Cannot register a healthcheck handler when instance info is null!");
        }
        if (healthCheckHandler != null) {
            this.healthCheckHandlerRef.set(healthCheckHandler);
            if (this.instanceInfoReplicator != null) {
                this.instanceInfoReplicator.onDemandUpdate();
            }
        }
    }

    public void registerEventListener(EurekaEventListener eventListener) {
        this.eventListeners.add(eventListener);
    }

    public boolean unregisterEventListener(EurekaEventListener eventListener) {
        return this.eventListeners.remove(eventListener);
    }

    public List<InstanceInfo> getInstancesByVipAddress(String vipAddress, boolean secure) {
        return this.getInstancesByVipAddress(vipAddress, secure, this.instanceRegionChecker.getLocalRegion());
    }

    public List<InstanceInfo> getInstancesByVipAddress(String vipAddress, boolean secure, @Nullable String region) {
        Applications applications;
        if (vipAddress == null) {
            throw new IllegalArgumentException("Supplied VIP Address cannot be null");
        }
        if (this.instanceRegionChecker.isLocalRegion(region)) {
            applications = this.localRegionApps.get();
        } else {
            applications = this.remoteRegionVsApps.get(region);
            if (null == applications) {
                logger.debug("No applications are defined for region {}, so returning an empty instance list for vip address {}.", (Object)region, (Object)vipAddress);
                return Collections.emptyList();
            }
        }
        return !secure ? applications.getInstancesByVirtualHostName(vipAddress) : applications.getInstancesBySecureVirtualHostName(vipAddress);
    }

    public List<InstanceInfo> getInstancesByVipAddressAndAppName(String vipAddress, String appName, boolean secure) {
        List<Object> result = new ArrayList<InstanceInfo>();
        if (vipAddress == null && appName == null) {
            throw new IllegalArgumentException("Supplied VIP Address and application name cannot both be null");
        }
        if (vipAddress != null && appName == null) {
            return this.getInstancesByVipAddress(vipAddress, secure);
        }
        if (vipAddress == null && appName != null) {
            Application application = this.getApplication(appName);
            if (application != null) {
                result = application.getInstances();
            }
            return result;
        }
        for (Application app : this.getApplications().getRegisteredApplications()) {
            block1: for (InstanceInfo instance : app.getInstances()) {
                String[] instanceVipAddresses;
                String instanceVipAddress = secure ? instance.getSecureVipAddress() : instance.getVIPAddress();
                if (instanceVipAddress == null) continue;
                String[] var11 = instanceVipAddresses = instanceVipAddress.split(",");
                int var12 = instanceVipAddresses.length;
                for (int var13 = 0; var13 < var12; ++var13) {
                    String vipAddressFromList = var11[var13];
                    if (!vipAddress.equalsIgnoreCase(vipAddressFromList.trim()) || !appName.equalsIgnoreCase(instance.getAppName())) continue;
                    result.add(instance);
                    continue block1;
                }
            }
        }
        return result;
    }

    public InstanceInfo getNextServerFromEureka(String virtualHostname, boolean secure) {
        List<InstanceInfo> instanceInfoList = this.getInstancesByVipAddress(virtualHostname, secure);
        if (instanceInfoList != null && !instanceInfoList.isEmpty()) {
            Applications apps = this.localRegionApps.get();
            int index = (int)(apps.getNextIndex(virtualHostname, secure).incrementAndGet() % (long)instanceInfoList.size());
            return instanceInfoList.get(index);
        }
        throw new RuntimeException("No matches for the virtual host name :" + virtualHostname);
    }

    public Applications getApplications(String serviceUrl) {
        try {
            EurekaHttpResponse response;
            EurekaHttpResponse eurekaHttpResponse = response = this.clientConfig.getRegistryRefreshSingleVipAddress() == null ? this.eurekaTransport.queryClient.getApplications(new String[0]) : this.eurekaTransport.queryClient.getVip(this.clientConfig.getRegistryRefreshSingleVipAddress(), new String[0]);
            if (response.getStatusCode() == Response.Status.OK.getStatusCode()) {
                logger.debug("DiscoveryClient_{} -  refresh status: {}", (Object)this.appPathIdentifier, (Object)response.getStatusCode());
                return (Applications)response.getEntity();
            }
            logger.info("DiscoveryClient_{} - was unable to refresh its cache! This periodic background refresh will be retried in {} seconds. status = {}", new Object[]{this.appPathIdentifier, this.clientConfig.getRegistryFetchIntervalSeconds(), response.getStatusCode()});
        }
        catch (Throwable var3) {
            logger.info("DiscoveryClient_{} - was unable to refresh its cache! This periodic background refresh will be retried in {} seconds. status = {} stacktrace = {}", new Object[]{this.appPathIdentifier, this.clientConfig.getRegistryFetchIntervalSeconds(), var3.getMessage(), ExceptionUtils.getStackTrace((Throwable)var3)});
        }
        return null;
    }

    boolean register() throws Throwable {
        boolean status = true;
        if (!ServiceRegister.isMServiceRegistryEnable()) {
            return status;
        }
        this.instanceInfo.getMetadata().put("serverInstanceId", Instance.getInstanceId());
        if (Boolean.getBoolean("mservice.feign.regist.withappname")) {
            RegistryIndetity registryIndentity = new RegistryIndetity().withNotChanged(true);
            this.registryFailedRetry.addRegistery(registryIndentity);
            return this._registerService(this.instanceInfo);
        }
        KRegistryInstanceTransformAdapter transformAdapter = KRegistryInstanceTransformAdapter.getAdapter((String)"http", (String)"eureka", (KRegistryInstanceTransformAdapter.SourceRegistryType)new KRegistryInstanceTransformAdapter.SourceRegistryType<InstanceInfo, InstanceInfo>(){});
        List instances = transformAdapter.getRegistryList((Object)this.instanceInfo);
        for (KRegistryInstanceTransformAdapter.RegistryInstanceWrapper instanceWrapper : instances) {
            this._registerService((InstanceInfo)instanceWrapper.getInstacne());
            String interfaceName = instanceWrapper.getInterfaceName();
            String appId = instanceWrapper.getAppId();
            String appName = RegisterAppNameUtils.getRegisterAppName((String)appId, (String)interfaceName);
            String instanceId = this.instanceInfo.getIPAddr() + ":" + appName + ":" + this.instanceInfo.getPort();
            RegistryIndetity registryIndentity = new RegistryIndetity().withAppid(appId).withAppName(appName).withInstanceId(instanceId);
            this.registryFailedRetry.addRegistery(registryIndentity);
            this.registryFailedRetry.hasInitRegistery(interfaceName, appId);
        }
        this.registryFailedRetry.finishBaseInit();
        return status;
    }

    private void changeToRealInstance(InstanceInfo instanceInfo, String appName, String instanceId) {
        FieldUtils.setFiledValue("appName", instanceInfo, appName);
        FieldUtils.setFiledValue("vipAddress", instanceInfo, appName);
        FieldUtils.setFiledValue("secureVipAddress", instanceInfo, appName);
        FieldUtils.setFiledValue("vipAddressUnresolved", instanceInfo, appName);
        FieldUtils.setFiledValue("secureVipAddressUnresolved", instanceInfo, appName);
        FieldUtils.setFiledValue("instanceId", instanceInfo, instanceId);
    }

    private boolean _registerService(InstanceInfo instanceInfo2) {
        EurekaHttpResponse httpResponse;
        logger.info("DiscoveryClient_{}: registering service...", (Object)this.appPathIdentifier);
        try {
            httpResponse = this.eurekaTransport.registrationClient.register(this.instanceInfo);
        }
        catch (Exception var3) {
            logger.warn("DiscoveryClient_{} - registration failed {}", new Object[]{this.appPathIdentifier, var3.getMessage(), var3});
            throw var3;
        }
        if (logger.isInfoEnabled()) {
            logger.info("DiscoveryClient_{} - registration status: {}", (Object)this.appPathIdentifier, (Object)httpResponse.getStatusCode());
        }
        return httpResponse.getStatusCode() == Response.Status.NO_CONTENT.getStatusCode();
    }

    boolean renew() {
        try {
            EurekaHttpResponse httpResponse = null;
            for (Map.Entry<String, InstanceInfo> instanceEntry : this.instanceInfoMap.entrySet()) {
                InstanceInfo instanceInfo = instanceEntry.getValue();
                httpResponse = this.eurekaTransport.registrationClient.sendHeartBeat(instanceInfo.getAppName(), instanceInfo.getId(), this.instanceInfo, null);
                logger.debug("DiscoveryClient_{} - Heartbeat status: {}", (Object)this.appPathIdentifier, (Object)httpResponse.getStatusCode());
                if (httpResponse == null || httpResponse.getStatusCode() != Response.Status.NOT_FOUND.getStatusCode()) continue;
                this.REREGISTER_COUNTER.increment();
                logger.info("DiscoveryClient_{} - Re-registering apps/{}", (Object)this.appPathIdentifier, (Object)this.instanceInfo.getAppName());
                long timestamp = this.instanceInfo.setIsDirtyWithTime();
                boolean success = this.register();
                if (success) {
                    this.instanceInfo.unsetIsDirty(timestamp);
                }
                return success;
            }
            if (httpResponse == null) {
                return false;
            }
            return httpResponse.getStatusCode() == Response.Status.OK.getStatusCode();
        }
        catch (Throwable var5) {
            logger.error("DiscoveryClient_{} - was unable to send heartbeat!", (Object)this.appPathIdentifier, (Object)var5);
            return false;
        }
    }

    @Deprecated
    public List<String> getServiceUrlsFromConfig(String instanceZone, boolean preferSameZone) {
        return EndpointUtils.getServiceUrlsFromConfig((EurekaClientConfig)this.clientConfig, (String)instanceZone, (boolean)preferSameZone);
    }

    @PreDestroy
    public synchronized void shutdown() {
        if (this.isShutdown.compareAndSet(false, true)) {
            logger.info("Shutting down DiscoveryClient ...");
            if (this.statusChangeListener != null && this.applicationInfoManager != null) {
                this.applicationInfoManager.unregisterStatusChangeListener(this.statusChangeListener.getId());
            }
            this.cancelScheduledTasks();
            if (this.applicationInfoManager != null && this.clientConfig.shouldRegisterWithEureka() && this.clientConfig.shouldUnregisterOnShutdown()) {
                this.applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.DOWN);
                this.unregister();
            }
            if (this.eurekaTransport != null) {
                this.eurekaTransport.shutdown();
            }
            this.heartbeatStalenessMonitor.shutdown();
            this.registryStalenessMonitor.shutdown();
            Monitors.unregisterObject((Object)this);
            logger.info("Completed shut down of DiscoveryClient");
        }
    }

    void unregister() {
        if (this.eurekaTransport != null && this.eurekaTransport.registrationClient != null) {
            for (Map.Entry<String, InstanceInfo> instanceEntry : this.instanceInfoMap.entrySet()) {
                InstanceInfo instanceInfo = instanceEntry.getValue();
                try {
                    logger.info("Unregistering ...");
                    EurekaHttpResponse httpResponse = this.eurekaTransport.registrationClient.cancel(instanceInfo.getAppName(), instanceInfo.getId());
                    logger.info("DiscoveryClient_{} - deregister  status: {}", (Object)instanceInfo.getAppName(), (Object)httpResponse.getStatusCode());
                }
                catch (Exception var2) {
                    logger.error("DiscoveryClient_{} - de-registration failed{}", new Object[]{instanceInfo.getAppName(), var2.getMessage(), var2});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchRegistry(boolean forceFullRegistryFetch) {
        block9: {
            boolean var4;
            Stopwatch tracer = this.FETCH_REGISTRY_TIMER.start();
            try {
                Applications applications = this.getApplications();
                if (!this.clientConfig.shouldDisableDelta() && Strings.isNullOrEmpty((String)this.clientConfig.getRegistryRefreshSingleVipAddress()) && !forceFullRegistryFetch && applications != null && applications.getRegisteredApplications().size() != 0 && applications.getVersion() != -1L) {
                    this.getAndUpdateDelta(applications);
                } else {
                    logger.info("Disable delta property : {}", (Object)this.clientConfig.shouldDisableDelta());
                    logger.info("Single vip registry refresh property : {}", (Object)this.clientConfig.getRegistryRefreshSingleVipAddress());
                    logger.info("Force full registry fetch : {}", (Object)forceFullRegistryFetch);
                    logger.info("Application is null : {}", (Object)(applications == null ? 1 : 0));
                    logger.info("Registered Applications size is zero : {}", (Object)(applications == null ? (Constable)Integer.valueOf(0) : (Constable)Boolean.valueOf(applications.getRegisteredApplications().size() == 0)));
                    logger.info("Application version is -1: {}", (Object)(applications == null ? (Constable)Integer.valueOf(-1) : (Constable)Boolean.valueOf(applications.getVersion() == -1L)));
                    this.getAndStoreFullRegistry();
                }
                if (applications != null) {
                    applications.setAppsHashCode(applications.getReconcileHashCode());
                }
                this.logTotalInstances();
                break block9;
            }
            catch (Throwable var8) {
                logger.info("DiscoveryClient_{} - was unable to refresh its cache! This periodic background refresh will be retried in {} seconds. status = {} stacktrace = {}", new Object[]{this.appPathIdentifier, this.clientConfig.getRegistryFetchIntervalSeconds(), var8.getMessage(), ExceptionUtils.getStackTrace((Throwable)var8)});
                var4 = false;
            }
            finally {
                if (tracer != null) {
                    tracer.stop();
                }
            }
            return var4;
        }
        this.onCacheRefreshed();
        this.updateInstanceRemoteStatus();
        return true;
    }

    private synchronized void updateInstanceRemoteStatus() {
        InstanceInfo remoteInstanceInfo;
        Application app;
        InstanceInfo.InstanceStatus currentRemoteInstanceStatus = null;
        if (this.instanceInfo.getAppName() != null && (app = this.getApplication(this.instanceInfo.getAppName())) != null && (remoteInstanceInfo = app.getByInstanceId(this.instanceInfo.getId())) != null) {
            currentRemoteInstanceStatus = remoteInstanceInfo.getStatus();
        }
        if (currentRemoteInstanceStatus == null) {
            currentRemoteInstanceStatus = InstanceInfo.InstanceStatus.UNKNOWN;
        }
        if (this.lastRemoteInstanceStatus != currentRemoteInstanceStatus) {
            this.onRemoteStatusChanged(this.lastRemoteInstanceStatus, currentRemoteInstanceStatus);
            this.lastRemoteInstanceStatus = currentRemoteInstanceStatus;
        }
    }

    public InstanceInfo.InstanceStatus getInstanceRemoteStatus() {
        return this.lastRemoteInstanceStatus;
    }

    private String getReconcileHashCode(Applications applications) {
        TreeMap instanceCountMap = new TreeMap();
        if (this.isFetchingRemoteRegionRegistries()) {
            for (Applications remoteApp : this.remoteRegionVsApps.values()) {
                remoteApp.populateInstanceCountMap(instanceCountMap);
            }
        }
        applications.populateInstanceCountMap(instanceCountMap);
        return Applications.getReconcileHashCode(instanceCountMap);
    }

    private void getAndStoreFullRegistry() throws Throwable {
        EurekaHttpResponse httpResponse;
        long currentUpdateGeneration = this.fetchRegistryGeneration.get();
        logger.info("Getting all instance registry info from the eureka server");
        Applications apps = null;
        EurekaHttpResponse eurekaHttpResponse = httpResponse = this.clientConfig.getRegistryRefreshSingleVipAddress() == null ? this.eurekaTransport.queryClient.getApplications(this.remoteRegionsRef.get()) : this.eurekaTransport.queryClient.getVip(this.clientConfig.getRegistryRefreshSingleVipAddress(), this.remoteRegionsRef.get());
        if (httpResponse.getStatusCode() == Response.Status.OK.getStatusCode()) {
            apps = (Applications)httpResponse.getEntity();
        }
        logger.info("The response status is {}", (Object)httpResponse.getStatusCode());
        if (apps == null) {
            logger.error("The application is null for some reason. Not storing this information");
        } else if (this.fetchRegistryGeneration.compareAndSet(currentUpdateGeneration, currentUpdateGeneration + 1L)) {
            this.localRegionApps.set(this.filterAndShuffle(apps));
            logger.debug("Got full registry with apps hashcode {}", (Object)apps.getAppsHashCode());
        } else {
            logger.warn("Not updating applications as another thread is updating it already");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndUpdateDelta(Applications applications) throws Throwable {
        long currentUpdateGeneration = this.fetchRegistryGeneration.get();
        Applications delta = null;
        EurekaHttpResponse httpResponse = this.eurekaTransport.queryClient.getDelta(this.remoteRegionsRef.get());
        if (httpResponse.getStatusCode() == Response.Status.OK.getStatusCode()) {
            delta = (Applications)httpResponse.getEntity();
        }
        if (delta == null) {
            logger.warn("The server does not allow the delta revision to be applied because it is not safe. Hence got the full registry.");
            this.getAndStoreFullRegistry();
        } else if (this.fetchRegistryGeneration.compareAndSet(currentUpdateGeneration, currentUpdateGeneration + 1L)) {
            logger.debug("Got delta update with apps hashcode {}", (Object)delta.getAppsHashCode());
            String reconcileHashCode = "";
            if (this.fetchRegistryUpdateLock.tryLock()) {
                try {
                    this.updateDelta(delta);
                    reconcileHashCode = this.getReconcileHashCode(applications);
                }
                finally {
                    this.fetchRegistryUpdateLock.unlock();
                }
            } else {
                logger.warn("Cannot acquire update lock, aborting getAndUpdateDelta");
            }
            if (!reconcileHashCode.equals(delta.getAppsHashCode()) || this.clientConfig.shouldLogDeltaDiff()) {
                this.reconcileAndLogDifference(delta, reconcileHashCode);
            }
        } else {
            logger.warn("Not updating application delta as another thread is updating it already");
            logger.debug("Ignoring delta update with apps hashcode {}, as another thread is updating it already", (Object)delta.getAppsHashCode());
        }
    }

    private void logTotalInstances() {
        if (logger.isDebugEnabled()) {
            int totInstances = 0;
            for (Application application : this.getApplications().getRegisteredApplications()) {
                totInstances += application.getInstancesAsIsFromEureka().size();
            }
            logger.debug("The total number of all instances in the client now is {}", (Object)totInstances);
        }
    }

    private void reconcileAndLogDifference(Applications delta, String reconcileHashCode) throws Throwable {
        logger.debug("The Reconcile hashcodes do not match, client : {}, server : {}. Getting the full registry", (Object)reconcileHashCode, (Object)delta.getAppsHashCode());
        this.RECONCILE_HASH_CODES_MISMATCH.increment();
        long currentUpdateGeneration = this.fetchRegistryGeneration.get();
        EurekaHttpResponse httpResponse = this.clientConfig.getRegistryRefreshSingleVipAddress() == null ? this.eurekaTransport.queryClient.getApplications(this.remoteRegionsRef.get()) : this.eurekaTransport.queryClient.getVip(this.clientConfig.getRegistryRefreshSingleVipAddress(), this.remoteRegionsRef.get());
        Applications serverApps = (Applications)httpResponse.getEntity();
        if (serverApps == null) {
            logger.warn("Cannot fetch full registry from the server; reconciliation failure");
        } else if (this.fetchRegistryGeneration.compareAndSet(currentUpdateGeneration, currentUpdateGeneration + 1L)) {
            this.localRegionApps.set(this.filterAndShuffle(serverApps));
            this.getApplications().setVersion(delta.getVersion());
            logger.debug("The Reconcile hashcodes after complete sync up, client : {}, server : {}.", (Object)this.getApplications().getReconcileHashCode(), (Object)delta.getAppsHashCode());
        } else {
            logger.warn("Not setting the applications map as another thread has advanced the update generation");
        }
    }

    private void updateDelta(Applications delta) {
        int deltaCount = 0;
        for (Application app : delta.getRegisteredApplications()) {
            for (InstanceInfo instance : app.getInstances()) {
                Application existingApp;
                Applications applications = this.getApplications();
                String instanceRegion = this.instanceRegionChecker.getInstanceRegion(instance);
                if (!this.instanceRegionChecker.isLocalRegion(instanceRegion)) {
                    Applications remoteApps = this.remoteRegionVsApps.get(instanceRegion);
                    if (null == remoteApps) {
                        remoteApps = new Applications();
                        this.remoteRegionVsApps.put(instanceRegion, remoteApps);
                    }
                    applications = remoteApps;
                }
                ++deltaCount;
                if (InstanceInfo.ActionType.ADDED.equals((Object)instance.getActionType())) {
                    existingApp = applications.getRegisteredApplications(instance.getAppName());
                    if (existingApp == null) {
                        applications.addApplication(app);
                    }
                    logger.debug("Added instance {} to the existing apps in region {}", (Object)instance.getId(), (Object)instanceRegion);
                    applications.getRegisteredApplications(instance.getAppName()).addInstance(instance);
                    continue;
                }
                if (InstanceInfo.ActionType.MODIFIED.equals((Object)instance.getActionType())) {
                    existingApp = applications.getRegisteredApplications(instance.getAppName());
                    if (existingApp == null) {
                        applications.addApplication(app);
                    }
                    logger.debug("Modified instance {} to the existing apps ", (Object)instance.getId());
                    applications.getRegisteredApplications(instance.getAppName()).addInstance(instance);
                    continue;
                }
                if (!InstanceInfo.ActionType.DELETED.equals((Object)instance.getActionType()) || (existingApp = applications.getRegisteredApplications(instance.getAppName())) == null) continue;
                logger.debug("Deleted instance {} to the existing apps ", (Object)instance.getId());
                existingApp.removeInstance(instance);
                if (!existingApp.getInstancesAsIsFromEureka().isEmpty()) continue;
                applications.removeApplication(existingApp);
            }
        }
        logger.debug("The total number of instances fetched by the delta processor : {}", (Object)deltaCount);
        this.getApplications().setVersion(delta.getVersion());
        this.getApplications().shuffleInstances(this.clientConfig.shouldFilterOnlyUpInstances());
        for (Applications applications : this.remoteRegionVsApps.values()) {
            applications.setVersion(delta.getVersion());
            applications.shuffleInstances(this.clientConfig.shouldFilterOnlyUpInstances());
        }
    }

    private void initScheduledTasks() {
        int expBackOffBound;
        int renewalIntervalInSecs;
        if (this.clientConfig.shouldFetchRegistry()) {
            renewalIntervalInSecs = this.clientConfig.getRegistryFetchIntervalSeconds();
            expBackOffBound = this.clientConfig.getCacheRefreshExecutorExponentialBackOffBound();
            this.cacheRefreshTask = new TimedSupervisorTask("cacheRefresh", this.scheduler, this.cacheRefreshExecutor, renewalIntervalInSecs, TimeUnit.SECONDS, expBackOffBound, (Runnable)new CacheRefreshThread());
            this.scheduler.schedule((Runnable)this.cacheRefreshTask, (long)renewalIntervalInSecs, TimeUnit.SECONDS);
        }
        if (this.clientConfig.shouldRegisterWithEureka()) {
            renewalIntervalInSecs = this.instanceInfo.getLeaseInfo().getRenewalIntervalInSecs();
            expBackOffBound = this.clientConfig.getHeartbeatExecutorExponentialBackOffBound();
            logger.info("Starting heartbeat executor: renew interval is: {}", (Object)renewalIntervalInSecs);
            this.heartbeatTask = new TimedSupervisorTask("heartbeat", this.scheduler, this.heartbeatExecutor, renewalIntervalInSecs, TimeUnit.SECONDS, expBackOffBound, (Runnable)new HeartbeatThread());
            this.scheduler.schedule((Runnable)this.heartbeatTask, (long)renewalIntervalInSecs, TimeUnit.SECONDS);
            this.instanceInfoReplicator = new InstanceInfoReplicator(this, this.instanceInfo, this.clientConfig.getInstanceInfoReplicationIntervalSeconds(), 2);
            this.statusChangeListener = new ApplicationInfoManager.StatusChangeListener(){

                public String getId() {
                    return "statusChangeListener";
                }

                public void notify(StatusChangeEvent statusChangeEvent) {
                    logger.info("Saw local status change event {}", (Object)statusChangeEvent);
                    DiscoveryClient.this.instanceInfoReplicator.onDemandUpdate();
                }
            };
            if (this.clientConfig.shouldOnDemandUpdateStatusChange()) {
                this.applicationInfoManager.registerStatusChangeListener(this.statusChangeListener);
            }
            this.instanceInfoReplicator.start(this.clientConfig.getInitialInstanceInfoReplicationIntervalSeconds());
        } else {
            logger.info("Not registering with Eureka server per configuration");
        }
    }

    private void cancelScheduledTasks() {
        if (this.instanceInfoReplicator != null) {
            this.instanceInfoReplicator.stop();
        }
        if (this.heartbeatExecutor != null) {
            this.heartbeatExecutor.shutdownNow();
        }
        if (this.cacheRefreshExecutor != null) {
            this.cacheRefreshExecutor.shutdownNow();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        if (this.cacheRefreshTask != null) {
            this.cacheRefreshTask.cancel();
        }
        if (this.heartbeatTask != null) {
            this.heartbeatTask.cancel();
        }
    }

    @Deprecated
    public List<String> getServiceUrlsFromDNS(String instanceZone, boolean preferSameZone) {
        return EndpointUtils.getServiceUrlsFromDNS((EurekaClientConfig)this.clientConfig, (String)instanceZone, (boolean)preferSameZone, (EndpointUtils.ServiceUrlRandomizer)this.urlRandomizer);
    }

    @Deprecated
    public List<String> getDiscoveryServiceUrls(String zone) {
        return EndpointUtils.getDiscoveryServiceUrls((EurekaClientConfig)this.clientConfig, (String)zone, (EndpointUtils.ServiceUrlRandomizer)this.urlRandomizer);
    }

    void refreshInstanceInfo() {
        InstanceInfo.InstanceStatus status;
        this.applicationInfoManager.refreshDataCenterInfoIfRequired();
        this.applicationInfoManager.refreshLeaseInfoIfRequired();
        try {
            status = this.getHealthCheckHandler().getStatus(this.instanceInfo.getStatus());
        }
        catch (Exception var3) {
            logger.warn("Exception from healthcheckHandler.getStatus, setting status to DOWN", (Throwable)var3);
            status = InstanceInfo.InstanceStatus.DOWN;
        }
        if (null != status) {
            this.applicationInfoManager.setInstanceStatus(status);
        }
    }

    @VisibleForTesting
    InstanceInfoReplicator getInstanceInfoReplicator() {
        return this.instanceInfoReplicator;
    }

    @VisibleForTesting
    InstanceInfo getInstanceInfo() {
        return this.instanceInfo;
    }

    public HealthCheckHandler getHealthCheckHandler() {
        HealthCheckHandler healthCheckHandler = this.healthCheckHandlerRef.get();
        if (healthCheckHandler == null) {
            if (null != this.healthCheckHandlerProvider) {
                healthCheckHandler = (HealthCheckHandler)this.healthCheckHandlerProvider.get();
            } else if (null != this.healthCheckCallbackProvider) {
                healthCheckHandler = new HealthCheckCallbackToHandlerBridge((HealthCheckCallback)this.healthCheckCallbackProvider.get());
            }
            if (null == healthCheckHandler) {
                healthCheckHandler = new HealthCheckCallbackToHandlerBridge(null);
            }
            this.healthCheckHandlerRef.compareAndSet(null, healthCheckHandler);
        }
        return this.healthCheckHandlerRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void refreshRegistry() {
        try {
            boolean success;
            boolean isFetchingRemoteRegionRegistries = this.isFetchingRemoteRegionRegistries();
            boolean remoteRegionsModified = false;
            String latestRemoteRegions = this.clientConfig.fetchRegistryForRemoteRegions();
            if (null != latestRemoteRegions) {
                String currentRemoteRegions = this.remoteRegionsToFetch.get();
                if (!latestRemoteRegions.equals(currentRemoteRegions)) {
                    AzToRegionMapper azToRegionMapper = this.instanceRegionChecker.getAzToRegionMapper();
                    synchronized (azToRegionMapper) {
                        if (this.remoteRegionsToFetch.compareAndSet(currentRemoteRegions, latestRemoteRegions)) {
                            String[] remoteRegions = latestRemoteRegions.split(",");
                            this.remoteRegionsRef.set(remoteRegions);
                            this.instanceRegionChecker.getAzToRegionMapper().setRegionsToFetch(remoteRegions);
                            remoteRegionsModified = true;
                        } else {
                            logger.info("Remote regions to fetch modified concurrently, ignoring change from {} to {}", (Object)currentRemoteRegions, (Object)latestRemoteRegions);
                        }
                    }
                } else {
                    this.instanceRegionChecker.getAzToRegionMapper().refreshMapping();
                }
            }
            if (success = this.fetchRegistry(remoteRegionsModified)) {
                this.registrySize = this.localRegionApps.get().size();
                this.lastSuccessfulRegistryFetchTimestamp = System.currentTimeMillis();
            }
            if (logger.isDebugEnabled()) {
                StringBuilder allAppsHashCodes = new StringBuilder();
                allAppsHashCodes.append("Local region apps hashcode: ");
                allAppsHashCodes.append(this.localRegionApps.get().getAppsHashCode());
                allAppsHashCodes.append(", is fetching remote regions? ");
                allAppsHashCodes.append(isFetchingRemoteRegionRegistries);
                for (Map.Entry<String, Applications> entry : this.remoteRegionVsApps.entrySet()) {
                    allAppsHashCodes.append(", Remote region: ");
                    allAppsHashCodes.append(entry.getKey());
                    allAppsHashCodes.append(" , apps hashcode: ");
                    allAppsHashCodes.append(entry.getValue().getAppsHashCode());
                }
                logger.debug("Completed cache refresh task for discovery. All Apps hash code is {} ", (Object)allAppsHashCodes);
            }
        }
        catch (Throwable var9) {
            logger.error("Cannot fetch registry from server", var9);
        }
    }

    private boolean fetchRegistryFromBackup() {
        try {
            BackupRegistry backupRegistryInstance = this.newBackupRegistryInstance();
            if (null == backupRegistryInstance) {
                backupRegistryInstance = (BackupRegistry)this.backupRegistryProvider.get();
            }
            if (null != backupRegistryInstance) {
                Applications apps = null;
                if (this.isFetchingRemoteRegionRegistries()) {
                    String remoteRegionsStr = this.remoteRegionsToFetch.get();
                    if (null != remoteRegionsStr) {
                        apps = backupRegistryInstance.fetchRegistry(remoteRegionsStr.split(","));
                    }
                } else {
                    apps = backupRegistryInstance.fetchRegistry();
                }
                if (apps != null) {
                    Applications applications = this.filterAndShuffle(apps);
                    applications.setAppsHashCode(applications.getReconcileHashCode());
                    this.localRegionApps.set(applications);
                    this.logTotalInstances();
                    logger.info("Fetched registry successfully from the backup");
                    return true;
                }
            } else {
                logger.warn("No backup registry instance defined & unable to find any discovery servers.");
            }
        }
        catch (Throwable var4) {
            logger.warn("Cannot fetch applications from apps although backup registry was specified", var4);
        }
        return false;
    }

    @Deprecated
    @Nullable
    protected BackupRegistry newBackupRegistryInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return null;
    }

    private Applications filterAndShuffle(Applications apps) {
        if (apps != null) {
            if (this.isFetchingRemoteRegionRegistries()) {
                ConcurrentHashMap<String, Applications> remoteRegionVsApps = new ConcurrentHashMap<String, Applications>();
                apps.shuffleAndIndexInstances(remoteRegionVsApps, this.clientConfig, this.instanceRegionChecker);
                for (Applications applications : remoteRegionVsApps.values()) {
                    applications.shuffleInstances(this.clientConfig.shouldFilterOnlyUpInstances());
                }
                this.remoteRegionVsApps = remoteRegionVsApps;
            } else {
                apps.shuffleInstances(this.clientConfig.shouldFilterOnlyUpInstances());
            }
        }
        return apps;
    }

    private boolean isFetchingRemoteRegionRegistries() {
        return null != this.remoteRegionsToFetch.get();
    }

    protected void onRemoteStatusChanged(InstanceInfo.InstanceStatus oldStatus, InstanceInfo.InstanceStatus newStatus) {
        this.fireEvent((EurekaEvent)new StatusChangeEvent(oldStatus, newStatus));
    }

    protected void onCacheRefreshed() {
        this.fireEvent((EurekaEvent)new CacheRefreshedEvent());
    }

    protected void fireEvent(EurekaEvent event) {
        for (EurekaEventListener listener : this.eventListeners) {
            try {
                listener.onEvent(event);
            }
            catch (Exception var5) {
                logger.info("Event {} throw an exception for listener {}", new Object[]{event, listener, var5.getMessage()});
            }
        }
    }

    public long getLastSuccessfulHeartbeatTimePeriod() {
        return this.lastSuccessfulHeartbeatTimestamp < 0L ? this.lastSuccessfulHeartbeatTimestamp : System.currentTimeMillis() - this.lastSuccessfulHeartbeatTimestamp;
    }

    public long getLastSuccessfulRegistryFetchTimePeriod() {
        return this.lastSuccessfulRegistryFetchTimestamp < 0L ? this.lastSuccessfulRegistryFetchTimestamp : System.currentTimeMillis() - this.lastSuccessfulRegistryFetchTimestamp;
    }

    @Monitor(name="eurekaClient.registration.lastSuccessfulHeartbeatTimePeriod", description="How much time has passed from last successful heartbeat", type=DataSourceType.GAUGE)
    private long getLastSuccessfulHeartbeatTimePeriodInternal() {
        long delay = this.clientConfig.shouldRegisterWithEureka() && !this.isShutdown.get() ? this.getLastSuccessfulHeartbeatTimePeriod() : 0L;
        this.heartbeatStalenessMonitor.update(this.computeStalenessMonitorDelay(delay));
        return delay;
    }

    @Monitor(name="eurekaClient.registry.lastSuccessfulRegistryFetchTimePeriod", description="How much time has passed from last successful local registry update", type=DataSourceType.GAUGE)
    private long getLastSuccessfulRegistryFetchTimePeriodInternal() {
        long delay = this.clientConfig.shouldFetchRegistry() && !this.isShutdown.get() ? this.getLastSuccessfulRegistryFetchTimePeriod() : 0L;
        this.registryStalenessMonitor.update(this.computeStalenessMonitorDelay(delay));
        return delay;
    }

    @Monitor(name="eurekaClient.registry.localRegistrySize", description="Count of instances in the local registry", type=DataSourceType.GAUGE)
    public int localRegistrySize() {
        return this.registrySize;
    }

    private long computeStalenessMonitorDelay(long delay) {
        return delay < 0L ? System.currentTimeMillis() - this.initTimestampMs : delay;
    }

    public Stats getStats() {
        return this.stats;
    }

    public class RegistryIndetity {
        private String appName;
        private String instanceId;
        private String appid;
        private boolean isNotChanged = false;

        public String getInstanceId() {
            return this.instanceId;
        }

        public RegistryIndetity withInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public String getAppid() {
            return this.appid;
        }

        public RegistryIndetity withAppid(String appid) {
            this.appid = appid;
            return this;
        }

        public String getAppName() {
            return this.appName;
        }

        public RegistryIndetity withAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public boolean isNotChanged() {
            return this.isNotChanged;
        }

        public RegistryIndetity withNotChanged(boolean isNotChanged) {
            this.isNotChanged = isNotChanged;
            return this;
        }
    }

    private class HeartbeatThread
    implements Runnable {
        private HeartbeatThread() {
        }

        @Override
        public void run() {
            if (!Instance.isPausedServiceByMonitor() && DiscoveryClient.this.renew()) {
                DiscoveryClient.this.lastSuccessfulHeartbeatTimestamp = System.currentTimeMillis();
            }
        }
    }

    class CacheRefreshThread
    implements Runnable {
        CacheRefreshThread() {
        }

        @Override
        public void run() {
            DiscoveryClient.this.refreshRegistry();
        }
    }

    public class Stats {
        private Stats() {
        }

        public int initLocalRegistrySize() {
            return DiscoveryClient.this.initRegistrySize;
        }

        public long initTimestampMs() {
            return DiscoveryClient.this.initTimestampMs;
        }

        public int localRegistrySize() {
            return DiscoveryClient.this.registrySize;
        }

        public long lastSuccessfulRegistryFetchTimestampMs() {
            return DiscoveryClient.this.lastSuccessfulRegistryFetchTimestamp;
        }

        public long lastSuccessfulHeartbeatTimestampMs() {
            return DiscoveryClient.this.lastSuccessfulHeartbeatTimestamp;
        }

        public boolean initSucceeded() {
            return this.initLocalRegistrySize() > 0 && this.initTimestampMs() > 0L;
        }
    }

    private static final class EurekaTransport {
        private ClosableResolver bootstrapResolver;
        private TransportClientFactory transportClientFactory;
        private EurekaHttpClient registrationClient;
        private EurekaHttpClientFactory registrationClientFactory;
        private EurekaHttpClient queryClient;
        private EurekaHttpClientFactory queryClientFactory;

        private EurekaTransport() {
        }

        void shutdown() {
            if (this.registrationClientFactory != null) {
                this.registrationClientFactory.shutdown();
            }
            if (this.queryClientFactory != null) {
                this.queryClientFactory.shutdown();
            }
            if (this.registrationClient != null) {
                this.registrationClient.shutdown();
            }
            if (this.queryClient != null) {
                this.queryClient.shutdown();
            }
            if (this.transportClientFactory != null) {
                this.transportClientFactory.shutdown();
            }
            if (this.bootstrapResolver != null) {
                this.bootstrapResolver.shutdown();
            }
        }
    }

    public static class DiscoveryClientOptionalArgs
    extends Jersey1DiscoveryClientOptionalArgs {
    }
}

