/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import kd.bos.context.KdtxRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.mservice.common.NullObject;
import kd.bos.mservice.common.rpc.FeignRequsetParam;
import kd.bos.mservice.common.rpc.RegisterAppNameUtils;
import kd.bos.mservice.common.rpc.param.CommonRpcParam;
import kd.bos.mservice.common.rpc.param.KdFeignContext;
import kd.bos.mservice.context.BaseContext;
import kd.bos.mservice.rpc.feign.FeignDispatchClient;
import kd.bos.mservice.rpc.feign.FeignDispatchService;
import kd.bos.mservice.rpc.feign.response.FeignResultWrapper;
import kd.bos.trace.tracer.MemSpanTrace;
import kd.bos.util.StringUtils;

public class FeignProxyFactory {
    public static <T> T createProxy(Class<T> clazz, String appId) {
        Handler<T> handler = new Handler<T>(clazz, appId);
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, handler);
        return (T)proxy;
    }

    public static <T> T createProxy(Class<T> clazz, String appId, String dataCodecType) {
        Handler<T> handler = new Handler<T>(clazz, appId);
        handler.setDataCodecType(dataCodecType);
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, handler);
        return (T)proxy;
    }

    public static <T> T createHostProxy(Class<T> clazz, String ip, String port) {
        if (StringUtils.isEmpty((String)port)) {
            port = System.getProperty("server.port", "8080");
        }
        String host = ip + ":" + port;
        Handler<T> handler = new Handler<T>(clazz, true, host);
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, handler);
        return (T)proxy;
    }

    private static class Handler<T>
    implements InvocationHandler {
        private String appId;
        private String host;
        private boolean peer2peer;
        private String dataCodecType = "javaobj";

        public Handler(Class<T> model, String appId) {
            this.appId = appId;
        }

        public Handler(Class<T> model, boolean peer2peer, String host) {
            this.host = host;
            this.peer2peer = peer2peer;
        }

        public void setDataCodecType(String dataCodecType) {
            this.dataCodecType = dataCodecType;
        }

        /*
         * Loose catch block
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                FeignDispatchService dispatchService = FeignDispatchClient.getDispatchService();
                KdFeignContext.create();
                CommonRpcParam param = this.createCommonRpcParam(method, args);
                this.builidFeignRequsetParam(method, args);
                if (this.peer2peer) {
                    RegisterAppNameUtils.setRequestHost((String)this.host);
                } else {
                    RegisterAppNameUtils.setRequestAppID((String)this.appId);
                }
                StringBuilder sb = new StringBuilder();
                if (args != null && args.length == 4) {
                    sb.append(args[0]).append(":").append(args[1]).append("#").append(args[2]).append(" ");
                }
                if (this.peer2peer) {
                    sb.append("request host:").append(this.host);
                } else {
                    sb.append("request appid:").append(this.appId);
                }
                try (MemSpanTrace span = MemSpanTrace.create((String)"FeignInvoke", (String)sb.toString());){
                    Object object;
                    Object result;
                    RegisterAppNameUtils.setRequestCodecType((String)this.dataCodecType);
                    Object obj = result = dispatchService.invoke(this.dataCodecType, param);
                    if (result instanceof FeignResultWrapper) {
                        KdtxRequestContext kdtxRC;
                        FeignResultWrapper wrapper = (FeignResultWrapper)result;
                        obj = wrapper.getResult();
                        RequestContext rc = wrapper.getRc();
                        if (rc != null) {
                            RequestContext.set((RequestContext)rc);
                        }
                        if ((kdtxRC = wrapper.getKdtxRC()) != null && StringUtils.isNotEmpty((String)kdtxRC.getXid())) {
                            KdtxRequestContext.set((KdtxRequestContext)kdtxRC);
                        }
                    }
                    if (obj instanceof Throwable) {
                        throw (Throwable)obj;
                    }
                    if (obj instanceof NullObject) {
                        object = null;
                        return object;
                    }
                    object = obj;
                    return object;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                RegisterAppNameUtils.clearAll();
            }
        }

        private CommonRpcParam createCommonRpcParam(Method method, Object[] args) {
            CommonRpcParam param = new CommonRpcParam();
            param.setAppId(this.appId);
            param.setParamsType((Class[])method.getParameterTypes());
            param.setParams(args);
            param.setInterfaceName(method.getDeclaringClass().getName());
            param.setMethodName(method.getName());
            param.setBaseContext((BaseContext)KdFeignContext.get());
            return param;
        }

        private void builidFeignRequsetParam(Method method, Object[] args) {
            FeignRequsetParam fparam = new FeignRequsetParam();
            fparam.setInterfaceName(method.getDeclaringClass().getName());
            fparam.setMethodName(method.getName());
            fparam.setParams(args);
            RegisterAppNameUtils.setRequestFeignParam((FeignRequsetParam)fparam);
        }
    }
}

