/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.instance.Instance;
import kd.bos.mservice.debug.DebugUtil;
import kd.bos.mservice.rpc.feign.FeignProxyFactory;
import kd.bos.mservice.rpc.feign.FeignServiceRegister;
import kd.bos.mservice.rpc.feign.debug.FeignLocalDebugProxy;
import kd.bos.mservice.spi.rpc.MServiceLookup;
import kd.bos.util.AppUtils;

public class FeignServiceLookup
implements MServiceLookup {
    private static ConcurrentHashMap<String, Object> appIdInstanceMap;
    private static boolean debugInstance;
    private static boolean canlooluplocal;

    public <T> T lookup(Class<T> clazz, String appId) {
        T obj;
        boolean debugMode = DebugUtil.isDebugMode();
        if (debugMode || debugInstance) {
            appId = "debug";
        }
        if (!((obj = this.doLookupImpl(clazz, appId, "javaobj")) instanceof Proxy) && (debugMode || debugInstance)) {
            obj = FeignLocalDebugProxy.debugProxy(clazz, obj);
        }
        return obj;
    }

    public <T> T lookupHttp(Class<T> clazz, String appId, String dataCodecType) {
        T obj;
        boolean debugMode = DebugUtil.isDebugMode();
        if (debugMode || debugInstance) {
            appId = "debug";
        }
        if (!((obj = this.doLookupImpl(clazz, appId, dataCodecType)) instanceof Proxy) && (debugMode || debugInstance)) {
            obj = FeignLocalDebugProxy.debugProxy(clazz, obj);
        }
        return obj;
    }

    private <T> T doLookupImpl(Class<T> clazz, String appId, String dataCodecType) {
        Object o;
        if (!Instance.isAppSplit() && !AppUtils.isDeployAloneApp((String)appId)) {
            return this.lookupNotAppSplit(clazz, dataCodecType);
        }
        if (canlooluplocal && (o = FeignServiceRegister.getServiceInstance(appId, clazz.getName())) != null) {
            return (T)o;
        }
        String key = clazz.getName() + ":" + appId + ":" + dataCodecType;
        return (T)appIdInstanceMap.computeIfAbsent(key, k -> FeignProxyFactory.createProxy(clazz, appId, dataCodecType));
    }

    private <T> T lookupNotAppSplit(Class<T> clazz, String dataCodecType) {
        Object o = FeignServiceRegister.getServiceInstance(clazz.getName());
        if (canlooluplocal && o != null) {
            return (T)o;
        }
        String key = clazz.getName() + ":" + dataCodecType;
        return (T)appIdInstanceMap.computeIfAbsent(key, k -> FeignProxyFactory.createProxy(clazz, null, dataCodecType));
    }

    public <T> T lookupEndpoint(Class<T> type, String ip, String port) {
        String key = type.getName() + "_" + ip + "_" + port;
        return (T)appIdInstanceMap.computeIfAbsent(key, k -> FeignProxyFactory.createHostProxy(type, ip, port));
    }

    static {
        block6: {
            appIdInstanceMap = new ConcurrentHashMap();
            debugInstance = false;
            canlooluplocal = true;
            debugInstance = Instance.isDebugInstance();
            if (debugInstance) {
                canlooluplocal = true;
            } else {
                try {
                    String str = System.getProperty("feign.lookup.local");
                    if (str != null) {
                        canlooluplocal = Boolean.parseBoolean(str);
                        break block6;
                    }
                    List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
                    for (String arg : args) {
                        if (!arg.startsWith("-agentlib:jdwp")) continue;
                        canlooluplocal = false;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

