/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.mservice.config.MserviceAssemblyConfig;
import kd.bos.mservice.spi.rpc.MServiceRegister;
import kd.bos.service.register.extra.ExtraRegisterStartService;
import kd.bos.util.AppUtils;

public class FeignServiceRegister
implements MServiceRegister {
    private static final Map<String, String> serviceInterfaces = new HashMap<String, String>(4);
    private static final Map<String, Set<String>> serviceAppIds = new HashMap<String, Set<String>>(4);
    private static final Map<String, Object> serviceInstants = new ConcurrentHashMap<String, Object>(4);
    private static final Map<String, Object> localServiceInstants = new ConcurrentHashMap<String, Object>(4);
    private static final Set<String> appidSet = new HashSet<String>(2);
    private static final Set<String> innerAppidSet = new HashSet<String>(2);
    public static final String INSTANCEID_KEY = "serverInstanceId";
    public static final String APPID_KEY = "serverAppId";

    public static String getAppids() {
        return appidSet.toString();
    }

    public void registerConsumer(String arg0, String arg1) {
    }

    public void registerService(String serviceName, String config) {
        Properties p = new Properties();
        try {
            p.load(new StringReader(config));
            String i = (String)p.get("interface");
            String c = (String)p.get("class");
            Set<String> appIdSet = this.getAppIds(p);
            serviceInterfaces.put(i, c);
            serviceAppIds.put(i, appIdSet);
            ExtraRegisterStartService.start((String)serviceName, (String)config);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{"registerService error:" + serviceName});
        }
    }

    public boolean supportHttp() {
        return true;
    }

    private Set<String> getAppIds(Properties props) {
        String str = props.getProperty("appIds");
        if (str == null) {
            return appidSet;
        }
        HashSet<String> appidSet = new HashSet<String>(2);
        if (Instance.isAppSplit()) {
            for (String appId : Instance.parseAppIds((String)str)) {
                appidSet.add(appId);
            }
        }
        return appidSet;
    }

    public static String getServiceClassName(String interfaceName) {
        return serviceInterfaces.get(interfaceName);
    }

    public static Object getServiceInstance(String interfaceName) {
        return serviceInstants.computeIfAbsent(interfaceName, k -> {
            String className = serviceInterfaces.get(interfaceName);
            try {
                return className == null ? null : Class.forName(className).newInstance();
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{"create service instance error:" + className});
            }
        });
    }

    public static Object getServiceInstance(String appid, String interfaceName) {
        if (appidSet.contains(appid) || innerAppidSet.contains(appid)) {
            String key = appid + "-" + interfaceName;
            return localServiceInstants.computeIfAbsent(key, k -> FeignServiceRegister.getServiceInstance(interfaceName));
        }
        return null;
    }

    public static Map<String, Set<String>> getServiceAppIdMap() {
        return Collections.unmodifiableMap(serviceAppIds);
    }

    static {
        if ("feign".equals(MserviceAssemblyConfig.getMserviceRpcType()) || "assembly".equals(MserviceAssemblyConfig.getMserviceRpcType())) {
            String[] innerAppIds;
            String[] appIds = Instance.getAppIds();
            boolean isCurrentDeployAlone = AppUtils.isDeployAloneApps((String[])appIds);
            if (Instance.isAppSplit() && appIds != null || isCurrentDeployAlone) {
                for (String appId : appIds) {
                    if (Instance.getDeployedCloudByApp((String)appId) != null) continue;
                    appidSet.add(appId);
                }
                Set clouds = Instance.getDeployedClouds();
                clouds.forEach(cloud -> {
                    String cloudtag = "cloud--" + cloud;
                    appidSet.add(cloudtag);
                });
            }
            if (Instance.isAppSplit() && (innerAppIds = Instance.getInnerAppIds()) != null) {
                for (String appId : innerAppIds) {
                    innerAppidSet.add(appId);
                }
            }
        }
    }
}

