/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.controller;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kd.bos.armor.core.ArmorException;
import kd.bos.context.KdtxRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mservice.common.NullObject;
import kd.bos.mservice.common.rpc.param.CommonRpcParam;
import kd.bos.mservice.common.rpc.param.KdFeignContext;
import kd.bos.mservice.debug.DebugUtil;
import kd.bos.mservice.rpc.feign.FeignDispatchService;
import kd.bos.mservice.rpc.feign.FeignServiceRegister;
import kd.bos.mservice.rpc.feign.debug.FeignDebugUtil;
import kd.bos.mservice.rpc.feign.response.FeignResultWrapper;
import kd.bos.mservice.serialization.KServiceSerialization;
import kd.bos.mservice.serialization.KServiceSerializationFactory;
import kd.bos.service.InvokeService;
import kd.bos.thread.OutOfMemoryObserver;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.SafeLogUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FeignDispatchServiceController
implements FeignDispatchService {
    private static final String REQUEST_DISPATCH_SERVICE_FEIGN = "kdDispatchServiceFeign";

    @Override
    @RequestMapping(value={"kdDispatchServiceFeign"}, method={RequestMethod.POST}, produces={"application/xx-kd-serialization; charset=UTF-8"})
    public Object invoke(@RequestHeader(value="codecType", defaultValue="javaobj") String codecType, @RequestBody(required=false) CommonRpcParam c) {
        CommonRpcParam params = (CommonRpcParam)ThreadTruck.get((Object)"commonRpcParam");
        Class[] paramTypsClass = params.getParamsType();
        RequestContext rc = KdFeignContext.get().getRequestContext();
        String interfaceName = params.getInterfaceName();
        String methodName = params.getMethodName();
        if (!KServiceSerializationFactory.isBinarySerialization((String)codecType)) {
            boolean isInvokeService = InvokeService.class.getName().equals(interfaceName);
            KServiceSerialization serializer = KServiceSerializationFactory.getSerializer((String)codecType);
            if (!isInvokeService) {
                Object[] args = params.getParams();
                Class[] paramTypes = params.getParamsType();
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] == null) continue;
                    args[i] = serializer.deserialize((InputStream)new ByteArrayInputStream((byte[])args[i]), paramTypes[i]);
                }
            }
        }
        try {
            FeignResultWrapper resultWrapper = new FeignResultWrapper();
            Object result = FeignDebugUtil.invoke(rc, () -> {
                Method methods = Class.forName(FeignServiceRegister.getServiceClassName(interfaceName)).getMethod(methodName, paramTypsClass);
                resultWrapper.setReturnType(methods.getReturnType());
                Object service = FeignServiceRegister.getServiceInstance(interfaceName);
                Object robj = methods.invoke(service, params.getParams());
                return robj == null ? NullObject.instance : robj;
            }, () -> interfaceName + "." + methodName + "(" + DebugUtil.argumentsInfo((Object[])params.getParams()) + ")");
            resultWrapper.setResult(result);
            resultWrapper.setCodecType(codecType);
            resultWrapper.setKdtxRC(KdtxRequestContext.get());
            resultWrapper.setRc(RequestContext.get());
            return resultWrapper;
        }
        catch (Throwable e) {
            SafeLogUtils.info(FeignDispatchServiceController.class, (String)("feigndispatchinvokeerror by " + interfaceName), (Throwable)e);
            e = this.findRootCause(e);
            if (e instanceof KDException) {
                return e;
            }
            if (e instanceof ArmorException) {
                return new KDException(e.getCause(), BosErrorCode.bOS, new Object[]{e.getMessage()});
            }
            return new KDException(e, BosErrorCode.bOS, new Object[]{"invoke service error:" + interfaceName + "#" + methodName + ",errMsg:" + e.getMessage()});
        }
    }

    private Throwable findRootCause(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        if (throwable instanceof OutOfMemoryError) {
            OutOfMemoryObserver.onOutOfMemory((OutOfMemoryError)((OutOfMemoryError)throwable));
            return throwable;
        }
        if (throwable.getCause() != null && throwable.getCause() != throwable) {
            return this.findRootCause(throwable.getCause());
        }
        return throwable;
    }
}

