/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.controller;

import kd.bos.instance.Instance;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.MserviceStatus;
import kd.bos.mservice.monitor.MserviceStatusManger;
import kd.bos.mservice.rpc.handshake.entity.HandShakeStatus;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HealthExaminationController {
    @RequestMapping(value={"/health/handShake"}, method={RequestMethod.POST})
    public ResponseEntity<Void> handShake(@RequestHeader(value="code") String checkCode) {
        MserviceStatus mst = MserviceStatusManger.getMserviceStatus();
        int level = mst.getNodeHealthLevel().getLevel();
        HttpHeaders headers = new HttpHeaders();
        if (HealthLevel.OVERLOAD.getLevel() < level || Instance.isPausedServiceByMonitor()) {
            headers.add("HandShakeStatus", HandShakeStatus.REFUSE.name());
        } else if (HealthLevel.BUSY.getLevel() <= level) {
            headers.add("HandShakeStatus", HandShakeStatus.BUSY.name());
        } else {
            headers.add("HandShakeStatus", HandShakeStatus.NORMAL.name());
        }
        headers.add("code", checkCode);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).build();
    }
}

