/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.registry;

import com.netflix.discovery.DiscoveryClient;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.kregistrycenter.RegistrationInfo;
import kd.bos.mservice.rpc.feign.FeignServiceRegister;
import kd.bos.mservice.rpc.feign.registry.RegistryCallback;
import kd.bos.mservice.rpc.feign.registry.nacos.NacosServiceRegistry;
import kd.bos.mservice.rpc.handshake.entity.RequestStatus;
import kd.bos.service.register.ServiceRegister;
import kd.bos.util.ExceptionUtils;
import org.apache.curator.x.discovery.ServiceInstance;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;

public class RegistryFailedRetry<T> {
    private final ScheduledExecutorService retryExecutor;
    private Map<T, String> serviceInstances = new ConcurrentHashMap<T, String>(2);
    private AtomicBoolean isRetrying = new AtomicBoolean(false);
    private volatile boolean lastPasedStatus = false;
    private RegistryCallback<T> registryCallback;
    private final SecureRandom random = new SecureRandom();
    private boolean hasFinshBaseInit = false;
    private static Map<String, RegistryFailedRetry<?>> registryInstances = new ConcurrentHashMap(2);
    private static RegistryFailedRetry<?> defaultInstance = null;
    private static Set<String> hasInitRegisterySet = new HashSet<String>(2);
    private static final Log log = LogFactory.getLog(RegistryFailedRetry.class);

    public static RegistryFailedRetry<?> getInstance(String type, RegistryCallback<?> callback) {
        if (type == null) {
            return null;
        }
        return registryInstances.computeIfAbsent(type, k -> {
            defaultInstance = new RegistryFailedRetry(callback, type);
            return defaultInstance;
        });
    }

    public static RegistryFailedRetry getInstance() {
        return defaultInstance;
    }

    private RegistryFailedRetry(RegistryCallback<T> callback, final String type) {
        this.registryCallback = callback;
        if (ServiceRegister.isMServiceRegistryEnable()) {
            this.retryExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "FeignRegistryFailedRetryTimer_" + type);
                    t.setDaemon(true);
                    return t;
                }
            });
            this.init();
        } else {
            this.retryExecutor = null;
        }
    }

    private void init() {
        int retryPeriod = Integer.getInteger("feign.registry.retry.period", 30000);
        this.retryExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!RegistryFailedRetry.this.hasFinshBaseInit) {
                        return;
                    }
                    this.initDelay();
                    RegistryFailedRetry.this.retry(false);
                }
                catch (Throwable t) {
                    try {
                        log.error("Unexpected error occur at failed retry, cause: " + t.getMessage(), t);
                    }
                    catch (Throwable st) {
                        ExceptionUtils.parseException((Throwable)st);
                    }
                }
            }

            private void initDelay() {
                Map<String, Set<String>> map = FeignServiceRegister.getServiceAppIdMap();
                map.forEach((interfaceName, appids) -> {
                    if (appids.isEmpty()) {
                        if (!hasInitRegisterySet.contains(interfaceName)) {
                            RegistryFailedRetry.this.initRegistryDelay(interfaceName, null);
                        }
                    } else {
                        appids.forEach(appid -> {
                            if (!hasInitRegisterySet.contains(RegistryFailedRetry.this.getRegisteryKey(interfaceName, appid))) {
                                RegistryFailedRetry.this.initRegistryDelay(interfaceName, appid);
                            }
                        });
                    }
                });
            }
        }, retryPeriod, retryPeriod, TimeUnit.MILLISECONDS);
    }

    private void initRegistryDelay(String interfaceName, String appid) {
        log.info(" delayinit interfaces :" + interfaceName + ":" + appid);
        try {
            this.registryCallback.initRegistryDelay(interfaceName, appid);
        }
        catch (Exception e) {
            log.error(" delayinit interfaces :" + interfaceName + ":" + appid, (Throwable)e);
        }
    }

    public void addRegistery(T indentity) {
        this.serviceInstances.put(indentity, "");
    }

    public void hasInitRegistery(String interfaceName, String appid) {
        hasInitRegisterySet.add(this.getRegisteryKey(interfaceName, appid));
    }

    private String getRegisteryKey(String interfaceName, String appid) {
        return interfaceName + (appid == null ? "" : appid);
    }

    public void reRegistry() {
        this.retry(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retry(boolean force) {
        if (this.isRetrying.compareAndSet(false, true)) {
            try {
                boolean isChannge;
                boolean isPausedServiceByMonitor = Instance.isPausedServiceByMonitor();
                boolean bl = isChannge = this.lastPasedStatus != isPausedServiceByMonitor;
                if (isChannge) {
                    this.lastPasedStatus = isPausedServiceByMonitor;
                }
                if (isPausedServiceByMonitor) {
                    this.serviceInstances.forEach((k, v) -> {
                        try {
                            if (isChannge) {
                                this.registryCallback.unRegistry(k);
                            }
                        }
                        catch (Exception e) {
                            log.error("registryCallback.doRegistry error", (Throwable)e);
                        }
                    });
                } else {
                    this.serviceInstances.forEach((k, v) -> {
                        try {
                            String appid = "";
                            if (k instanceof ServiceInstance) {
                                Object payload = ((ServiceInstance)k).getPayload();
                                if (payload instanceof ZookeeperInstance) {
                                    appid = (String)((ZookeeperInstance)payload).getMetadata().get("serverAppId");
                                }
                            } else if (k instanceof DiscoveryClient.RegistryIndetity) {
                                appid = ((DiscoveryClient.RegistryIndetity)k).getAppid();
                            } else if (k instanceof NacosServiceRegistry.NacosRegistryInfo) {
                                appid = ((NacosServiceRegistry.NacosRegistryInfo)k).getAppId();
                            } else if (k instanceof RegistrationInfo) {
                                appid = (String)((RegistrationInfo)k).getMetadata().get("serverAppId");
                            }
                            int randomValue = this.random.nextInt(100) % 10;
                            if (force || randomValue == 0 || isChannge || RequestStatus.isAppRequestFrequency((String)appid)) {
                                this.registryCallback.doRegistry(k);
                            }
                        }
                        catch (Exception e) {
                            log.error("registryCallback.unRegistry error", (Throwable)e);
                        }
                    });
                }
            }
            finally {
                this.isRetrying.set(false);
            }
        }
    }

    public void finishBaseInit() {
        log.info("hasFinshBaseRegistryInit");
        this.hasFinshBaseInit = true;
    }
}

