/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.registry.kregistrycenter;

import java.util.HashMap;
import kd.bos.instance.Instance;
import kd.bos.mservice.common.rpc.RegisterAppNameUtils;
import kd.bos.mservice.kregistrycenter.RegistrationInfo;
import kd.bos.mservice.rpc.feign.registry.kregistrycenter.registry.KCommonRegistration;
import kd.bos.serializer.HessianSerializer;
import kd.bos.util.HexUtils;
import kd.bos.zk.ZKFactory;

public class RegistrationUtils {
    private static RegistrationInfo createRegistration() {
        RegistrationInfo out = new RegistrationInfo(new HashMap());
        String registryCenterAddress = System.getProperty("spring.cloud.kcommonregistry.connect-string");
        String registryCenterUser = System.getProperty("spring.cloud.kcommonregistry.username");
        String registryCenterPwd = System.getProperty("spring.cloud.kcommonregistry.password");
        out.withRegistryUrl(registryCenterAddress, registryCenterUser, registryCenterPwd);
        out.setRootPath((registryCenterAddress == null ? "/" : ZKFactory.getZkRootPath((String)registryCenterAddress)) + "kservices/" + Instance.getClusterName());
        return out;
    }

    public static RegistrationInfo createRegistration(String appid, String interfaceName) {
        RegistrationInfo out = RegistrationUtils.createRegistration();
        out.categoryPath = "/" + interfaceName + (Instance.isAppSplit() ? "/" + appid + "/providers" : "/providers");
        out.categoriesPath = new String[]{out.categoryPath};
        out.setServiceKey(RegisterAppNameUtils.getRegisterAppName((String)appid, (String)interfaceName));
        String clusterName = Instance.getClusterName();
        out.setClusterName(clusterName);
        out.setInstanceId(Instance.getInstanceId());
        out.setServiceInterface(interfaceName);
        out.getMetadata().put("serverAppId", appid);
        out.getMetadata().put("serverInstanceId", Instance.getInstanceId());
        out.setServicePath("/" + interfaceName + (Instance.isAppSplit() ? "/" + appid : ""));
        out.setEphemeral(true);
        return out;
    }

    public static RegistrationInfo createRegistration(String appid, String interfaceName, String host, int port, KCommonRegistration input) {
        RegistrationInfo out = RegistrationUtils.createRegistration(appid, interfaceName);
        out.setHost(host);
        out.setPort(port);
        out.fullUrl = "kcommonregistry://" + host + ":" + port + "/?" + RegistrationUtils.toParam(input);
        return out;
    }

    private static String toParam(KCommonRegistration input) {
        try {
            return HexUtils.toHex((byte[])HessianSerializer.serialize((Object)input));
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }
}

