/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.registry.kregistrycenter.registry;

import java.util.List;
import kd.bos.mservice.discovery.KRegistryInstanceTransformAdapter;
import kd.bos.mservice.kregistrycenter.RegistrationInfo;
import kd.bos.mservice.kregistrycenter.spi.KRegistryCenter;
import kd.bos.mservice.kregistrycenter.spi.KRegistryCenterFactory;
import kd.bos.mservice.rpc.feign.registry.RegistryCallback;
import kd.bos.mservice.rpc.feign.registry.RegistryFailedRetry;
import kd.bos.mservice.rpc.feign.registry.kregistrycenter.RegistrationUtils;
import kd.bos.mservice.rpc.feign.registry.kregistrycenter.registry.KCommonRegistration;
import kd.bos.service.register.ServiceRegister;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;

public class KCommonServiceRegistry
implements ServiceRegistry<KCommonRegistration> {
    private KRegistryCenter registryCenter = KRegistryCenterFactory.getRegistryCenter();
    private KCommonRegistration baseRegistration = null;
    private RegistryFailedRetry registryFailedRetry = RegistryFailedRetry.getInstance("KCommonServiceRegistry", new RegistryCallback<RegistrationInfo>(){

        @Override
        public void doRegistry(RegistrationInfo service) throws Exception {
            KCommonServiceRegistry.this.registryCenter.doSaveRegister(service);
        }

        @Override
        public void unRegistry(RegistrationInfo service) throws Exception {
            KCommonServiceRegistry.this.registryCenter.doRemoveRegister(service);
        }

        @Override
        public void initRegistryDelay(String interfaceName, String appid) throws Exception {
            RegistrationInfo registrationInfo = KCommonServiceRegistry.this.createRegistration(interfaceName, appid);
            if (registrationInfo != null) {
                KCommonServiceRegistry.this.registryCenter.doSaveRegister(registrationInfo);
                KCommonServiceRegistry.this.registryFailedRetry.addRegistery(registrationInfo);
                KCommonServiceRegistry.this.registryFailedRetry.hasInitRegistery(interfaceName, appid);
            }
        }
    });

    private RegistrationInfo createRegistration(String interfaceName, String appId) {
        if (this.baseRegistration == null) {
            return null;
        }
        RegistrationInfo out = RegistrationUtils.createRegistration(appId, interfaceName, this.baseRegistration.getHost(), this.baseRegistration.getPort(), this.baseRegistration);
        return out;
    }

    public void register(KCommonRegistration registration) {
        if (!ServiceRegister.isMServiceRegistryEnable()) {
            return;
        }
        this.baseRegistration = registration;
        KRegistryInstanceTransformAdapter transformAdapter = KRegistryInstanceTransformAdapter.getAdapter((String)"http", (String)"kcommonregistry", (KRegistryInstanceTransformAdapter.SourceRegistryType)new KRegistryInstanceTransformAdapter.SourceRegistryType<KCommonRegistration, RegistrationInfo>(){});
        List instances = transformAdapter.getRegistryList((Object)registration);
        for (KRegistryInstanceTransformAdapter.RegistryInstanceWrapper instanceWarpper : instances) {
            this.registryCenter.doSaveRegister((RegistrationInfo)instanceWarpper.getInstacne());
            String interfaceName = instanceWarpper.getInterfaceName();
            String appId = instanceWarpper.getAppId();
            this.registryFailedRetry.addRegistery(instanceWarpper.getInstacne());
            this.registryFailedRetry.hasInitRegistery(interfaceName, appId);
        }
        this.registryFailedRetry.finishBaseInit();
    }

    public void deregister(KCommonRegistration registration) {
    }

    public void close() {
    }

    public void setStatus(KCommonRegistration registration, String status) {
    }

    public Object getStatus(KCommonRegistration registration) {
        return null;
    }
}

