/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.registry.kregistrycenter.registry;

import kd.bos.mservice.rpc.feign.registry.kregistrycenter.ConditionalOnKCommonDiscoveryEnabled;
import kd.bos.mservice.rpc.feign.registry.kregistrycenter.registry.KCommonDiscoveryProperties;
import kd.bos.mservice.rpc.feign.registry.kregistrycenter.registry.KCommonRegistration;
import kd.bos.mservice.rpc.feign.registry.kregistrycenter.registry.KCommonServiceRegistry;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.details.JsonInstanceSerializer;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.serviceregistry.ServiceRegistryAutoConfiguration;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
@ConditionalOnKCommonDiscoveryEnabled
@ConditionalOnProperty(value={"spring.cloud.service-registry.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={ServiceRegistryAutoConfiguration.class})
public class KCommonServiceRegistryAutoConfiguration
implements ApplicationContextAware {
    public void setApplicationContext(ApplicationContext context) throws BeansException {
    }

    @Bean
    public KCommonServiceRegistry kCommonServiceRegistry() {
        KCommonServiceRegistry registry = new KCommonServiceRegistry();
        return registry;
    }

    @Bean
    public KCommonRegistration kCommonRegistration(ApplicationContext context, KCommonDiscoveryProperties properties) {
        String appName = context.getEnvironment().getProperty("spring.application.name", "application");
        String host = properties.getInstanceHost();
        KCommonRegistration registration = new KCommonRegistration();
        registration.setServiceId(context.getId());
        registration.setHost(host);
        return registration;
    }

    @Bean
    @ConditionalOnMissingBean
    public InstanceSerializer<KCommonRegistration> instanceSerializer() {
        return new JsonInstanceSerializer(KCommonRegistration.class);
    }

    @Bean
    @ConditionalOnMissingBean
    public KCommonDiscoveryProperties kCommonDiscoveryProperties(InetUtils inetUtils) {
        return new KCommonDiscoveryProperties(inetUtils);
    }
}

