/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.registry.zookeeper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kd.bos.instance.Instance;
import kd.bos.mservice.common.rpc.RegisterAppNameUtils;
import kd.bos.mservice.discovery.KRegistryInstanceTransformAdapter;
import kd.bos.mservice.rpc.feign.FieldUtils;
import kd.bos.mservice.rpc.feign.registry.RegistryCallback;
import kd.bos.mservice.rpc.feign.registry.RegistryFailedRetry;
import kd.bos.mservice.rpc.feign.registry.zookeeper.ZookeeperRootPathUtils;
import kd.bos.service.register.ServiceRegister;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.utils.CloseableUtils;
import org.apache.curator.utils.ExceptionAccumulator;
import org.apache.curator.utils.ZKPaths;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceProvider;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;

public class ServiceDiscoveryImpl<T>
extends org.apache.curator.x.discovery.details.ServiceDiscoveryImpl<T> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final CuratorFramework client;
    private final String basePath;
    private final InstanceSerializer<T> serializer;
    private final ConcurrentMap<String, Entry<T>> services = Maps.newConcurrentMap();
    private final Collection<ServiceProvider<T>> providers = Sets.newSetFromMap((Map)Maps.newConcurrentMap());
    private final boolean watchInstances;
    private ServiceInstance<T> modelService;
    private RegistryFailedRetry registryFailedRetry = RegistryFailedRetry.getInstance("ServiceDiscoveryImpl", new RegistryCallback<ServiceInstance<T>>(){

        @Override
        public void doRegistry(ServiceInstance<T> service) throws Exception {
            ServiceDiscoveryImpl.this.internalRegisterServiceNoNeedNofify(service);
        }

        @Override
        public void unRegistry(ServiceInstance<T> service) throws Exception {
            String path = ServiceDiscoveryImpl.this.pathForInstance(service.getName(), service.getId());
            try {
                ((ChildrenDeletable)ServiceDiscoveryImpl.this.client.delete().guaranteed()).forPath(path);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
        }

        @Override
        public void initRegistryDelay(String interfaceName, String appid) throws Exception {
            if (ServiceDiscoveryImpl.this.modelService != null) {
                if (appid == null) {
                    FieldUtils.setFiledValue("name", ServiceDiscoveryImpl.this.modelService, RegisterAppNameUtils.getRegisterInterfaceName((String)interfaceName));
                    ServiceDiscoveryImpl.this._registerService(ServiceDiscoveryImpl.this.modelService);
                    ServiceDiscoveryImpl.this.registryFailedRetry.hasInitRegistery(interfaceName, null);
                } else {
                    FieldUtils.setFiledValue("name", ServiceDiscoveryImpl.this.modelService, RegisterAppNameUtils.getRegisterAppName((String)appid, (String)interfaceName));
                    Object payload = ServiceDiscoveryImpl.this.modelService.getPayload();
                    if (payload instanceof ZookeeperInstance) {
                        ((ZookeeperInstance)payload).getMetadata().put("serverAppId", appid);
                    }
                    ServiceDiscoveryImpl.this._registerService(ServiceDiscoveryImpl.this.modelService);
                    ServiceDiscoveryImpl.this.registryFailedRetry.hasInitRegistery(interfaceName, appid);
                }
            }
        }
    });
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState == ConnectionState.RECONNECTED || newState == ConnectionState.CONNECTED) {
                try {
                    ServiceDiscoveryImpl.this.log.debug("Re-registering due to reconnection");
                    ServiceDiscoveryImpl.this.registryFailedRetry.reRegistry();
                }
                catch (Exception e) {
                    ServiceDiscoveryImpl.this.log.error("Could not re-register instances after reconnection", (Throwable)e);
                }
            }
        }
    };

    public ServiceDiscoveryImpl(CuratorFramework client, InstanceSerializer<T> serializer, ServiceInstance<T> thisInstance, ZookeeperDiscoveryProperties properties) {
        super(client, System.getProperty("spring.cloud.zookeeper.discovery.root", ZookeeperRootPathUtils.getZkPrePath() + (String)Preconditions.checkNotNull((Object)properties.getRoot(), (Object)"basePath cannot be null") + "/" + Instance.getClusterName()), serializer, thisInstance, false);
        this.watchInstances = false;
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
        this.basePath = System.getProperty("spring.cloud.zookeeper.discovery.root", ZookeeperRootPathUtils.getZkPrePath() + (String)Preconditions.checkNotNull((Object)properties.getRoot(), (Object)"basePath cannot be null") + "/" + Instance.getClusterName());
        this.serializer = (InstanceSerializer)Preconditions.checkNotNull(serializer, (Object)"serializer cannot be null");
        if (thisInstance != null) {
            Entry entry = new Entry(thisInstance);
            entry.cache = this.makeNodeCache(thisInstance);
            this.services.put(thisInstance.getId(), entry);
        }
    }

    public void start() throws Exception {
        try {
            this.reRegisterServices();
        }
        catch (KeeperException e) {
            this.log.error("Could not register instances - will try again later", (Throwable)e);
        }
        this.client.getConnectionStateListenable().addListener((Object)this.connectionStateListener);
    }

    public void close() throws IOException {
        ExceptionAccumulator accumulator = new ExceptionAccumulator();
        for (ServiceProvider provider : Lists.newArrayList(this.providers)) {
            CloseableUtils.closeQuietly((Closeable)provider);
        }
        for (Entry entry : this.services.values()) {
            try {
                this.internalUnregisterService(entry);
            }
            catch (KeeperException.NoNodeException noNodeException) {
            }
            catch (Exception e) {
                accumulator.add((Throwable)e);
                this.log.error("Could not unregister instance: " + entry.service.getName(), (Throwable)e);
            }
        }
        this.client.getConnectionStateListenable().removeListener((Object)this.connectionStateListener);
        accumulator.propagate();
    }

    public void registerService(ServiceInstance<T> service) throws Exception {
        if (!ServiceRegister.isMServiceRegistryEnable()) {
            return;
        }
        Object payload = service.getPayload();
        if (payload instanceof ZookeeperInstance) {
            ((ZookeeperInstance)payload).getMetadata().put("serverInstanceId", Instance.getInstanceId());
        }
        this.setModelService(service);
        KRegistryInstanceTransformAdapter transformAdapter = KRegistryInstanceTransformAdapter.getAdapter((String)"http", (String)"zookeeper", (KRegistryInstanceTransformAdapter.SourceRegistryType)new KRegistryInstanceTransformAdapter.SourceRegistryType<ServiceInstance<T>, ServiceInstance<T>>(){

            public ServiceInstance<T> copy(ServiceInstance<T> arg0) {
                try {
                    byte[] bytes = ServiceDiscoveryImpl.this.serializer.serialize(arg0);
                    return ServiceDiscoveryImpl.this.serializer.deserialize(bytes);
                }
                catch (Exception e) {
                    ServiceDiscoveryImpl.this.log.error("ServiceInstance copy serror", (Throwable)e);
                    return arg0;
                }
            }
        });
        List instances = transformAdapter.getRegistryList(service);
        for (KRegistryInstanceTransformAdapter.RegistryInstanceWrapper instance : instances) {
            this._registerService((ServiceInstance)instance.getInstacne());
            String interfaceName = instance.getInterfaceName();
            String appId = instance.getAppId();
            this.registryFailedRetry.hasInitRegistery(interfaceName, appId);
        }
        this.registryFailedRetry.finishBaseInit();
    }

    private void setModelService(ServiceInstance<T> service) {
        try {
            byte[] bytes = this.serializer.serialize(service);
            this.modelService = this.serializer.deserialize(bytes);
        }
        catch (Exception e) {
            this.log.error("set model servcie serror", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _registerService(ServiceInstance<T> service) throws Exception {
        Entry useEntry;
        Entry newEntry = new Entry(service);
        Entry oldEntry = this.services.putIfAbsent(service.getId(), newEntry);
        Entry entry = useEntry = oldEntry != null ? oldEntry : newEntry;
        synchronized (entry) {
            if (useEntry == newEntry) {
                useEntry.cache = this.makeNodeCache(service);
            }
            this.internalRegisterService(service, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateService(ServiceInstance<T> service) throws Exception {
        Entry entry = (Entry)this.services.get(service.getId());
        if (entry == null) {
            throw new Exception("Service not registered: " + service);
        }
        Entry entry2 = entry;
        synchronized (entry2) {
            entry.service = service;
            byte[] bytes = this.serializer.serialize(service);
            String path = this.pathForInstance(service.getName(), service.getId());
            this.client.setData().forPath(path, bytes);
        }
    }

    @VisibleForTesting
    protected void internalRegisterService(ServiceInstance<T> service) throws Exception {
        this.internalRegisterService(service, false, true);
    }

    private void internalRegisterServiceNoNeedNofify(ServiceInstance<T> service) throws Exception {
        this.internalRegisterService(service, false, false);
    }

    private void internalRegisterService(ServiceInstance<T> service, boolean isbase, boolean reNotify) throws Exception {
        byte[] bytes = this.serializer.serialize(service);
        if (isbase) {
            this.registryFailedRetry.addRegistery(this.serializer.deserialize(bytes));
        }
        String path = this.pathForInstance(service.getName(), service.getId());
        int MAX_TRIES = 2;
        boolean isDone = false;
        for (int i = 0; !isDone && i < 2; ++i) {
            try {
                CreateMode mode;
                switch (service.getServiceType()) {
                    case DYNAMIC: {
                        mode = CreateMode.EPHEMERAL;
                        break;
                    }
                    case DYNAMIC_SEQUENTIAL: {
                        mode = CreateMode.EPHEMERAL_SEQUENTIAL;
                        break;
                    }
                    default: {
                        mode = CreateMode.PERSISTENT;
                    }
                }
                ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentContainersIfNeeded().withMode(mode)).forPath(path, bytes);
                isDone = true;
                continue;
            }
            catch (KeeperException.NodeExistsException e) {
                if (!reNotify) continue;
                this.client.delete().forPath(path);
            }
        }
    }

    public void unregisterService(ServiceInstance<T> service) throws Exception {
        Entry entry = (Entry)this.services.remove(service.getId());
        this.internalUnregisterService(entry);
    }

    public Collection<String> queryForNames() throws Exception {
        List names = (List)this.client.getChildren().forPath(this.basePath);
        return ImmutableList.copyOf((Collection)names);
    }

    public Collection<ServiceInstance<T>> queryForInstances(String name) throws Exception {
        return this.queryForInstances(name, null);
    }

    public ServiceInstance<T> queryForInstance(String name, String id) throws Exception {
        String path = this.pathForInstance(name, id);
        try {
            byte[] bytes = (byte[])this.client.getData().forPath(path);
            return this.serializer.deserialize(bytes);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return null;
        }
    }

    void cacheOpened(ServiceCache<T> cache) {
    }

    void cacheClosed(ServiceCache<T> cache) {
    }

    void providerOpened(ServiceProvider<T> provider) {
        this.providers.add(provider);
    }

    void providerClosed(ServiceProvider<T> cache) {
        this.providers.remove(cache);
    }

    CuratorFramework getClient() {
        return this.client;
    }

    String pathForName(String name) {
        return ZKPaths.makePath((String)this.basePath, (String)name);
    }

    InstanceSerializer<T> getSerializer() {
        return this.serializer;
    }

    List<ServiceInstance<T>> queryForInstances(String name, Watcher watcher) throws Exception {
        List<Object> instanceIds;
        ImmutableList.Builder builder = ImmutableList.builder();
        String path = this.pathForName(name);
        if (watcher != null) {
            instanceIds = this.getChildrenWatched(path, watcher, true);
        } else {
            try {
                instanceIds = (List)this.client.getChildren().forPath(path);
            }
            catch (KeeperException.NoNodeException e) {
                instanceIds = Lists.newArrayList();
            }
        }
        for (String string : instanceIds) {
            ServiceInstance<T> instance = this.queryForInstance(name, string);
            if (instance == null) continue;
            builder.add(instance);
        }
        return builder.build();
    }

    @VisibleForTesting
    int debugServicesQty() {
        return this.services.size();
    }

    private List<String> getChildrenWatched(String path, Watcher watcher, boolean recurse) throws Exception {
        List<String> instanceIds;
        try {
            instanceIds = (List<String>)((BackgroundPathable)this.client.getChildren().usingWatcher(watcher)).forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            if (recurse) {
                try {
                    this.client.create().creatingParentContainersIfNeeded().forPath(path);
                }
                catch (KeeperException.NodeExistsException nodeExistsException) {
                    // empty catch block
                }
                instanceIds = this.getChildrenWatched(path, watcher, false);
            }
            throw e;
        }
        return instanceIds;
    }

    @VisibleForTesting
    String pathForInstance(String name, String id) {
        return ZKPaths.makePath((String)this.pathForName(name), (String)id);
    }

    @VisibleForTesting
    ServiceInstance<T> getRegisteredService(String id) {
        Entry entry = (Entry)this.services.get(id);
        return entry != null ? entry.service : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reRegisterServices() throws Exception {
        Iterator iterator = this.services.values().iterator();
        while (iterator.hasNext()) {
            Entry entry;
            Entry entry2 = entry = (Entry)iterator.next();
            synchronized (entry2) {
                this.internalRegisterService(entry.service);
            }
        }
    }

    private NodeCache makeNodeCache(final ServiceInstance<T> instance) {
        if (!this.watchInstances) {
            return null;
        }
        final NodeCache nodeCache = new NodeCache(this.client, this.pathForInstance(instance.getName(), instance.getId()));
        try {
            nodeCache.start(true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Exception e) {
            this.log.error("Could not start node cache for: " + instance, (Throwable)e);
        }
        NodeCacheListener listener = new NodeCacheListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void nodeChanged() throws Exception {
                if (nodeCache.getCurrentData() != null) {
                    ServiceInstance newInstance = ServiceDiscoveryImpl.this.serializer.deserialize(nodeCache.getCurrentData().getData());
                    Entry entry = (Entry)ServiceDiscoveryImpl.this.services.get(newInstance.getId());
                    if (entry != null) {
                        Entry entry2 = entry;
                        synchronized (entry2) {
                            entry.service = newInstance;
                        }
                    }
                } else {
                    ServiceDiscoveryImpl.this.log.warn("Instance data has been deleted for: " + instance);
                }
            }
        };
        nodeCache.getListenable().addListener((Object)listener);
        return nodeCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalUnregisterService(Entry<T> entry) throws Exception {
        if (entry != null) {
            Entry<T> entry2 = entry;
            synchronized (entry2) {
                if (((Entry)entry).cache != null) {
                    CloseableUtils.closeQuietly((Closeable)((Entry)entry).cache);
                    ((Entry)entry).cache = null;
                }
                String path = this.pathForInstance(((Entry)entry).service.getName(), ((Entry)entry).service.getId());
                try {
                    ((ChildrenDeletable)this.client.delete().guaranteed()).forPath(path);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    // empty catch block
                }
            }
        }
    }

    private static class Entry<T> {
        private volatile ServiceInstance<T> service;
        private volatile NodeCache cache;

        private Entry(ServiceInstance<T> service) {
            this.service = service;
        }
    }
}

