/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.rule;

import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestTimeoutContext;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.common.exception.RpcException;
import kd.bos.mservice.common.rpc.RegisterAppNameUtils;
import kd.bos.mservice.monitor.MserviceStatus;
import kd.bos.mservice.monitor.healthmanage.cluster.ClusterHealth;
import kd.bos.mservice.monitor.healthmanage.inspect.InvokeStatistics;
import kd.bos.mservice.monitor.healthmanage.inspect.InvokeStatisticsFactory;
import kd.bos.mservice.rpc.handshake.ClientTypeEnum;
import kd.bos.mservice.rpc.handshake.HandshakeService;
import kd.bos.mservice.rpc.handshake.HandshakeServiceFactory;
import kd.bos.mservice.rpc.handshake.entity.HandShakeException;
import kd.bos.mservice.rpc.handshake.entity.HandShakeRequest;
import kd.bos.mservice.rpc.handshake.entity.HandShakeResponse;
import kd.bos.mservice.rpc.handshake.entity.HandShakeStatus;
import kd.bos.mservice.rpc.handshake.entity.RpcStatus;
import kd.bos.mservice.sdk.thread.InnerThreadTruck;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.reporter.apicall.APICallTagInject;
import kd.bos.trace.reporter.topology.TopologyTagInject;
import kd.bos.util.NetAddressUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.RandomLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Mono;

public class CustomHealthBalanceRule
extends RandomLoadBalancer {
    private static final Logger log = LoggerFactory.getLogger(CustomHealthBalanceRule.class);
    private static final InvokeStatistics statistics = InvokeStatisticsFactory.getInvokeStatictics((String)"rpc");
    private static final String srcIp = NetAddressUtils.getLocalIpAddress();
    private final String serviceId;
    private final SecureRandom random = new SecureRandom();
    private final ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider;
    private final HandshakeService handshakeService = HandshakeServiceFactory.get((ClientTypeEnum)ClientTypeEnum.APACHE_HTTP);
    private final Integer maxThreads = Integer.parseInt(System.getProperty("JETTY_MAXTHREADS", "200"));
    private final Map<String, Long> serverStartTimestamp = new ConcurrentHashMap<String, Long>(2);

    public CustomHealthBalanceRule(ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider, String serviceId) {
        super(serviceInstanceListSupplierProvider, serviceId);
        this.serviceId = serviceId;
        this.serviceInstanceListSupplierProvider = serviceInstanceListSupplierProvider;
    }

    public Mono<Response<ServiceInstance>> choose(Request request) {
        if ("true".equals(System.getProperty("feign.healthloadbalance.enable", "true"))) {
            ServiceInstanceListSupplier supplier = (ServiceInstanceListSupplier)this.serviceInstanceListSupplierProvider.getIfAvailable();
            assert (supplier != null);
            return supplier.get(request).next().map(this::chooseInstance);
        }
        return super.choose(request);
    }

    private Response<ServiceInstance> chooseInstance(List<ServiceInstance> instances) {
        if (instances.isEmpty()) {
            if (log.isWarnEnabled()) {
                log.warn("No servers available for service: " + this.serviceId);
            }
            throw new RpcException.RpcServiceUnavailableException("can't found server for " + this.serviceId);
        }
        Optional<ServiceInstance> server = this.chooseHealthAfterFiltering(instances);
        boolean isPresent = server.isPresent();
        if (!isPresent) {
            return new EmptyResponse();
        }
        String ip = server.get().getHost();
        int port = server.get().getPort();
        String ipAndPort = ip + ":" + port;
        if ("true".equals(System.getProperty("mservice.handshake.enable", "true")) && !"true".equals(InnerThreadTruck.get((Object)"tianshuInvokeOutService"))) {
            try (TraceSpan span = Tracer.create((String)"RpcHandShake", (String)"handshake", (boolean)true);){
                int leftCycleTimes;
                RpcStatus status = RpcStatus.getStatus((String)ipAndPort);
                HandShakeRequest handShakeRequest = new HandShakeRequest();
                handShakeRequest.setIpPort(ipAndPort);
                HandShakeResponse handShakeResponse = this.handshakeService.handshake(handShakeRequest);
                Throwable e = handShakeResponse.getException();
                for (leftCycleTimes = instances.size() - 1; e instanceof HandShakeException && leftCycleTimes >= 0; --leftCycleTimes) {
                    status.failedHandShake();
                    log.warn(handShakeRequest.hashCode() + " handshake error with  " + ipAndPort);
                    server = this.chooseHealthAfterFiltering(instances);
                    ip = server.get().getHost();
                    port = server.get().getPort();
                    if (leftCycleTimes <= 0) {
                        --leftCycleTimes;
                        break;
                    }
                    handShakeRequest = new HandShakeRequest();
                    handShakeRequest.setIpPort(ip + ":" + port);
                    handShakeResponse = this.handshakeService.handshake(handShakeRequest);
                    e = handShakeResponse.getException();
                }
                if (!(e instanceof HandShakeException) && leftCycleTimes >= 0) {
                    this.handleResponse(handShakeRequest, handShakeResponse);
                }
            }
        }
        this.doTrace(ip, port);
        this.setNextServerIp(ip);
        return new DefaultResponse(server.get());
    }

    private void setNextServerIp(String ip) {
        RequestTimeoutContext requestTimeoutContext = RequestTimeoutContext.get();
        if (requestTimeoutContext != null) {
            requestTimeoutContext.setNextServerIp(ip);
        }
    }

    private void doTrace(String ip, int port) {
        try {
            TraceSpan traceSpan = Tracer.getCurrentSpan();
            if (null != traceSpan) {
                String appName = ServiceInfoFactory.get().getAppNameByIp(ip);
                String ipAndPort = ip + ":" + port;
                TopologyTagInject.setMserviceTag((InnerSpan)traceSpan.getInnerSpan(), (String)appName, (String)"feign", (String)ServiceInfoFactory.get().getInstanceIdByIp(ip), (String)RegisterAppNameUtils.getRequestAppID());
                APICallTagInject.setIp((InnerSpan)traceSpan.getInnerSpan(), (String)srcIp, (String)ipAndPort);
            }
        }
        catch (Exception e) {
            log.warn("CustomHealthBalanceRule.doTrace() error: ", (Throwable)e);
        }
    }

    private void handleResponse(HandShakeRequest handShakeRequest, HandShakeResponse response) {
        RpcStatus rpcStatus = RpcStatus.getStatus((String)handShakeRequest.getIpPort());
        if (response.getCost() > 400L) {
            rpcStatus.busyHandShake();
        }
        if (HandShakeStatus.BUSY == response.getStatus()) {
            rpcStatus.busyHandShake();
        }
        rpcStatus.sucessHandShake();
    }

    private Optional<ServiceInstance> chooseHealthAfterFiltering(List<ServiceInstance> instances) {
        if (instances.size() == 0) {
            return Optional.empty();
        }
        ServiceInstance instance = instances.get(this.chooseServerIndex(instances));
        String servInstanceId = instance.getInstanceId();
        if (servInstanceId != null) {
            statistics.select(servInstanceId);
        }
        return Optional.of(instance);
    }

    private int chooseServerIndex(List<ServiceInstance> instances) {
        if (instances.size() == 1) {
            return 0;
        }
        int length = instances.size();
        double leastLoad = -2.0;
        int leastCount = 0;
        int[] leastIndexs = new int[length];
        int invokerMaxThread = this.maxThreads / (length + 1);
        for (int i = 0; i < length; ++i) {
            ServiceInstance instance = instances.get(i);
            String servInstanceId = instance.getInstanceId();
            int remoteHealthLeve = servInstanceId == null ? Integer.MAX_VALUE : ClusterHealth.getHealth((String)servInstanceId);
            long startTime = this.serverStartTimestamp.computeIfAbsent(instance.getHost() + servInstanceId, k -> System.currentTimeMillis());
            double activeLoad = remoteHealthLeve;
            RpcStatus rstatus = RpcStatus.getStatus((String)(instance.getHost() + ":" + instance.getPort()));
            if (rstatus.isHandShakeBreaked()) {
                activeLoad = 2.147483647E9;
            } else if ("true".equals(System.getProperty("loadbalance.delayinvokewhenstarted", "true")) && System.currentTimeMillis() - startTime < 60000L) {
                activeLoad = 2.147483645E9;
            } else if (rstatus.getActive() > invokerMaxThread) {
                activeLoad = 2.147483646E9;
            } else if (rstatus.isHandShakeBusy()) {
                activeLoad = Math.max(activeLoad, (double)MserviceStatus.Level.BUSY);
            }
            if (leastLoad == -2.0 || activeLoad < leastLoad) {
                leastLoad = activeLoad;
                leastCount = 1;
                leastIndexs[0] = i;
                continue;
            }
            if (activeLoad != leastLoad) continue;
            leastIndexs[leastCount++] = i;
        }
        if (leastCount == 1) {
            return leastIndexs[0];
        }
        return leastIndexs[this.random.nextInt(leastCount)];
    }
}

