/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.interceptors;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.KdtxRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.debug.DebugInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.auth.api.AuthContext;
import kd.bos.mservice.auth.exception.AuthErrorCode;
import kd.bos.mservice.auth.intercept.AuthServiceFactory;
import kd.bos.mservice.common.rpc.param.CommonRpcParam;
import kd.bos.mservice.common.rpc.param.KdFeignContext;
import kd.bos.mservice.context.BaseContext;
import kd.bos.mservice.context.KdBaseContextCodec;
import kd.bos.mservice.context.KdExternalContext;
import kd.bos.mservice.context.KdExternalRequestContext;
import kd.bos.mservice.rpc.interceptor.InterceptorChainProvider;
import kd.bos.mservice.rpc.serialization.HttpHeadUtils;
import kd.bos.mservice.serialization.KServiceSerializationFactory;
import kd.bos.mservice.spi.define.MServiceDefineMeta;
import kd.bos.service.invoke.MServiceFactory;
import kd.bos.thread.ThreadLocalUtils;
import kd.bos.thread.ThreadTruck;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.util.WebUtils;

public class ProviderInterceptorEntranceFilter
implements Filter {
    private static final Log log = LogFactory.getLog(ProviderInterceptorEntranceFilter.class);
    private static final String REQUEST_DISPATCH_SERVICE_FEIGN = "/kdDispatchServiceFeign";
    private static final String REQUEST_FEIGN_KD_CONVERTER_SERVICE = "/kdConverterServiceRequest";

    public void init(FilterConfig config) {
        log.info("init ProviderInterceptorEntranceFilter ...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException {
        Object threadMap = ThreadLocalUtils.getThreadLocalMap((Thread)Thread.currentThread());
        ThreadLocalUtils.setThreadLocalMap((Thread)Thread.currentThread(), null);
        try {
            HttpServletRequest httpRequest = (HttpServletRequest)WebUtils.getNativeRequest((ServletRequest)request, HttpServletRequest.class);
            String path = this.getPathAfterRemoveContextPath(httpRequest);
            this.toAuth(path, httpRequest);
            if ("/health/handShake".equals(path)) {
                chain.doFilter(request, response);
                return;
            }
            CommonRpcParam commonRpcParam = REQUEST_DISPATCH_SERVICE_FEIGN.equals(path) || REQUEST_FEIGN_KD_CONVERTER_SERVICE.equals(path) ? (CommonRpcParam)ThreadTruck.get((Object)"commonRpcParam") : this.createCommonRpcParam(httpRequest, path);
            InterceptorChainProvider.getProviderChain().handle(commonRpcParam, () -> {
                chain.doFilter(request, response);
                return null;
            });
        }
        catch (Throwable e) {
            log.error(e);
            this.handleExceptionResponse(response, e);
        }
        finally {
            this.removContext();
            ThreadLocalUtils.setThreadLocalMap((Thread)Thread.currentThread(), (Object)threadMap);
        }
    }

    private void handleExceptionResponse(ServletResponse response, Throwable e) throws IOException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)WebUtils.getNativeResponse((ServletResponse)response, HttpServletResponse.class);
        try {
            httpServletResponse.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            httpServletResponse.setContentType("application/json");
            httpServletResponse.getWriter().write(e.getMessage());
        }
        catch (Exception ex) {
            log.error("HandleExceptionResponse serialize error:", (Throwable)ex);
            throw ex;
        }
    }

    private void toAuth(String path, HttpServletRequest httpRequest) throws IOException {
        String clientUrl = path;
        if (!(!"/health/handShake".equals(path) || this.authEnable() && Boolean.getBoolean("mservice.auth.handshake.enable"))) {
            return;
        }
        if (!"/health/handShake".equals(path) && !REQUEST_DISPATCH_SERVICE_FEIGN.equals(path) && StringUtils.isEmpty((String)(clientUrl = httpRequest.getHeader("originalUri")))) {
            clientUrl = path;
        }
        BaseContext baseContext = null;
        if (REQUEST_DISPATCH_SERVICE_FEIGN.equals(path) || REQUEST_FEIGN_KD_CONVERTER_SERVICE.equals(path)) {
            CommonRpcParam commonRpcParam = (CommonRpcParam)KServiceSerializationFactory.getDefaultBinarySerializer().deserialize((InputStream)httpRequest.getInputStream(), CommonRpcParam.class);
            baseContext = commonRpcParam.getBaseContext();
            if ("restTemplate".equals(commonRpcParam.getAttachments().get("rpcType"))) {
                String originalRequest = httpRequest.getHeader("originalUri");
                if (StringUtils.isEmpty((String)originalRequest)) {
                    originalRequest = path;
                }
                this.modifyCommonRpcParam(commonRpcParam, originalRequest);
            }
            ThreadTruck.put((Object)"commonRpcParam", (Object)commonRpcParam);
        } else {
            String rpcContext = httpRequest.getHeader("rpcContext");
            if (StringUtils.isEmpty((String)rpcContext)) {
                log.error("The invoke {} request rpcContext_header is empty", (Object)clientUrl);
                throw new KDException(new ErrorCode(AuthErrorCode.DATA_INVALID.getCode(), "The invoke %s request rpcContext_header is empty"), new Object[]{clientUrl});
            }
            try {
                baseContext = KdBaseContextCodec.decode((String)rpcContext);
            }
            catch (Exception e) {
                log.error("The invoke {} request rpcContext_header data error,decode failed!", (Object)clientUrl);
                throw new KDException(new ErrorCode(AuthErrorCode.DATA_INVALID.getCode(), "The path %s request rpcContext_header data error,decode failed"), new Object[]{clientUrl});
            }
        }
        if (baseContext == null) {
            log.error("The invoke {} request rpcContext is empty", (Object)clientUrl);
            throw new KDException(new ErrorCode(AuthErrorCode.DATA_INVALID.getCode(), "The invoke %s request rpcContext is empty"), new Object[]{clientUrl});
        }
        AuthContext authContext = this.handleContext(baseContext);
        if (this.authEnable()) {
            if (authContext == null) {
                log.error("The path {} auth_context is empty,Authentication failed!", (Object)clientUrl);
                throw new KDException(new ErrorCode(AuthErrorCode.UNAUTHORIZED.getCode(), "The path %s auth_context is empty,Authentication failed"), new Object[]{clientUrl});
            }
            AuthServiceFactory.doAuth((AuthContext)authContext);
        }
    }

    private AuthContext handleContext(BaseContext baseContext) {
        AuthContext authContext = null;
        if (baseContext instanceof KdExternalContext) {
            KdExternalContext.set((KdExternalContext)((KdExternalContext)baseContext));
            authContext = ((KdExternalContext)baseContext).getAuthContext();
            KdExternalRequestContext externalRequestContext = KdExternalContext.get().getExternalRequestContext();
            TraceIdUtil.setCurrentTraceId((String)externalRequestContext.getTraceId());
            RequestContextCreator.createForMserviceSDK((String)externalRequestContext.getTenantId(), (String)externalRequestContext.getAccountId(), (String)externalRequestContext.getUserId());
        } else if (baseContext instanceof KdFeignContext) {
            KdFeignContext.set((KdFeignContext)((KdFeignContext)baseContext));
            authContext = ((KdFeignContext)baseContext).getAuthContext();
            RequestContext requestContext = ((KdFeignContext)baseContext).getRequestContext();
            this.setupProviderSideContext(requestContext);
            this.setupProviderSideKdtxContext(((KdFeignContext)baseContext).getKdtxRequestContext());
        }
        BaseContext.set((BaseContext)baseContext);
        return authContext;
    }

    private String getPathAfterRemoveContextPath(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String contextPath = request.getContextPath();
        String path = uri;
        if (contextPath != null && contextPath.length() > 0) {
            path = uri.substring(contextPath.length());
        }
        return path;
    }

    private MServiceDefineMeta getMServiceDefine(String requestPath) {
        MServiceDefineMeta serviceDefine = MServiceFactory.getServiceDefineByPath((String)requestPath);
        if (null == serviceDefine) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"The path: " + requestPath + " does not exist"});
        }
        return serviceDefine;
    }

    private void setupProviderSideContext(RequestContext rc) {
        RequestContext.set((RequestContext)rc);
        DebugInfo.setupThreadDebug((DebugInfo)rc.getDebugInfo());
        RequestContextThreadBinder.bind((RequestContext)rc);
    }

    private void setupProviderSideKdtxContext(KdtxRequestContext kdtxRequestContext) {
        KdtxRequestContext.set((KdtxRequestContext)kdtxRequestContext);
    }

    private CommonRpcParam createCommonRpcParam(HttpServletRequest httpRequest, String path) {
        String originalRequest;
        CommonRpcParam param = null;
        String commonRpcParamStr = httpRequest.getHeader("commonRpcParam");
        if (StringUtils.isNotEmpty((String)commonRpcParamStr)) {
            try {
                param = (CommonRpcParam)HttpHeadUtils.decode((String)commonRpcParamStr);
            }
            catch (Exception e) {
                param = null;
                log.warn("HttpHeadUtils decode CommonRpcParam error", (Throwable)e);
            }
        }
        if (param == null) {
            param = new CommonRpcParam();
        }
        if (StringUtils.isEmpty((String)(originalRequest = httpRequest.getHeader("originalUri")))) {
            originalRequest = path;
        }
        this.modifyCommonRpcParam(param, originalRequest);
        return param;
    }

    private void modifyCommonRpcParam(CommonRpcParam param, String originalRequest) {
        MServiceDefineMeta serviceDefine = this.getMServiceDefine(originalRequest);
        String serviceName = serviceDefine.getServiceName();
        Object serviceObject = MServiceFactory.getService((String)serviceName);
        MServiceDefineMeta.MethodDefine md = MServiceFactory.getMethodDefineByRequestPath((String)serviceName, (String)originalRequest);
        List pdLs = md.getServiceMethodParams();
        Method mehtod = MServiceFactory.findServiceMethod(serviceObject.getClass(), (String)md.getServiceMethodName(), (int)pdLs.size());
        param.setParamsType((Class[])mehtod.getParameterTypes());
        param.setInterfaceName(serviceName);
        param.setMethodName(mehtod.getName());
    }

    private boolean authEnable() {
        return Boolean.getBoolean("mservice.auth.enable");
    }

    private void removContext() {
        BaseContext.remove();
        KdExternalRequestContext.remove();
        KdExternalContext.remove();
        RequestContext.set(null);
        ThreadTruck.remove((Object)"commonRpcParam");
    }

    public void destroy() {
    }
}

