/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.interceptors.metric;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.metric.Counter;
import kd.bos.metric.Meter;
import kd.bos.metric.MetricSystem;
import kd.bos.metric.Timer;
import kd.bos.mservice.common.exception.RpcException;
import kd.bos.mservice.common.rpc.param.CommonRpcParam;
import kd.bos.mservice.rpc.interceptor.FeignCall;
import kd.bos.mservice.rpc.interceptor.chain.AbstractLinkedInterceptor;
import kd.bos.mservice.rpc.interceptor.spi.Intercept;

@Intercept(group="consumer", order=100)
public class ConsumerMetricInterceptor
extends AbstractLinkedInterceptor {
    private static final String CONFIG_PREFIX_KEY = "metric.feign.prefix";
    private static String prefix = "kd.metrics.feign.";
    private final Timer requestTimer;
    private final Meter errorsMeter;
    private final Meter timeoutMeter;
    private final Counter activeRequests;
    private final ConcurrentHashMap<String, Timer> requestTimerByService = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Meter> errorsMeterByService = new ConcurrentHashMap();

    public ConsumerMetricInterceptor() {
        prefix = System.getProperty(CONFIG_PREFIX_KEY, prefix);
        this.requestTimer = MetricSystem.timer((String)this.name("consumer.requestTimer"));
        this.errorsMeter = MetricSystem.meter((String)this.name("consumer.errors"));
        this.timeoutMeter = MetricSystem.meter((String)this.name("consumer.timeouts"));
        this.activeRequests = MetricSystem.counter((String)this.name("consumer.activeRequests"));
    }

    private String name(String suffix) {
        return prefix + suffix;
    }

    private Timer getRequestTimerByService(String serviceName) {
        Timer timer = this.requestTimerByService.get(serviceName);
        if (timer != null) {
            return timer;
        }
        timer = MetricSystem.timer((String)this.name("consumer.requestTimer." + serviceName));
        this.requestTimerByService.putIfAbsent(serviceName, timer);
        return timer;
    }

    private Meter getErrorsMeterByService(String serviceName) {
        Meter meter = this.errorsMeterByService.get(serviceName);
        if (meter != null) {
            return meter;
        }
        meter = MetricSystem.meter((String)this.name("consumer.errors." + serviceName));
        this.errorsMeterByService.putIfAbsent(serviceName, meter);
        return meter;
    }

    public Object handle(CommonRpcParam params, FeignCall feignCall) throws Throwable {
        String service = this.getServiceName(params);
        this.activeRequests.inc();
        Timer.Context context = this.requestTimer.time();
        Timer.Context contextByService = this.getRequestTimerByService(service).time();
        try {
            Object object = super.handle(params, feignCall);
            return object;
        }
        catch (Throwable e) {
            this.errorsMeter.mark();
            this.getErrorsMeterByService(service).mark();
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if (e instanceof RpcException.RpcTimeoutException) {
                this.timeoutMeter.mark();
            }
            throw e;
        }
        finally {
            context.stop();
            contextByService.stop();
            this.activeRequests.dec();
        }
    }

    private String getServiceName(CommonRpcParam params) {
        String[] serviceMethodArr = super.getConsumerServiceAndMethodName(params);
        String serviceName = serviceMethodArr[0];
        String methodName = serviceMethodArr[1];
        return serviceName + "." + methodName;
    }
}

