/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.interceptors.trace;

import kd.bos.govern.GovernConfigs;
import kd.bos.mservice.common.rpc.param.CommonRpcParam;
import kd.bos.mservice.rpc.interceptor.FeignCall;
import kd.bos.mservice.rpc.interceptor.chain.AbstractLinkedInterceptor;
import kd.bos.mservice.rpc.interceptor.spi.Intercept;
import kd.bos.mservice.rpc.interceptors.trace.FeignSpanInjector;
import kd.bos.trace.TraceConfig;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.reporter.apicall.APICallTagInject;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;

@Intercept(group="consumer", order=2000)
public class ConsumerSpanInterceptor
extends AbstractLinkedInterceptor {
    private static final String SPAN_SERVICE_TAG_NAME = "RpcServiceName";
    private static String ip = NetAddressUtils.getLocalIpAddress();
    private FeignSpanInjector spanInjector = new FeignSpanInjector();

    private static String getServiceName(String serviceName) {
        return serviceName.substring(serviceName.lastIndexOf(46) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handle(CommonRpcParam params, FeignCall feignCall) throws Throwable {
        boolean isContinue = TraceConfig.isTraceEnable() || GovernConfigs.getTopologyEnable() || GovernConfigs.getApicallEnable() || GovernConfigs.getBreakerEnable();
        TraceSpan traceSpan = null;
        try {
            if (isContinue) {
                String appId = params.getAppId();
                String spanName = "consumer(" + ip + ")";
                StringBuilder serviceNameBuild = new StringBuilder(spanName);
                serviceNameBuild.append("[");
                if (StringUtils.isNotEmpty((String)appId)) {
                    serviceNameBuild.append(appId).append(".");
                }
                String[] serviceMethodArr = super.getConsumerServiceAndMethodName(params);
                String serviceName = serviceMethodArr[0];
                String methodName = serviceMethodArr[1];
                serviceNameBuild.append(serviceName).append(".").append(methodName).append("]");
                if (TraceConfig.isTraceEnable()) {
                    traceSpan = Tracer.create((String)"RpcRequest", (String)serviceNameBuild.toString(), (boolean)true);
                    traceSpan.addTag(SPAN_SERVICE_TAG_NAME, ConsumerSpanInterceptor.getServiceName(params.getInterfaceName()), true);
                    traceSpan.logEvent("cs");
                    this.spanInjector.inject(traceSpan.getInnerSpan(), params);
                } else if (GovernConfigs.getTopologyEnable() || GovernConfigs.getApicallEnable()) {
                    traceSpan = Tracer.create((String)"RpcRequest", (String)serviceNameBuild.toString(), (boolean)true);
                }
                if (traceSpan != null) {
                    APICallTagInject.setMserviceTag((InnerSpan)traceSpan.getInnerSpan(), (String)ip, (String)"", (String)"feign", (String)serviceName, (String)methodName, (String)appId, (String)"");
                }
            }
            Object object = super.handle(params, feignCall);
            return object;
        }
        finally {
            params.getAttachments().remove("batchInvokeAction");
            if (traceSpan != null) {
                traceSpan.logEvent("cr");
                traceSpan.close();
            }
        }
    }
}

