/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.interceptors.trace;

import kd.bos.context.RequestTimeoutContext;
import kd.bos.govern.timeout.TimeoutHandleFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.common.exception.RpcErrorCode;
import kd.bos.mservice.common.exception.RpcErrorInfo;
import kd.bos.mservice.common.exception.RpcException;
import kd.bos.mservice.common.rpc.param.CommonRpcParam;
import kd.bos.mservice.rpc.interceptor.FeignCall;
import kd.bos.mservice.rpc.interceptor.chain.AbstractLinkedInterceptor;
import kd.bos.mservice.rpc.interceptor.spi.Intercept;
import kd.bos.mservice.sdk.thread.InnerThreadTruck;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.StringUtils;

@Intercept(group="consumer", order=1000)
public class ConsumerTimeoutInterceptor
extends AbstractLinkedInterceptor {
    private static final Log log = LogFactory.getLog(ConsumerTimeoutInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handle(CommonRpcParam params, FeignCall feignCall) throws Throwable {
        try {
            TimeoutHandleFactory.get().handleManuallyTimeout();
            String[] serviceMethodArr = super.getConsumerServiceAndMethodName(params);
            String serviceName = serviceMethodArr[0];
            String methodName = serviceMethodArr[1];
            if ("batchInvokeAction".equals(methodName)) {
                methodName = (String)InnerThreadTruck.get((Object)"batchInvokeAction");
            }
            String fullApiName = serviceName + ":" + methodName;
            String appId = params.getAppId();
            RequestTimeoutContext requestTimeoutContext = RequestTimeoutContext.get();
            if (requestTimeoutContext != null) {
                requestTimeoutContext.setAppId(appId);
                if (requestTimeoutContext.isWebRequest()) {
                    requestTimeoutContext.setRequestOperation(fullApiName);
                }
                if (requestTimeoutContext.isAutomaticTimeout() && !requestTimeoutContext.isTimeoutExceptionThrown()) {
                    this.setWebRequestTimeout(requestTimeoutContext, serviceName, methodName);
                }
                Object object = super.handle(params, feignCall);
                return object;
            }
            RequestTimeoutContext.set((RequestTimeoutContext)new RequestTimeoutContext("RpcRequest", fullApiName, Integer.MAX_VALUE).setAppId(appId));
            try {
                String appServiceMethod;
                if ("cloud.bos.endPointService".equals(serviceName)) {
                    ThreadTruck.put((Object)"customRpcTimeout", (Object)System.getProperty("cloud.bos.endPointService.invoke.timeout", "30000"));
                }
                Object[] arguments = params.getParams();
                String originalServiceName = params.getInterfaceName();
                if (("kd.bos.service.DispatchService".equals(originalServiceName) || "kd.bos.service.InvokeService".equals(originalServiceName)) && null != arguments && arguments.length >= 3) {
                    String appServiceFactory = String.valueOf(arguments[0]);
                    appServiceMethod = appServiceFactory + "." + serviceName + "." + methodName + ".timeout";
                } else {
                    appServiceMethod = serviceName + "." + methodName + ".timeout";
                }
                String customRpcTimeout = System.getProperty(appServiceMethod);
                if (StringUtils.isNotEmpty((String)customRpcTimeout)) {
                    ThreadTruck.put((Object)"customRpcTimeout", (Object)customRpcTimeout);
                } else {
                    this.setRpcConfigTimeout(appId, serviceName, methodName);
                }
            }
            catch (Exception e) {
                log.warn((Throwable)e);
            }
            Object object = super.handle(params, feignCall);
            return object;
        }
        finally {
            ThreadTruck.remove((Object)"customRpcTimeout");
        }
    }

    private void setWebRequestTimeout(RequestTimeoutContext requestTimeoutContext, String serviceName, String methodName) {
        long costTime = System.currentTimeMillis() - requestTimeoutContext.getStartTime();
        long timeout = requestTimeoutContext.getTimeout();
        String fullApiName = serviceName + ":" + methodName;
        if (costTime > timeout) {
            RpcErrorInfo rpcErrorInfo = new RpcErrorInfo();
            rpcErrorInfo.setErrorCode(RpcErrorCode.consumerWebRequestTimeout.getCode());
            rpcErrorInfo.setTimeout(String.valueOf(timeout / 1000L));
            rpcErrorInfo.setCostTime(String.valueOf(costTime / 1000L));
            rpcErrorInfo.setApiName(fullApiName);
            String errorMsg = RpcErrorCode.getMsgByCode((RpcErrorInfo)rpcErrorInfo);
            throw new RpcException.RpcTimeoutException(errorMsg);
        }
        long surplusTimeout = timeout - costTime;
        ThreadTruck.put((Object)"customRpcTimeout", (Object)String.valueOf(surplusTimeout));
    }

    private void setRpcConfigTimeout(String appId, String serviceName, String methodName) {
        StringBuilder apiNameBuild = new StringBuilder();
        String fullApiName = StringUtils.isNotEmpty((String)appId) ? apiNameBuild.append("mservice.rpc.").append(appId).append(".").append(serviceName).append(":").append(methodName).toString() : apiNameBuild.append("mservice.rpc.").append(serviceName).append(":").append(methodName).toString();
        String customRpcTimeout = System.getProperty(fullApiName);
        if (StringUtils.isNotEmpty((String)customRpcTimeout)) {
            ThreadTruck.put((Object)"customRpcTimeout", (Object)customRpcTimeout);
        } else {
            apiNameBuild = new StringBuilder();
            fullApiName = StringUtils.isNotEmpty((String)appId) ? apiNameBuild.append(appId).append(".").append(serviceName).append(":").append(methodName).toString() : apiNameBuild.append(serviceName).append(":").append(methodName).toString();
            customRpcTimeout = System.getProperty(fullApiName);
            if (StringUtils.isNotEmpty((String)customRpcTimeout)) {
                ThreadTruck.put((Object)"customRpcTimeout", (Object)customRpcTimeout);
            }
        }
    }
}

