/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.interceptors.trace;

import java.util.Map;
import kd.bos.mservice.common.rpc.param.CommonRpcParam;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.SpanExtractor;
import kd.bos.util.StringUtils;

public class FeignSpanExtractor
implements SpanExtractor<CommonRpcParam> {
    public InnerSpan joinTrace(CommonRpcParam commonRpcParam) {
        String clientInstanceId;
        String parentId;
        Map attachments = commonRpcParam.getAttachments();
        if (!attachments.containsKey("X-B3-TraceId")) {
            return null;
        }
        boolean sampleSkip = "0".equals(attachments.get("X-B3-Sampled"));
        String traceIdStr = (String)attachments.get("X-B3-TraceId");
        long traceId = InnerSpan.hexToId((String)traceIdStr);
        long spanId = InnerSpan.hexToId((String)((String)attachments.get("X-B3-SpanId")));
        String spanName = (String)attachments.get("X-Span-Name");
        String processId = (String)attachments.get("X-Process-Id");
        String peerService = (String)attachments.get("service");
        String consumerAppName = (String)attachments.get("consumer.appName");
        String consumerIp = (String)attachments.get("consumer.ip");
        InnerSpan.SpanBuilder builder = InnerSpan.builder().traceId(traceId).spanId(spanId);
        if (StringUtils.isNotEmpty((String)processId)) {
            builder.processId(processId);
        }
        if (StringUtils.isNotEmpty((String)spanName)) {
            builder.name(spanName);
        }
        if (StringUtils.isNotEmpty((String)peerService)) {
            builder.tag("service", peerService);
        }
        if (StringUtils.isNotEmpty((String)consumerAppName)) {
            builder.tag("consumer.appName", consumerAppName);
        }
        if (StringUtils.isNotEmpty((String)consumerIp)) {
            builder.tag("consumer.ip", consumerIp);
        }
        if ((parentId = (String)attachments.get("X-B3-ParentSpanId")) != null) {
            builder.parent(InnerSpan.hexToId((String)parentId));
        }
        if (StringUtils.isNotEmpty((String)(clientInstanceId = (String)attachments.get("clientInstanceId")))) {
            builder.instanceId(clientInstanceId);
        }
        if (sampleSkip) {
            builder.exportable(false);
        }
        return builder.build();
    }
}

