/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.interceptors.trace;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.context.RequestContext;
import kd.bos.mservice.common.rpc.param.CommonRpcParam;
import kd.bos.mservice.rpc.interceptor.FeignCall;
import kd.bos.mservice.rpc.interceptor.chain.AbstractLinkedInterceptor;
import kd.bos.mservice.rpc.interceptor.spi.Intercept;
import kd.bos.slowlog.SlowLogger;
import kd.bos.trace.tracer.SlowConfig;
import kd.bos.trace.tracer.TraceStatistics;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.MaskUtil;
import kd.bos.util.StringUtils;

@Intercept(group="provider", order=9000)
public class ProviderSlowLogInterceptor
extends AbstractLinkedInterceptor {
    private static final String KEY_LOGPARAMS_ENABLE = "SlowLogger.rpc.params.enable";
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handle(CommonRpcParam params, FeignCall feignCall) throws Throwable {
        int invokerCostTime = 0;
        try {
            long startInvokeTime = System.currentTimeMillis();
            Object object = super.handle(params, feignCall);
            invokerCostTime = (int)(System.currentTimeMillis() - startInvokeTime);
            Object object2 = object;
            return object2;
        }
        finally {
            this.staticSlowLog(invokerCostTime, params);
        }
    }

    private void staticSlowLog(int cost, CommonRpcParam commonRpcParam) {
        boolean force;
        boolean bl = force = cost > SlowConfig.getSlowTime((String)"rpcRequest");
        if (force) {
            String statics;
            String params;
            String msg = "SlowLogger-RPC: cost " + cost + "ms,time is:" + dateTimeFormatter.format(LocalDateTime.now()) + ",traceId is:" + this.getTraceId();
            msg = msg + "\r\n the invoker is:\r\n    " + this.getClientUrl(commonRpcParam);
            if (ConfigurationUtil.getBoolean((String)"SlowLogger.params.mask.enable", (Boolean)true).booleanValue()) {
                try {
                    params = this.getMaskParamStr(commonRpcParam.getParams());
                }
                catch (Exception e) {
                    params = this.getParamStr(commonRpcParam.getParams());
                }
            } else {
                params = this.getParamStr(commonRpcParam.getParams());
            }
            if (params != null && this.isSlowLoggerParamsEnable()) {
                msg = msg + "\r\n the invokeParam is:\r\n    " + params;
            }
            if (StringUtils.isNotEmpty((String)(statics = TraceStatistics.getThreadTraceStatistic((Thread)Thread.currentThread())))) {
                msg = msg + "\r\n the statics is:\r\n" + statics.replaceAll("&nbsp;", " ").replaceAll("<br>", "\n");
            }
            SlowLogger.log((String)msg, (Object[])new Object[]{"SlowLogger", cost});
            SlowLogger.count((String)"RPC");
        }
    }

    private String getParamStr(Object[] arguments) {
        if (arguments != null) {
            StringBuilder paramStr = new StringBuilder("(");
            for (int i = 0; i < arguments.length; ++i) {
                if (!(arguments[i] instanceof Object[])) {
                    paramStr.append(arguments[i]);
                }
                paramStr.append(",");
            }
            paramStr.append(")");
            return paramStr.toString();
        }
        return null;
    }

    private String getMaskParamStr(Object[] arguments) {
        int reserveLength = ConfigurationUtil.getInteger((String)"SlowLogger.params.mask.reserve", (Integer)2);
        if (arguments != null) {
            StringBuilder paramStr = new StringBuilder("(");
            for (int i = 0; i < arguments.length; ++i) {
                if (!(arguments[i] instanceof Object[])) {
                    String masked = MaskUtil.maskJsonString((String)String.valueOf(arguments[i]), (int)reserveLength);
                    paramStr.append(masked);
                }
                paramStr.append(",");
            }
            paramStr.append(")");
            return paramStr.toString();
        }
        return null;
    }

    private String getTraceId() {
        return RequestContext.get().getTraceId();
    }

    private String getClientUrl(CommonRpcParam commonRpcParam) {
        String clientUrl = RequestContext.get().getClientUrl();
        if (StringUtils.isEmpty((String)clientUrl)) {
            String[] serviceMethodArr = super.getProviderServiceAndMethodName(commonRpcParam);
            String serviceName = serviceMethodArr[0];
            String methodName = serviceMethodArr[1];
            clientUrl = serviceName + ":" + methodName;
        }
        return clientUrl;
    }

    private boolean isSlowLoggerParamsEnable() {
        String str = System.getProperty(KEY_LOGPARAMS_ENABLE);
        if (str != null) {
            return "true".equalsIgnoreCase(str);
        }
        return true;
    }
}

