/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.codec;

import feign.FeignException;
import feign.Response;
import feign.codec.Decoder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import kd.bos.mservice.common.exception.RpcException;
import kd.bos.mservice.rpc.serialization.HttpHeadUtils;
import kd.bos.mservice.serialization.KServiceSerializationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KDDecoder
implements Decoder {
    private static final Logger logger = LoggerFactory.getLogger(KDDecoder.class);
    private final Decoder decoder;

    public KDDecoder(Decoder decoder) {
        this.decoder = decoder;
    }

    public Object decode(Response response, Type type) throws IOException, FeignException {
        String codec = HttpHeadUtils.getHeaderFromMap(response.headers(), "codecType");
        String isFeignCommonRpc = HttpHeadUtils.getHeaderFromMap(response.headers(), "isFeignCommonRpc");
        int status = response.status();
        if (status == 200) {
            if (response.body() == null) {
                String msg = "feign response`s body is null";
                logger.error(msg);
                throw new RpcException(msg);
            }
            InputStream inputstream = response.body().asInputStream();
            Object returnObj = null;
            if (String.class == type) {
                returnObj = this.decoder.decode(response, type);
            } else if (codec != null) {
                returnObj = Boolean.TRUE.toString().equals(isFeignCommonRpc) ? KServiceSerializationFactory.getDefaultBinarySerializer().deserialize(inputstream, null) : (type instanceof ParameterizedType ? KServiceSerializationFactory.getSerializer((String)codec).deserializeWithParameterizedType(inputstream, (ParameterizedType)type) : KServiceSerializationFactory.getSerializer((String)codec).deserialize(inputstream, (Class)type));
            } else {
                Collection collection = (Collection)response.headers().get("content-type");
                if (collection != null) {
                    String contentType = (String)collection.iterator().next();
                    returnObj = contentType.contains("application/xx-kd-serialization") ? KServiceSerializationFactory.getDefaultBinarySerializer().deserialize(inputstream, null) : this.decoder.decode(response, type);
                }
            }
            return returnObj;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("feign response error,statuscode ").append(status).append(",reason:").append(response);
        logger.error(sb.toString());
        throw new RpcException(sb.toString());
    }
}

