/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.codec;

import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import kd.bos.mservice.common.exception.RpcException;
import kd.bos.mservice.common.limit.KServiceLimitUtil;
import kd.bos.mservice.common.rpc.param.CommonRpcParam;
import kd.bos.mservice.sdk.util.SdkStringUtils;
import kd.bos.mservice.serialization.KServiceSerialization;
import kd.bos.mservice.serialization.KServiceSerializationFactory;

public class KDEncoder
implements Encoder {
    private final Encoder encoder;

    public KDEncoder(Encoder encoder) {
        this.encoder = encoder;
    }

    public void encode(Object param, Type type, RequestTemplate requestTemplate) throws EncodeException {
        ByteArrayOutputStream bytesOutput = new ByteArrayOutputStream();
        try {
            String codecType = null;
            if (param instanceof CommonRpcParam) {
                KServiceSerializationFactory.getDefaultBinarySerializer().serialize(param, (OutputStream)bytesOutput);
                byte[] bodys = bytesOutput.toByteArray();
                this.checkIsOverLimit(bodys);
                requestTemplate.body(bodys, null);
            } else if (SdkStringUtils.isNotEmpty(codecType)) {
                KServiceSerialization serializer = KServiceSerializationFactory.getSerializer(codecType);
                serializer.serialize(param, (OutputStream)bytesOutput);
                byte[] bodys = bytesOutput.toByteArray();
                this.checkIsOverLimit(bodys);
                requestTemplate.body(bodys, null);
            } else {
                this.encoder.encode(param, type, requestTemplate);
            }
        }
        catch (Exception e) {
            throw new RpcException("KDEncoder error" + e.getMessage(), (Throwable)e);
        }
    }

    private void checkIsOverLimit(byte[] bodys) {
        int objectSize = bodys.length;
        if (KServiceLimitUtil.overLimit((long)objectSize)) {
            throw new RpcException("The requested data is too large and has exceeded the maximum threshold: " + objectSize + "> " + KServiceLimitUtil.getLimitSize());
        }
    }
}

