/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.handler;

import feign.InvocationHandlerFactory;
import feign.Target;
import feign.Util;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import kd.bos.mservice.common.rpc.RegisterAppNameUtils;
import kd.bos.mservice.common.rpc.param.CommonRpcParam;
import kd.bos.mservice.context.BaseContext;
import kd.bos.mservice.context.KdExternalContext;
import kd.bos.mservice.rpc.interceptor.InterceptorChainProvider;
import kd.bos.mservice.sdk.instance.KdInstance;
import kd.bos.mservice.sdk.thread.InnerThreadTruck;
import kd.bos.mservice.sdk.util.SdkStringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class KdFeignInvocationHandler
implements InvocationHandler {
    private static String FEIGN_DISPATCH_SERVICE_INTERFACE = "kd.bos.mservice.rpc.feign.FeignDispatchService";
    private final Target target;
    private final Map<Method, InvocationHandlerFactory.MethodHandler> dispatch;

    KdFeignInvocationHandler(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        this.target = (Target)Util.checkNotNull((Object)target, (String)"target", (Object[])new Object[0]);
        this.dispatch = (Map)Util.checkNotNull(dispatch, (String)"dispatch for %s", (Object[])new Object[]{target});
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object[] finalArgs;
        if ("equals".equals(method.getName())) {
            try {
                InvocationHandler otherHandler = args.length > 0 && args[0] != null ? Proxy.getInvocationHandler(args[0]) : null;
                return this.equals(otherHandler);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        if ("hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        if ("toString".equals(method.getName())) {
            return this.toString();
        }
        CommonRpcParam commonRpcParam = this.createCommonRpcParam(method, args);
        if (this.isDispatchServiceRequest(method)) {
            commonRpcParam.getAttachments().put("rpcType", "openFeign");
            commonRpcParam.getAttachments().put("rpcRequestMethod", HttpMethod.POST.name());
            finalArgs = args;
        } else if (this.isGetRequest(method)) {
            commonRpcParam.getAttachments().put("rpcType", "openFeign");
            commonRpcParam.getAttachments().put("rpcRequestMethod", HttpMethod.GET.name());
            finalArgs = args;
        } else {
            commonRpcParam.getAttachments().put("rpcType", "openFeign");
            commonRpcParam.getAttachments().put("rpcRequestMethod", HttpMethod.POST.name());
            finalArgs = new Object[]{commonRpcParam};
        }
        return InterceptorChainProvider.getConsumerChain().handle(commonRpcParam, () -> this.dispatch.get(method).invoke(finalArgs));
    }

    private boolean isDispatchServiceRequest(Method method) {
        return FEIGN_DISPATCH_SERVICE_INTERFACE.equals(method.getDeclaringClass().getName());
    }

    private boolean isGetRequest(Method method) {
        RequestMethod[] methods;
        if (method.getAnnotation(PostMapping.class) != null) {
            return false;
        }
        if (method.getAnnotation(GetMapping.class) != null) {
            return true;
        }
        RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
        if (requestMapping != null && (methods = requestMapping.method()).length > 0) {
            RequestMethod firstMethod = methods[0];
            if (RequestMethod.GET.equals((Object)firstMethod)) {
                return true;
            }
            if (RequestMethod.POST.equals((Object)firstMethod)) {
                return false;
            }
        }
        return false;
    }

    private CommonRpcParam createCommonRpcParam(Method method, Object[] args) {
        CommonRpcParam commonRpcParam;
        if (this.isDispatchServiceRequest(method)) {
            commonRpcParam = (CommonRpcParam)args[1];
        } else {
            CommonRpcParam param = new CommonRpcParam();
            param.setAppId(this.getAppId());
            param.setParamsType((Class[])method.getParameterTypes());
            param.setParams(args);
            param.setInterfaceName(method.getDeclaringClass().getSimpleName());
            param.setMethodName(method.getName());
            commonRpcParam = param;
            if (KdExternalContext.get() == null) {
                KdExternalContext.create(null, null, null);
            }
            commonRpcParam.setBaseContext((BaseContext)KdExternalContext.get());
        }
        InnerThreadTruck.put((Object)"commonRpcParam", (Object)commonRpcParam);
        return commonRpcParam;
    }

    private String getAppId() {
        if (RegisterAppNameUtils.isRegisterWithAppName()) {
            String appId = this.target.name();
            RegisterAppNameUtils.setRequestAppID((String)appId);
            return appId;
        }
        if (!KdInstance.isAppSplit()) {
            return null;
        }
        String appId = RegisterAppNameUtils.getRequestAppID();
        if (SdkStringUtils.isEmpty((String)appId)) {
            appId = this.target.name();
            RegisterAppNameUtils.setRequestAppID((String)appId);
        }
        return appId.toLowerCase();
    }

    public boolean equals(Object obj) {
        if (obj instanceof KdFeignInvocationHandler) {
            KdFeignInvocationHandler other = (KdFeignInvocationHandler)obj;
            return this.target.equals(other.target);
        }
        return false;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public String toString() {
        return this.target.toString();
    }
}

