/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.handshake.entity;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.mservice.rpc.handshake.entity.HandShakeFailedStatus;

public class RpcStatus {
    private static final ConcurrentMap<String, RpcStatus> SERVICE_STATISTICS = new ConcurrentHashMap<String, RpcStatus>();
    private static final Map<String, HandShakeFailedStatus> INSTANCE_HANDSHAKESTATUS = new ConcurrentHashMap<String, HandShakeFailedStatus>();
    private String uri;
    private final AtomicInteger active = new AtomicInteger();
    private final AtomicLong total = new AtomicLong();
    private final AtomicInteger failed = new AtomicInteger();
    private final AtomicLong totalElapsed = new AtomicLong();
    private final AtomicLong failedElapsed = new AtomicLong();
    private final AtomicLong maxElapsed = new AtomicLong();
    private final AtomicLong failedMaxElapsed = new AtomicLong();
    private final AtomicLong succeededMaxElapsed = new AtomicLong();
    private final HandShakeFailedStatus handStatus;

    public RpcStatus(String uri) {
        this.uri = uri;
        this.handStatus = INSTANCE_HANDSHAKESTATUS.computeIfAbsent(uri, k -> new HandShakeFailedStatus());
    }

    public static RpcStatus getStatus(String uri) {
        RpcStatus status = (RpcStatus)SERVICE_STATISTICS.get(uri);
        if (status == null) {
            SERVICE_STATISTICS.putIfAbsent(uri, new RpcStatus(uri));
            status = (RpcStatus)SERVICE_STATISTICS.get(uri);
        }
        return status;
    }

    public void busyHandShake() {
        this.handStatus.busyHandShake();
    }

    public static void removeStatus(String uri) {
        SERVICE_STATISTICS.remove(uri);
    }

    public static void beginCount(String url) {
        RpcStatus.beginCount(RpcStatus.getStatus(url));
    }

    private static void beginCount(RpcStatus status) {
        status.active.incrementAndGet();
    }

    public static void endCount(String url, long elapsed, boolean succeeded) {
        RpcStatus.endCount(RpcStatus.getStatus(url), elapsed, succeeded);
    }

    private static void endCount(RpcStatus status, long elapsed, boolean succeeded) {
        status.active.decrementAndGet();
        status.total.incrementAndGet();
        status.totalElapsed.addAndGet(elapsed);
        if (status.maxElapsed.get() < elapsed) {
            status.maxElapsed.set(elapsed);
        }
        if (succeeded) {
            if (status.succeededMaxElapsed.get() < elapsed) {
                status.succeededMaxElapsed.set(elapsed);
            }
        } else {
            status.failed.incrementAndGet();
            status.failedElapsed.addAndGet(elapsed);
            if (status.failedMaxElapsed.get() < elapsed) {
                status.failedMaxElapsed.set(elapsed);
            }
        }
    }

    public int getActive() {
        return this.active.get();
    }

    public long getTotal() {
        return this.total.longValue();
    }

    public long getTotalElapsed() {
        return this.totalElapsed.get();
    }

    public long getAverageElapsed() {
        long total = this.getTotal();
        if (total == 0L) {
            return 0L;
        }
        return this.getTotalElapsed() / total;
    }

    public long getMaxElapsed() {
        return this.maxElapsed.get();
    }

    public int getFailed() {
        return this.failed.get();
    }

    public long getFailedElapsed() {
        return this.failedElapsed.get();
    }

    public long getFailedAverageElapsed() {
        long failed = this.getFailed();
        if (failed == 0L) {
            return 0L;
        }
        return this.getFailedElapsed() / failed;
    }

    public long getFailedMaxElapsed() {
        return this.failedMaxElapsed.get();
    }

    public long getSucceeded() {
        return this.getTotal() - (long)this.getFailed();
    }

    public long getSucceededElapsed() {
        return this.getTotalElapsed() - this.getFailedElapsed();
    }

    public long getSucceededAverageElapsed() {
        long succeeded = this.getSucceeded();
        if (succeeded == 0L) {
            return 0L;
        }
        return this.getSucceededElapsed() / succeeded;
    }

    public long getSucceededMaxElapsed() {
        return this.succeededMaxElapsed.get();
    }

    public long getAverageTps() {
        if (this.getTotalElapsed() >= 1000L) {
            return this.getTotal() / (this.getTotalElapsed() / 1000L);
        }
        return this.getTotal();
    }

    public String getUri() {
        return this.uri;
    }

    public void sucessHandShake() {
        this.handStatus.sucessHandShake();
    }

    public void failedHandShake() {
        this.handStatus.failedHandShake();
    }

    public boolean isHandShakeBusy() {
        return this.handStatus.isBusyHandShake();
    }

    public boolean isHandShakeBreaked() {
        return this.handStatus.isHandShakeBreaked();
    }
}

