/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.rest;

import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.mservice.common.exception.RpcException;
import kd.bos.mservice.common.rpc.RegisterAppNameUtils;
import kd.bos.mservice.common.rpc.param.CommonRpcParam;
import kd.bos.mservice.context.BaseContext;
import kd.bos.mservice.rpc.interceptor.InterceptorChainProvider;
import kd.bos.mservice.rpc.rest.manager.BosRestTemplateManager;
import kd.bos.mservice.sdk.instance.KdInstance;
import kd.bos.mservice.sdk.util.SdkStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class BosRestTemplate
extends RestTemplate {
    private static final Logger log = LoggerFactory.getLogger(BosRestTemplate.class);
    private static final Pattern URI_PATTERN = Pattern.compile("^(([^:/?#]+):)?(//(([^@\\[/?#]*)@)?(\\[[\\p{XDigit}:.]*[%\\p{Alnum}]*]|[^\\[/?#:]*)(:(\\d*(?:\\{[^/]+?\\})?))?)?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private static final String interfaceName = "kd.bos.service.InvokeService";
    private static final String contextPath = System.getProperty("feign.client.context.path");
    private static final String KD_CONVERTER_SERVICE_GET = contextPath + "/" + "kdconverterserviceGet";
    private static final String KD_CONVERTER_SERVICE_POST = contextPath + "/" + "kdconverterservicePost";
    private static final String KD_CONVERTER_SERVICE_POST_STRING = contextPath + "/" + "kdconverterservicePostForString";
    private static final String KD_CONVERTER_SERVICE_REQUEST = contextPath + "/" + "kdConverterServiceRequest";

    public BosRestTemplate() {
    }

    public BosRestTemplate(ClientHttpRequestFactory requestFactory) {
        super(requestFactory);
    }

    @Nullable
    protected <T> T doExecute(URI url, @Nullable HttpMethod method, @Nullable RequestCallback requestCallback, @Nullable ResponseExtractor<T> responseExtractor) throws RestClientException {
        try {
            if (!BosRestTemplateManager.getKdConverterFlag()) {
                Object object = super.doExecute(url, method, requestCallback, responseExtractor);
                return (T)object;
            }
            CommonRpcParam commonRpcParam = this.createCommonRpcParam();
            Object obj = BosRestTemplateManager.get("currentResponseType");
            requestCallback = obj != null ? super.httpEntityCallback(this.rebuildHttpEntity(url, method, commonRpcParam), (Type)obj) : super.httpEntityCallback(this.rebuildHttpEntity(url, method, commonRpcParam));
            URI expanded = this.convertUrl(commonRpcParam, url);
            RequestCallback finalRequestCallback = requestCallback;
            Object object = InterceptorChainProvider.getConsumerChain().handle(commonRpcParam, () -> super.doExecute(expanded, HttpMethod.POST, finalRequestCallback, responseExtractor));
            return (T)object;
        }
        catch (Throwable e) {
            throw new RpcException("BosRestTemplate URISyntaxException,Url:" + url + ",errMessage:" + e.getMessage(), e);
        }
        finally {
            BosRestTemplateManager.remove("currentRequestBody");
            BosRestTemplateManager.remove("currentResponseType");
        }
    }

    public <T> RequestCallback httpEntityCallback(@Nullable Object requestBody) {
        return super.httpEntityCallback(this.putCurrentRequestBody(requestBody, null));
    }

    public <T> RequestCallback httpEntityCallback(@Nullable Object requestBody, Type responseType) {
        return super.httpEntityCallback(this.putCurrentRequestBody(requestBody, responseType), responseType);
    }

    private CommonRpcParam createCommonRpcParam() {
        CommonRpcParam param = new CommonRpcParam();
        param.setInterfaceName("restTemplate");
        param.setBaseContext(BaseContext.get());
        return param;
    }

    private Object rebuildHttpEntity(URI url, @Nullable HttpMethod method, CommonRpcParam commonRpcParam) {
        HttpEntity httpEntity = (HttpEntity)BosRestTemplateManager.get("currentRequestBody");
        HttpHeaders requestHeaders = httpEntity.getHeaders();
        HttpHeaders headers = new HttpHeaders();
        if (!requestHeaders.isEmpty()) {
            requestHeaders.forEach((key, values) -> headers.put(key, new ArrayList(values)));
            String codeType = this.getCodeType(requestHeaders);
            if (codeType != null) {
                BosRestTemplateManager.setCodeType(codeType);
            } else {
                headers.add("codecType", "javaobj");
                BosRestTemplateManager.setCodeType("javaobj");
            }
        }
        if (HttpMethod.GET.equals((Object)method)) {
            String query = url.getQuery();
            if (SdkStringUtils.isNotEmpty((String)query)) {
                commonRpcParam.setParams(new Object[]{query});
                commonRpcParam.getAttachments().put("rpcType", "restTemplate");
                commonRpcParam.getAttachments().put("rpcRequestMethod", HttpMethod.GET.name());
            }
        } else {
            commonRpcParam.getAttachments().put("rpcType", "restTemplate");
            commonRpcParam.getAttachments().put("rpcRequestMethod", HttpMethod.POST.name());
            commonRpcParam.setParams(new Object[]{httpEntity.getBody()});
        }
        headers.setContentType(new MediaType("application", "xx-rest-converter", StandardCharsets.UTF_8));
        return new HttpEntity((Object)commonRpcParam, (MultiValueMap)headers);
    }

    private Object putCurrentRequestBody(Object requestBody, Type responseType) {
        if (requestBody instanceof HttpEntity) {
            HttpEntity requestEntity = (HttpEntity)requestBody;
            HttpHeaders requestHeaders = requestEntity.getHeaders();
            if (BosRestTemplateManager.getKdConverterFlag() || "true".equals(this.getHeadValue(requestHeaders, "kdConvertEnable"))) {
                BosRestTemplateManager.setKdConverterFlag(true);
                BosRestTemplateManager.put("currentRequestBody", requestBody);
                if (responseType != null) {
                    BosRestTemplateManager.put("currentResponseType", responseType);
                }
            }
        }
        return requestBody;
    }

    private URI convertUrl(CommonRpcParam commonRpcParam, URI uri) throws URISyntaxException {
        if (!BosRestTemplateManager.getKdConverterFlag()) {
            return uri;
        }
        String url = uri.toString();
        Assert.notNull((Object)uri, (String)"URI must not be null");
        Matcher matcher = URI_PATTERN.matcher(url);
        if (matcher.matches()) {
            int port;
            String scheme = matcher.group(2);
            String userInfo = matcher.group(5);
            String host = matcher.group(6);
            String portStr = matcher.group(8);
            String path = matcher.group(9);
            String query = matcher.group(11);
            String fragment = matcher.group(13);
            String originalUri = path.startsWith(contextPath + "/") ? path.substring(contextPath.length()) : (path.startsWith("/mservice/") ? path.substring("/mservice".length()) : path);
            commonRpcParam.setMethodName(originalUri);
            BosRestTemplateManager.setOriginalUri(originalUri);
            path = KD_CONVERTER_SERVICE_REQUEST;
            query = "";
            int n = port = SdkStringUtils.isNotEmpty((String)portStr) ? Integer.parseInt(portStr) : -1;
            if (port == -1) {
                if (KdInstance.isAppSplit()) {
                    BosRestTemplateManager.put("appId", host);
                    commonRpcParam.setAppId(host);
                    host = RegisterAppNameUtils.getLookupAppName((String)host, (String)interfaceName);
                } else {
                    host = RegisterAppNameUtils.getRegisterInterfaceName((String)interfaceName);
                }
            }
            return new URI(scheme, userInfo, host, port, path, query, fragment);
        }
        throw new IllegalArgumentException("[" + uri + "] is not a valid URI");
    }

    private String getHeadValue(HttpHeaders headers, String key) {
        List collections = headers.get((Object)key);
        if (collections == null || collections.isEmpty()) {
            return "";
        }
        return (String)collections.iterator().next();
    }

    private String getCodeType(HttpHeaders headers) {
        List collections = headers.get((Object)"codecType");
        if (collections == null || collections.isEmpty()) {
            return null;
        }
        for (String type : collections) {
            if ("javaobj".equals(type)) {
                return "javaobj";
            }
            if (!"json".equals(type)) continue;
            return "json";
        }
        return null;
    }
}

