/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.rest.config;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import kd.bos.mservice.rpc.rest.BosRestTemplate;
import kd.bos.mservice.rpc.rest.codec.BosRestMessageConverter;
import kd.bos.mservice.rpc.rest.handler.RestResponseErrorHandler;
import kd.bos.mservice.rpc.rest.interceptor.RestRequestInterceptor;
import kd.bos.mservice.rpc.serialization.KdSerializationConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateConfiguration {
    @Autowired
    private RestRequestInterceptor restRequestInterceptor;
    @Autowired
    private KdSerializationConverter kdSerializationConverter;
    @Autowired
    private BosRestMessageConverter bosRestMessageConverter;
    @Autowired
    private Environment env;
    private static int restReadTimeout;

    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"mservice.rest.converter.enable"}, havingValue="true", matchIfMissing=true)
    @Bean
    @LoadBalanced
    RestTemplate createBosRestTemplate() {
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        clientHttpRequestFactory.setReadTimeout(this.getReadTimeout().intValue());
        clientHttpRequestFactory.setConnectTimeout(this.getConnectTimeout().intValue());
        BosRestTemplate restTemplate = new BosRestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
        ArrayList<RestRequestInterceptor> interceptorList = new ArrayList<RestRequestInterceptor>(1);
        interceptorList.add(this.restRequestInterceptor);
        restTemplate.setInterceptors(interceptorList);
        restTemplate.setErrorHandler(new RestResponseErrorHandler());
        List defaultMessageConverters = restTemplate.getMessageConverters();
        defaultMessageConverters.stream().filter(converter -> converter instanceof StringHttpMessageConverter).forEach(converter -> ((StringHttpMessageConverter)converter).setDefaultCharset(StandardCharsets.UTF_8));
        defaultMessageConverters.add(this.kdSerializationConverter);
        defaultMessageConverters.add(this.bosRestMessageConverter);
        return restTemplate;
    }

    private Integer getReadTimeout() {
        Integer readTimeout = Integer.getInteger("mservice.consumer.readTimeout");
        String readTimeoutStr = this.env.getProperty("mservice.consumer.readTimeout");
        if (readTimeout == null && readTimeoutStr != null && !"".equals(readTimeoutStr)) {
            readTimeout = Integer.valueOf(readTimeoutStr);
        }
        restReadTimeout = readTimeout != null ? readTimeout : 580000;
        return restReadTimeout;
    }

    public static int getRestReadTimeout() {
        return restReadTimeout;
    }

    private Integer getConnectTimeout() {
        Integer connectTimeout = Integer.getInteger("mservice.consumer.connectTimeout");
        String connectTimeoutStr = this.env.getProperty("mservice.consumer.connectTimeout");
        if (connectTimeout == null && connectTimeoutStr != null && !"".equals(connectTimeoutStr)) {
            connectTimeout = Integer.valueOf(connectTimeoutStr);
        }
        return connectTimeout != null ? connectTimeout : 5000;
    }
}

