/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.rest.interceptor;

import java.io.IOException;
import kd.bos.mservice.common.ServiceEnv;
import kd.bos.mservice.common.exception.RpcErrorCode;
import kd.bos.mservice.common.exception.RpcErrorInfo;
import kd.bos.mservice.common.exception.RpcException;
import kd.bos.mservice.rpc.exception.ExceptionStandardHandler;
import kd.bos.mservice.rpc.rest.config.RestTemplateConfiguration;
import kd.bos.mservice.rpc.rest.manager.BosRestTemplateManager;
import kd.bos.mservice.rpc.serialization.HttpHeadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

@Configuration
public class RestRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RestRequestInterceptor.class);

    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] bytes, ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        HttpHeaders headers = httpRequest.getHeaders();
        if (ServiceEnv.isTianShuService()) {
            HttpHeadUtils.setHeaderIfEmpty(headers, "isTianshu", Boolean.TRUE.toString());
        }
        if (BosRestTemplateManager.getKdConverterFlag()) {
            HttpHeadUtils.setHeaderIfEmpty(headers, "originalUri", BosRestTemplateManager.getOriginalUri());
        }
        String appName = httpRequest.getURI().getHost();
        try {
            ClientHttpResponse clientHttpResponse = clientHttpRequestExecution.execute(httpRequest, bytes);
            return clientHttpResponse;
        }
        catch (Throwable e) {
            if (BosRestTemplateManager.getKdConverterFlag()) {
                this.handleException(e);
                log.error("RestTemplate execute exception ,Server:" + appName + ",errMessage:" + e.getMessage(), e);
                throw new RpcException("RestTemplate execute exception ,Server:" + appName + ",errMessage:" + e.getMessage(), e);
            }
            throw e;
        }
        finally {
            BosRestTemplateManager.remove("appId");
            BosRestTemplateManager.removeKdConverterFlag();
            BosRestTemplateManager.removeOriginalUri();
        }
    }

    private void handleException(Throwable e) {
        if (e instanceof RpcException.RpcServiceUnavailableException) {
            RpcErrorInfo rpcErrorInfo = new RpcErrorInfo();
            rpcErrorInfo.setErrorCode(RpcErrorCode.consumerInvokerNotFound.getCode());
            rpcErrorInfo.setAppId((String)BosRestTemplateManager.get("appId"));
            rpcErrorInfo.setApiName(BosRestTemplateManager.getOriginalUri());
            String errorMessage = ExceptionStandardHandler.getRestTemplateStandardErrorMessage(rpcErrorInfo);
            log.error(errorMessage, e);
            throw new RpcException.RpcServiceUnavailableException(errorMessage);
        }
        if (e instanceof RpcException.RpcTimeoutException) {
            RpcErrorInfo rpcErrorInfo = new RpcErrorInfo();
            RpcException.RpcTimeoutException rpcTimeoutException = (RpcException.RpcTimeoutException)e;
            rpcErrorInfo.setErrorCode(rpcTimeoutException.getErrorCode());
            rpcErrorInfo.setTimeout(String.valueOf(RestTemplateConfiguration.getRestReadTimeout() / 1000));
            rpcErrorInfo.setRemoteIp(rpcTimeoutException.getRemoteIp());
            rpcErrorInfo.setAppId((String)BosRestTemplateManager.get("appId"));
            rpcErrorInfo.setApiName(BosRestTemplateManager.getOriginalUri());
            String errorMessage = ExceptionStandardHandler.getRestTemplateStandardErrorMessage(rpcErrorInfo);
            log.error(errorMessage, e);
            throw new RpcException.RpcTimeoutException(errorMessage);
        }
    }
}

