/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.PackagingDataCalculator;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.util.OptionHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

public class ThrowableProxy
implements IThrowableProxy {
    static final StackTraceElementProxy[] EMPTY_STEP = new StackTraceElementProxy[0];
    private Throwable throwable;
    private String className;
    private String message;
    StackTraceElementProxy[] stackTraceElementProxyArray;
    int commonFrames;
    private ThrowableProxy cause;
    private static final ThrowableProxy[] NO_SUPPRESSED = new ThrowableProxy[0];
    private ThrowableProxy[] suppressed = NO_SUPPRESSED;
    private transient PackagingDataCalculator packagingDataCalculator;
    private boolean calculatedPackageData = false;
    private boolean circular;
    private static final Method GET_SUPPRESSED_METHOD;

    public ThrowableProxy(Throwable throwable) {
        this(throwable, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private ThrowableProxy(Throwable circular, boolean isCircular) {
        this.throwable = circular;
        this.className = circular.getClass().getName();
        this.message = this.subStr(circular.getMessage());
        this.stackTraceElementProxyArray = EMPTY_STEP;
        this.circular = true;
    }

    public ThrowableProxy(Throwable throwable, Set<Throwable> alreadyProcessedSet) {
        Object[] throwableSuppressed;
        this.throwable = throwable;
        this.className = throwable.getClass().getName();
        this.message = this.subStr(throwable.getMessage());
        this.stackTraceElementProxyArray = ThrowableProxyUtil.steArrayToStepArray((StackTraceElement[])throwable.getStackTrace());
        this.circular = false;
        alreadyProcessedSet.add(throwable);
        Throwable nested = throwable.getCause();
        if (nested != null) {
            if (alreadyProcessedSet.contains(nested)) {
                this.cause = new ThrowableProxy(nested, true);
            } else {
                this.cause = new ThrowableProxy(nested, alreadyProcessedSet);
                this.cause.commonFrames = ThrowableProxyUtil.findNumberOfCommonFrames((StackTraceElement[])nested.getStackTrace(), (StackTraceElementProxy[])this.stackTraceElementProxyArray);
            }
        }
        if (GET_SUPPRESSED_METHOD != null && OptionHelper.isNotEmtpy((Object[])(throwableSuppressed = this.extractSupressedThrowables(throwable)))) {
            ArrayList<ThrowableProxy> suppressedList = new ArrayList<ThrowableProxy>(throwableSuppressed.length);
            for (Object sup : throwableSuppressed) {
                ThrowableProxy throwableProxy;
                if (alreadyProcessedSet.contains(sup)) {
                    throwableProxy = new ThrowableProxy((Throwable)sup, true);
                    suppressedList.add(throwableProxy);
                    continue;
                }
                throwableProxy = new ThrowableProxy((Throwable)sup, alreadyProcessedSet);
                throwableProxy.commonFrames = ThrowableProxyUtil.findNumberOfCommonFrames((StackTraceElement[])((Throwable)sup).getStackTrace(), (StackTraceElementProxy[])this.stackTraceElementProxyArray);
                suppressedList.add(throwableProxy);
            }
            this.suppressed = suppressedList.toArray(new ThrowableProxy[suppressedList.size()]);
        }
    }

    private String subStr(String msg) {
        int maxlength = Integer.getInteger("log.maxlength", 10240);
        if (msg != null && msg.length() > maxlength) {
            msg = msg.substring(0, maxlength) + ".......";
        }
        return msg;
    }

    private Throwable[] extractSupressedThrowables(Throwable t) {
        try {
            Object obj = GET_SUPPRESSED_METHOD.invoke((Object)t, new Object[0]);
            if (obj instanceof Throwable[]) {
                Throwable[] throwableSuppressed = (Throwable[])obj;
                return throwableSuppressed;
            }
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getMessage() {
        return this.message;
    }

    public String getClassName() {
        return this.className;
    }

    public StackTraceElementProxy[] getStackTraceElementProxyArray() {
        return this.stackTraceElementProxyArray;
    }

    public boolean isCyclic() {
        return this.circular;
    }

    public int getCommonFrames() {
        return this.commonFrames;
    }

    public IThrowableProxy getCause() {
        return this.cause;
    }

    public IThrowableProxy[] getSuppressed() {
        return this.suppressed;
    }

    public PackagingDataCalculator getPackagingDataCalculator() {
        if (this.throwable != null && this.packagingDataCalculator == null) {
            this.packagingDataCalculator = new PackagingDataCalculator();
        }
        return this.packagingDataCalculator;
    }

    public void calculatePackagingData() {
        if (this.calculatedPackageData) {
            return;
        }
        PackagingDataCalculator pdc = this.getPackagingDataCalculator();
        if (pdc != null) {
            this.calculatedPackageData = true;
            pdc.calculate((IThrowableProxy)this);
        }
    }

    public void fullDump() {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElementProxy step : this.stackTraceElementProxyArray) {
            String string = step.toString();
            builder.append('\t').append(string);
            ThrowableProxyUtil.subjoinPackagingData((StringBuilder)builder, (StackTraceElementProxy)step);
            builder.append(CoreConstants.LINE_SEPARATOR);
        }
        System.out.println(builder.toString());
    }

    static {
        Method method = null;
        try {
            method = Throwable.class.getMethod("getSuppressed", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        GET_SUPPRESSED_METHOD = method;
    }
}

