/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AyncAppenderImpl;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class AppenderAttachableImpl<E>
implements AppenderAttachable<E> {
    private final CopyOnWriteArrayList<Appender<E>> appenderList = new CopyOnWriteArrayList();
    private final AyncAppenderImpl ayncAppender = new AyncAppenderImpl(this.appenderList);

    public void addAppender(Appender<E> newAppender) {
        if (newAppender == null) {
            throw new IllegalArgumentException("Null argument disallowed");
        }
        this.appenderList.addIfAbsent(newAppender);
    }

    public int appendLoopOnAppenders(E e) {
        this.ayncAppender.doAppend(e);
        return this.appenderList.size();
    }

    public Iterator<Appender<E>> iteratorForAppenders() {
        return this.appenderList.iterator();
    }

    public Appender<E> getAppender(String name) {
        if (name == null) {
            return null;
        }
        for (Appender<E> appender : this.appenderList) {
            if (!name.equals(appender.getName())) continue;
            return appender;
        }
        return null;
    }

    public boolean isAttached(Appender<E> appender) {
        if (appender == null) {
            return false;
        }
        for (Appender<E> a : this.appenderList) {
            if (a != appender) continue;
            return true;
        }
        return false;
    }

    public void detachAndStopAllAppenders() {
        for (Appender<E> a : this.appenderList) {
            a.stop();
        }
        this.appenderList.clear();
    }

    public boolean detachAppender(Appender<E> appender) {
        if (appender == null) {
            return false;
        }
        boolean result = this.appenderList.remove(appender);
        return result;
    }

    public boolean detachAppender(String name) {
        if (name == null) {
            return false;
        }
        boolean removed = false;
        for (Appender<E> a : this.appenderList) {
            if (!name.equals(a.getName())) continue;
            removed = this.appenderList.remove(a);
            break;
        }
        return removed;
    }
}

