/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.classic.Level;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class LogSpecialLevel {
    private static final String logspecialconfigkey = "log.special.level.config";
    private static Log log = LogFactory.getLog(LogSpecialLevel.class.getName());
    private static Map<String, Map<String, Level>> levelMaps = new ConcurrentHashMap<String, Map<String, Level>>();

    public static Level getLevel(Map<String, String> taginfo) {
        if (levelMaps.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, Map<String, Level>> entry : levelMaps.entrySet()) {
            String curVal = taginfo.get(entry.getKey());
            if (curVal == null) continue;
            Map<String, Level> valueLevelMap = entry.getValue();
            return valueLevelMap.get(curVal);
        }
        return null;
    }

    private static void parseConfig(String specialConfig) {
        try {
            levelMaps.clear();
            if (specialConfig == null || specialConfig.length() == 0) {
                return;
            }
            Properties prop = new Properties();
            prop.load(new StringReader(specialConfig));
            for (String key : prop.stringPropertyNames()) {
                String[] keys = key.split("\\.");
                String field = keys[0];
                String level = keys[1];
                String[] values = prop.getProperty(key).split(",|;");
                Map valueMap = levelMaps.computeIfAbsent(field, k -> new ConcurrentHashMap());
                for (String value : values) {
                    valueMap.put(value, Level.toLevel((String)level));
                }
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    static {
        ConfigurationUtil.observeChange((String)logspecialconfigkey, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                String specialConfig = System.getProperty(LogSpecialLevel.logspecialconfigkey);
                LogSpecialLevel.parseConfig(specialConfig);
            }
        });
        String specialConfig = System.getProperty(logspecialconfigkey);
        LogSpecialLevel.parseConfig(specialConfig);
    }
}

