/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logging.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.LockSupport;
import kd.bos.config.client.ConfigurationFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logging.logback.SpecialLevelFilter;
import kd.bos.logging.logback.output.KDLineOfCallerConverter;
import kd.bos.logging.logback.output.KDMessageConverter;
import kd.bos.logging.logback.output.KDMethodOfCallerConverter;
import kd.bos.logging.slf4j.Slf4JLoggerImpl;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackFactory
extends LogFactory {
    private static String CONFIG_KEY = "log.config";
    private static final Logger logger = LoggerFactory.getLogger(LogbackFactory.class);
    private static Appender<ILoggingEvent> consoleAppender;
    private static final ConcurrentMap<String, Slf4JLoggerImpl> logMap;

    public LogbackFactory() {
        this.initPattern();
        this.initConfig();
        this.initListener();
    }

    private void initConfig() {
        String config = ConfigurationFactory.getGlobalConfiguration().getProperty(CONFIG_KEY);
        if (config == null) {
            throw new Error(CONFIG_KEY + " not configured.");
        }
        System.out.println("-----log.config value-----");
        System.out.println(config);
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (int i = 0; i < 10; ++i) {
            int oldStatusListSize = loggerContext.getStatusManager().getCopyOfStatusList().size();
            JoranConfigurator jc = new JoranConfigurator();
            jc.setContext((Context)loggerContext);
            loggerContext.reset();
            try {
                jc.doConfigure((InputStream)new ByteArrayInputStream(config.getBytes(Charsets.UTF_8)));
                loggerContext.addTurboFilter((TurboFilter)new SpecialLevelFilter());
            }
            catch (JoranException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                System.out.println("-----log.config doConfigure error-----");
                ex.printStackTrace();
            }
            int newStatusListSize = loggerContext.getStatusManager().getCopyOfStatusList().size();
            if (oldStatusListSize != newStatusListSize) {
                System.out.println("-----log.config doConfigure success-----,fori=" + i + ",oldStatusListSize=" + oldStatusListSize + ",newStatusListSize=" + newStatusListSize);
                break;
            }
            System.out.println("-----log.config doConfigure,nothing changed-----,fori=" + i + ",statusListSize=" + oldStatusListSize);
            LockSupport.parkNanos(1000000000L);
        }
        this.initConsoleAppender(loggerContext);
    }

    private void initConsoleAppender(LoggerContext loggerContext) {
        List loggerList = loggerContext.getLoggerList();
        for (ch.qos.logback.classic.Logger tempLogger : loggerList) {
            Appender tempStdotAppender = tempLogger.getAppender("stdot");
            if (tempStdotAppender == null) continue;
            consoleAppender = tempStdotAppender;
            break;
        }
        if (consoleAppender != null) {
            Logger stdotLog = LoggerFactory.getLogger((String)"stdot");
            ch.qos.logback.classic.Logger stdotLogLogbackLogger = (ch.qos.logback.classic.Logger)stdotLog;
            stdotLogLogbackLogger.addAppender(consoleAppender);
            stdotLogLogbackLogger.setAdditive(true);
            Logger stdotOnlyLog = LoggerFactory.getLogger((String)"stdot-only");
            ch.qos.logback.classic.Logger stdotOnlyLogLogbackLogger = (ch.qos.logback.classic.Logger)stdotOnlyLog;
            stdotOnlyLogLogbackLogger.addAppender(consoleAppender);
            stdotOnlyLogLogbackLogger.setAdditive(false);
        }
    }

    private void initListener() {
        ConfigurationUtil.observeChange((String)CONFIG_KEY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                logger.info("\u6536\u5230\u65e5\u5fd7\u914d\u7f6e\u6587\u4ef6log.config\u6539\u53d8\u4e8b\u4ef6\uff0c\u4fee\u6539\u540e\u7684\u914d\u7f6e\u4e3a\uff1a {}", newValue);
                LogbackFactory.this.initConfig();
            }
        });
    }

    private void initPattern() {
        PatternLayout.defaultConverterMap.put("L", KDLineOfCallerConverter.class.getName());
        PatternLayout.defaultConverterMap.put("line", KDLineOfCallerConverter.class.getName());
        PatternLayout.defaultConverterMap.put("M", KDMethodOfCallerConverter.class.getName());
        PatternLayout.defaultConverterMap.put("method", KDMethodOfCallerConverter.class.getName());
        PatternLayout.defaultConverterMap.put("m", KDMessageConverter.class.getName());
        PatternLayout.defaultConverterMap.put("message", KDMessageConverter.class.getName());
        PatternLayout.defaultConverterMap.put("msg", KDMessageConverter.class.getName());
    }

    @Override
    protected Log _getLog(String name) {
        Slf4JLoggerImpl oldLog;
        Slf4JLoggerImpl log = (Slf4JLoggerImpl)logMap.get(name);
        if (log == null && (oldLog = logMap.putIfAbsent(name, log = new Slf4JLoggerImpl(name))) != null) {
            return oldLog;
        }
        return log;
    }

    public static Appender<ILoggingEvent> getConsoleAppender() {
        return consoleAppender;
    }

    static {
        logMap = new ConcurrentHashMap<String, Slf4JLoggerImpl>();
    }
}

