/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logging.logback.filter;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.spi.FilterReply;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.context.OperationContext;
import kd.bos.instance.Instance;
import kd.bos.logging.logback.filter.Rule;
import kd.bos.logging.logback.filter.RuleNode;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.StringUtils;

public class LogFilter {
    private static final AtomicReference<Map<String, RuleNode>> className_ruleNode_map = new AtomicReference();
    private static final AtomicReference<Map<String, List<Rule>>> className_availableRuleList_map = new AtomicReference();
    private static final String ROOT = "ROOT";

    private LogFilter() {
    }

    public static void updateRule(List<Rule> ruleList) {
        RuleNode tempRuleNode;
        String tempClassName;
        if (ruleList == null) {
            return;
        }
        if (ruleList.size() == 0) {
            className_ruleNode_map.set(new HashMap());
            className_availableRuleList_map.set(new HashMap());
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        HashMap<String, RuleNode> new_className_ruleNode_map = new HashMap<String, RuleNode>();
        RuleNode rootRuleNode = new RuleNode();
        new_className_ruleNode_map.put(ROOT, rootRuleNode);
        ArrayList<String> allClassNameList = new ArrayList<String>();
        for (Rule tempRule : ruleList) {
            if (StringUtils.isNotEmpty((String)tempRule.getAppName()) && !tempRule.getAppName().equals(Instance.getAppName()) || tempRule.getStartTime() > 0L && tempRule.getStartTime() > currentTimeMillis) continue;
            tempClassName = tempRule.getClassName();
            if (StringUtils.isEmpty((String)tempClassName)) {
                tempClassName = ROOT;
            } else if (!allClassNameList.contains(tempClassName)) {
                allClassNameList.add(tempClassName);
            }
            tempRuleNode = new_className_ruleNode_map.computeIfAbsent(tempClassName, key -> new RuleNode());
            tempRuleNode.setClassName(tempClassName);
            tempRuleNode.getAvaiableRuleList().add(tempRule);
        }
        allClassNameList.sort((o1, o2) -> o2.split("\\.").length - o1.split("\\.").length);
        ArrayList<String> copyAllClassNameList = new ArrayList<String>(allClassNameList.size());
        copyAllClassNameList.addAll(allClassNameList);
        Iterator classNameIt = allClassNameList.iterator();
        while (classNameIt.hasNext()) {
            tempClassName = (String)classNameIt.next();
            tempRuleNode = (RuleNode)new_className_ruleNode_map.get(tempClassName);
            if (!tempClassName.contains(".")) {
                tempRuleNode.setParentRuleNode(rootRuleNode);
                classNameIt.remove();
                copyAllClassNameList.remove(tempClassName);
                continue;
            }
            List<String> allParentPackage = LogFilter.getAllParentPackage(tempClassName);
            for (String tempParentPackage : allParentPackage) {
                if (!copyAllClassNameList.contains(tempParentPackage)) continue;
                RuleNode parentRuleNode = (RuleNode)new_className_ruleNode_map.get(tempParentPackage);
                tempRuleNode.setParentRuleNode(parentRuleNode);
                classNameIt.remove();
                copyAllClassNameList.remove(tempClassName);
                break;
            }
            if (tempRuleNode.getParentRuleNode() != null) continue;
            tempRuleNode.setParentRuleNode(rootRuleNode);
            classNameIt.remove();
            copyAllClassNameList.remove(tempClassName);
        }
        className_ruleNode_map.set(new_className_ruleNode_map);
        className_availableRuleList_map.set(new HashMap());
    }

    private static List<String> getAllParentPackage(String className) {
        if (!className.contains(".")) {
            return Collections.singletonList(className);
        }
        String[] parts = className.split("\\.");
        ArrayList<String> allParentClassNameList = new ArrayList<String>(8);
        for (int i = 1; i < parts.length; ++i) {
            StringBuilder parentName = new StringBuilder();
            for (int j = 0; j < i; ++j) {
                parentName.append(parts[j]);
                if (j >= i - 1) continue;
                parentName.append(".");
            }
            allParentClassNameList.add(parentName.toString());
        }
        Collections.reverse(allParentClassNameList);
        return allParentClassNameList;
    }

    private static List<Rule> getAllParentRule(String loggerName) {
        List<Rule> ruleList = className_availableRuleList_map.get().get(loggerName);
        if (ruleList != null) {
            return ruleList;
        }
        if (className_ruleNode_map.get().size() == 0) {
            return Collections.emptyList();
        }
        RuleNode ruleNode = className_ruleNode_map.get().get(loggerName);
        if (ruleNode == null) {
            List<String> allParentPackage = LogFilter.getAllParentPackage(loggerName);
            for (String tempPackage : allParentPackage) {
                ruleNode = className_ruleNode_map.get().get(tempPackage);
                if (ruleNode == null) continue;
                break;
            }
        }
        if (ruleNode == null) {
            List<Rule> rootAvaiableRuleList = className_ruleNode_map.get().get(ROOT).getAvaiableRuleList();
            className_availableRuleList_map.get().putIfAbsent(loggerName, rootAvaiableRuleList);
            return rootAvaiableRuleList;
        }
        ArrayList<Rule> allAvaiableRuleList = new ArrayList<Rule>();
        while (ruleNode.getParentRuleNode() != null) {
            allAvaiableRuleList.addAll(ruleNode.getAvaiableRuleList());
            ruleNode = ruleNode.getParentRuleNode();
        }
        className_availableRuleList_map.get().putIfAbsent(loggerName, allAvaiableRuleList);
        return allAvaiableRuleList;
    }

    public static FilterReply decide(Logger logger, Level level) {
        OperationContext oc;
        List<Rule> ruleList = LogFilter.getAllParentRule(logger.getName());
        if (ruleList.isEmpty()) {
            return FilterReply.NEUTRAL;
        }
        String appId = null;
        String accountId = null;
        String tenantId = null;
        String formId = null;
        String userId = null;
        String userName = null;
        Map truck = (Map)ThreadTruck.get((Object)"rcinfo");
        if (truck != null) {
            accountId = (String)truck.get("accountId");
            userId = (String)truck.get("userId");
            userName = (String)truck.get("userName");
            tenantId = (String)truck.get("tenantId");
        }
        if ((oc = OperationContext.get()) != null) {
            appId = oc.getAppId();
            if (tenantId == null) {
                tenantId = oc.getTenantId();
            }
            formId = oc.getFormId();
        }
        Rule matchRule = null;
        for (Rule rule : ruleList) {
            if (matchRule != null) {
                if (matchRule.getLevel() <= rule.getLevel()) continue;
                if (matchRule.getSort() != rule.getSort()) break;
            }
            if (!LogFilter.match(rule, appId, accountId, tenantId, formId, userId, userName)) continue;
            matchRule = rule;
        }
        if (matchRule != null) {
            return LogFilter.getFilterReply(matchRule.getLevel(), level);
        }
        return FilterReply.NEUTRAL;
    }

    private static FilterReply getFilterReply(int expectLevel, Level level) {
        if (expectLevel <= level.levelInt) {
            return FilterReply.ACCEPT;
        }
        return FilterReply.DENY;
    }

    private static boolean match(Rule rule, String appId, String accountId, String tenantId, String formId, String userId, String userName) {
        return LogFilter.equals(rule.getAppId(), appId) && LogFilter.equals(rule.getAccountId(), accountId) && LogFilter.equals(rule.getTenantId(), tenantId) && LogFilter.equals(rule.getFormId(), formId) && LogFilter.equals(rule.getUserId(), userId) && LogFilter.equals(rule.getUserName(), userName);
    }

    private static boolean equals(String expect, String actual) {
        if (expect == null) {
            return true;
        }
        return Objects.equals(expect, actual);
    }

    static {
        HashMap emptyRuleNodeMap = new HashMap();
        className_ruleNode_map.set(emptyRuleNodeMap);
        HashMap emptyRuleListMap = new HashMap();
        className_availableRuleList_map.set(emptyRuleListMap);
    }
}

