/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logging.logback.kafka;

import java.util.Properties;
import java.util.concurrent.Future;
import kd.bos.logging.logback.kafka.IKafkaSender;
import kd.bos.logging.logback.kafka.KafkaMessage;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaSender<T>
implements IKafkaSender<T> {
    private Properties props;
    private Producer<String, T> producer;

    public KafkaSender(Properties props) {
        this.props = props;
    }

    public Properties getProps() {
        return this.props;
    }

    @Override
    public void send(KafkaMessage<T> kafkaMsg) {
        if (this.producer == null) {
            this.producer = new KafkaProducer(this.props);
        }
        if (kafkaMsg.getTopic() == null) {
            throw new RuntimeException("Kafka producer topic can not be null");
        }
        try {
            Future future = this.producer.send(new ProducerRecord(kafkaMsg.getTopic(), kafkaMsg.getMsg()));
            future.get();
        }
        catch (Exception e) {
            throw new RuntimeException("Kafka send error", e);
        }
    }

    @Override
    public void close() {
        if (this.producer != null) {
            this.producer.close();
        }
    }
}

