/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.serverless.hw;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cloud.apigateway.sdk.utils.Client;
import com.cloud.apigateway.sdk.utils.Request;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.serverless.api.StatusEnum;
import kd.bos.serverless.container.EnvVariable;
import kd.bos.serverless.container.ServerlessContainer;
import kd.bos.serverless.core.JobStatusCache;
import kd.bos.serverless.hw.TemplateUtil;
import kd.bos.threads.ThreadPools;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HWServerlessContainer
implements ServerlessContainer {
    private static final String PODS = "/pods";
    private static final String SERVERLESS_EXCEPTION = "serverlessException:";
    private static Log log = LogFactory.getLog(HWServerlessContainer.class);
    private static final String RESPONSE_BODY = "responseBody";
    private static final String STATUS_CODE = "statusCode";
    private static final int STATUS_201 = 201;
    private static final int STATUS_200 = 200;
    private static final String API_V_NAMESPACES = "/api/v1/namespaces/";
    public static final int ONE_CPU_MIN_MEMORY = 2048;
    public static final int ONE_CPU_MAX_MEMORY = 8192;
    private static final CopyOnWriteArrayList<String> jobIdList = new CopyOnWriteArrayList();

    public void start(String imageUrl, String jobId, double cpu, int memory, Map<String, String> envVariables) {
        envVariables.put("serverless.jobid", jobId);
        String urlPrefix = HWServerlessContainer.getUrlPrefix();
        String namespace = HWServerlessContainer.getNamespace();
        String requestUrl = urlPrefix + API_V_NAMESPACES + namespace + PODS;
        String requestBodyJson = TemplateUtil.loadTemplate("/createpodjson.template");
        requestBodyJson = requestBodyJson.replace("{{imageUrl}}", imageUrl);
        int finalMemory = memory;
        double finalCpu = cpu;
        int minMemory = (int)(cpu * 2048.0);
        int maxMemory = (int)(cpu * 8192.0);
        if (memory <= minMemory) {
            finalMemory = minMemory;
        } else if (memory > maxMemory) {
            while (memory > maxMemory) {
                finalCpu += 1.0;
                maxMemory = (int)(cpu * 8192.0);
            }
            finalMemory = maxMemory;
        }
        finalMemory = finalMemory / 1024 * 1024;
        requestBodyJson = requestBodyJson.replace("{{cpu}}", String.valueOf(finalCpu));
        requestBodyJson = requestBodyJson.replace("{{memory}}", String.valueOf(finalMemory));
        String podName = HWServerlessContainer.getPodName(jobId);
        requestBodyJson = requestBodyJson.replace("{{podName}}", podName);
        String containerName = ("container-" + jobId).replace("_", "-").toLowerCase();
        requestBodyJson = requestBodyJson.replace("{{containerName}}", containerName);
        JSONArray envJSONArray = new JSONArray();
        for (Map.Entry<String, String> entry : envVariables.entrySet()) {
            JSONObject o = new JSONObject();
            o.put("name", (Object)entry.getKey());
            o.put("value", (Object)entry.getValue());
            envJSONArray.add((Object)o);
        }
        Request request = HWServerlessContainer.getRequest("POST", requestUrl, requestBodyJson = requestBodyJson.replace("{{env}}", envJSONArray.toJSONString()));
        Map<String, Object> map = HWServerlessContainer.excuteRequest(request);
        if ((Integer)map.get(STATUS_CODE) != 201) {
            String erroMsg = "start hw serverless error statusCode=" + map.get(STATUS_CODE) + "  " + map.get(RESPONSE_BODY);
            throw new KDException(BosErrorCode.serverlessException, new Object[]{erroMsg});
        }
        jobIdList.add(jobId);
    }

    private static String getPodName(String jobId) {
        return ("pod-" + jobId).replace("_", "-").toLowerCase();
    }

    public void delete(String jobId) {
        HWServerlessContainer.remove(jobId);
    }

    private static void remove(String jobId) {
        String requestBodyJson;
        String podName = HWServerlessContainer.getPodName(jobId);
        String urlPrefix = HWServerlessContainer.getUrlPrefix();
        String namespace = HWServerlessContainer.getNamespace();
        String requestUrl = urlPrefix + API_V_NAMESPACES + namespace + PODS + "/" + podName;
        Request request = HWServerlessContainer.getRequest("DELETE", requestUrl, requestBodyJson = TemplateUtil.loadTemplate("/deletepodjson.template"));
        Map<String, Object> map = HWServerlessContainer.excuteRequest(request);
        if ((Integer)map.get(STATUS_CODE) != 200) {
            String erroMsg = "delete hw serverless error statusCode=" + map.get(STATUS_CODE) + "  " + map.get(RESPONSE_BODY);
            throw new KDException(BosErrorCode.serverlessException, new Object[]{erroMsg});
        }
    }

    private static String getUrlPrefix() {
        String httpsStr = "https://";
        String endPoint = (String)EnvVariable.getHWConfigMap().get("cciEndpoint");
        if (!endPoint.startsWith(httpsStr)) {
            endPoint = httpsStr + endPoint;
        }
        if (endPoint.endsWith("/")) {
            endPoint = endPoint.substring(0, endPoint.length() - 1);
        }
        return endPoint;
    }

    private static String getNamespace() {
        return (String)EnvVariable.getHWConfigMap().get("cciNameSpace");
    }

    private static String getContainerStatus(String jobId) {
        String podName = HWServerlessContainer.getPodName(jobId);
        String urlPrefix = HWServerlessContainer.getUrlPrefix();
        String namespace = HWServerlessContainer.getNamespace();
        String statusUrl = urlPrefix + API_V_NAMESPACES + namespace + PODS + "/" + podName + "/status";
        Request requestStatus = HWServerlessContainer.getRequest("GET", statusUrl, null);
        Map<String, Object> map = HWServerlessContainer.excuteRequest(requestStatus);
        if ((Integer)map.get(STATUS_CODE) != 200) {
            String erroMsg = "get status error statusCode=" + map.get(STATUS_CODE) + "  " + map.get(RESPONSE_BODY);
            throw new KDException(BosErrorCode.serverlessException, new Object[]{erroMsg});
        }
        JSONObject jsonData = JSONObject.parseObject((String)((String)map.get(RESPONSE_BODY)));
        JSONObject status = (JSONObject)jsonData.get((Object)"status");
        return (String)status.get((Object)"phase");
    }

    private static String getContainerLog(String jobId) {
        String podName = HWServerlessContainer.getPodName(jobId);
        String urlPrefix = HWServerlessContainer.getUrlPrefix();
        String namespace = HWServerlessContainer.getNamespace();
        String statusUrl = urlPrefix + API_V_NAMESPACES + namespace + PODS + "/" + podName + "/log";
        Request requestStatus = HWServerlessContainer.getRequest("GET", statusUrl, null);
        Map<String, Object> map = HWServerlessContainer.excuteRequest(requestStatus);
        if ((Integer)map.get(STATUS_CODE) != 200) {
            String erroMsg = "get status error statusCode=" + map.get(STATUS_CODE) + "  " + map.get(RESPONSE_BODY);
            throw new KDException(BosErrorCode.serverlessException, new Object[]{erroMsg});
        }
        return (String)map.get(RESPONSE_BODY);
    }

    private static Map<String, Object> excuteRequest(Request request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CloseableHttpClient client = null;
        try {
            HttpRequestBase signedRequest = Client.sign((Request)request);
            client = HttpClients.custom().build();
            CloseableHttpResponse response = client.execute((HttpUriRequest)signedRequest);
            int statusCode = response.getStatusLine().getStatusCode();
            result.put(STATUS_CODE, statusCode);
            HttpEntity resEntity = response.getEntity();
            if (resEntity != null) {
                result.put(RESPONSE_BODY, EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8"));
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.serverlessException, "excuteRequest error:", (Throwable)e);
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (IOException e) {
                log.error("serverlessException:client close", (Throwable)e);
            }
        }
        return result;
    }

    private static Request getRequest(String method, String url, String body) {
        Request request = new Request();
        try {
            String akStr = (String)EnvVariable.getHWConfigMap().get("accessKeyId");
            String skStr = (String)EnvVariable.getHWConfigMap().get("secretAccessKey");
            request.setKey(akStr);
            request.setSecret(skStr);
            request.setMethod(method);
            request.setUrl(url);
            request.addHeader("Content-Type", "application/json");
            if (body != null) {
                request.setBody(body);
            }
        }
        catch (Exception e) {
            log.error("serverlessException:get Request error,", (Throwable)e);
            throw new KDException(BosErrorCode.serverlessException, "get Request error:", (Throwable)e);
        }
        return request;
    }

    static {
        ThreadPools.executeOnce((String)"Serverless-ContainerStatusRunnable", (Runnable)new ContainerStatusRunnable());
    }

    static class ContainerStatusRunnable
    implements Runnable {
        ContainerStatusRunnable() {
        }

        @Override
        public void run() {
            long waitTime = 10000L;
            while (true) {
                try {
                    block3: while (true) {
                        Thread.sleep(waitTime);
                        Iterator iterator = jobIdList.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block3;
                            String jobId = (String)iterator.next();
                            this.dealJob(jobId);
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    log.error(HWServerlessContainer.SERVERLESS_EXCEPTION, (Throwable)e);
                    continue;
                }
                break;
            }
        }

        private void dealJob(String jobId) {
            if (JobStatusCache.getStatus((String)jobId) != null) {
                jobIdList.remove(jobId);
            } else {
                String status = HWServerlessContainer.getContainerStatus(jobId);
                if (status.equalsIgnoreCase("Failed") || status.equalsIgnoreCase("Unknown")) {
                    String containerlog = HWServerlessContainer.getContainerLog(jobId);
                    JobStatusCache.cacheStatus((String)jobId, (StatusEnum)StatusEnum.ERROR, (String)("hw pod create Exception:" + containerlog));
                    HWServerlessContainer.remove(jobId);
                }
            }
        }
    }
}

