/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.id;

public class Base39Coder {
    private static final char[] CHARS;
    private static final int RADIX;
    private static final int[] VALUES;

    public static long toLong(String s) {
        try {
            long v = 0L;
            for (char ch : s.toCharArray()) {
                int vch = VALUES[ch];
                if (vch == -1) {
                    throw new IllegalArgumentException("ID " + s + " has unreconized character: " + ch);
                }
                v = v * (long)RADIX + (long)vch;
            }
            return v;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("ID " + s + " has unreconized character", e);
        }
    }

    public static String toString(long v) {
        StringBuilder sb = new StringBuilder(12);
        do {
            sb.append(CHARS[(int)(v % (long)RADIX)]);
        } while ((v /= (long)RADIX) != 0L);
        return sb.reverse().toString();
    }

    static {
        int i;
        CHARS = "+/0123456789=ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        RADIX = CHARS.length;
        VALUES = new int[CHARS[RADIX - 1] + '\u0001'];
        for (i = 0; i < CHARS[RADIX - 1]; ++i) {
            Base39Coder.VALUES[i] = -1;
        }
        i = 0;
        for (char ch : CHARS) {
            Base39Coder.VALUES[ch] = i++;
        }
    }
}

